/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tair;

import com.taobao.tair.etc.TairUtil;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class DataEntry
implements Serializable {
    private static final long serialVersionUID = -3492001385938512871L;
    private static byte[] DEFAULT_DATA = new byte[29];
    private Object key;
    private Object value;
    private int magic;
    private int checkSum;
    private int keySize;
    private int version;
    private int padSize;
    private int valueSize;
    private int flag;
    private int cdate;
    private int mdate;
    private int edate;

    public DataEntry() {
    }

    public DataEntry(Object value) {
        this.value = value;
    }

    public DataEntry(Object key, Object value) {
        this.key = key;
        this.value = value;
    }

    public DataEntry(Object key, Object value, int version) {
        this.key = key;
        this.value = value;
        this.version = version;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void decodeMeta(ByteBuffer bytes) {
        this.magic = bytes.getShort();
        this.checkSum = bytes.getShort();
        this.keySize = bytes.getShort();
        this.version = bytes.getShort();
        this.padSize = bytes.getInt();
        this.valueSize = bytes.getInt();
        this.flag = bytes.get();
        this.cdate = bytes.getInt();
        this.mdate = bytes.getInt();
        this.edate = bytes.getInt();
    }

    public static void encodeMeta(ByteBuffer bytes) {
        bytes.put(DEFAULT_DATA);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("key: ").append(this.key);
        sb.append(", value: ").append(this.value);
        sb.append(", version: ").append(this.version).append("\n\t");
        sb.append("cdate: ").append(TairUtil.formatDate(this.cdate)).append("\n\t");
        sb.append("mdate: ").append(TairUtil.formatDate(this.mdate)).append("\n\t");
        sb.append("edate: ").append(this.edate > 0 ? TairUtil.formatDate(this.edate) : "NEVER").append("\n");
        return sb.toString();
    }
}

