/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.client;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.client.ClientApplication;
import com.stormpath.sdk.client.ClientBuilder;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;

@Deprecated
public class ClientApplicationBuilder {
    private static final String DOUBLE_SLASH = "//";
    private static final String ENCODING = "UTF-8";
    private String applicationHref;
    private final ClientBuilder clientBuilder;

    public ClientApplicationBuilder() {
        this.clientBuilder = new ClientBuilder();
    }

    protected ClientApplicationBuilder(ClientBuilder builder) {
        this.clientBuilder = builder;
    }

    public ClientApplicationBuilder setApiKeyProperties(Properties properties) {
        this.clientBuilder.setApiKeyProperties(properties);
        return this;
    }

    public ClientApplicationBuilder setApiKeyReader(Reader reader) {
        this.clientBuilder.setApiKeyReader(reader);
        return this;
    }

    public ClientApplicationBuilder setApiKeyInputStream(InputStream is) {
        this.clientBuilder.setApiKeyInputStream(is);
        return this;
    }

    public ClientApplicationBuilder setApiKeyFileLocation(String location) {
        this.clientBuilder.setApiKeyFileLocation(location);
        return this;
    }

    public ClientApplicationBuilder setApiKeyIdPropertyName(String apiKeyIdPropertyName) {
        this.clientBuilder.setApiKeyIdPropertyName(apiKeyIdPropertyName);
        return this;
    }

    public ClientApplicationBuilder setApiKeySecretPropertyName(String apiKeySecretPropertyName) {
        this.clientBuilder.setApiKeySecretPropertyName(apiKeySecretPropertyName);
        return this;
    }

    ClientApplicationBuilder setBaseUrl(String baseUrl) {
        this.clientBuilder.setBaseUrl(baseUrl);
        return this;
    }

    public ClientApplicationBuilder setApplicationHref(String applicationHref) {
        this.applicationHref = applicationHref;
        return this;
    }

    public ClientApplication build() {
        String href;
        String string = href = this.applicationHref != null ? this.applicationHref.trim() : null;
        if (href == null || href.equals("")) {
            String msg = "'applicationHref' property must be specified when using this builder implementation.";
            throw new IllegalArgumentException(msg);
        }
        String cleanedHref = href;
        int atSignIndex = href.indexOf(64);
        if (atSignIndex > 0) {
            String[] parts = this.getHrefWithUserInfo(href, atSignIndex);
            cleanedHref = parts[0] + parts[2];
            parts = parts[1].split(":", 2);
            Properties apiKeyProperties = this.createApiKeyProperties(parts);
            this.setApiKeyProperties(apiKeyProperties);
        }
        Client client = this.buildClient();
        Application application = client.getDataStore().getResource(cleanedHref, Application.class);
        return new ClientApplication(client, application);
    }

    protected Client buildClient() {
        return this.clientBuilder.build();
    }

    protected String[] getHrefWithUserInfo(String href, int atSignIndex) {
        int doubleSlashIndex = href.indexOf(DOUBLE_SLASH);
        if (doubleSlashIndex <= 0) {
            throw new IllegalArgumentException("Invalid application href URL");
        }
        String[] parts = new String[]{href.substring(0, doubleSlashIndex + DOUBLE_SLASH.length()), href.substring(doubleSlashIndex + DOUBLE_SLASH.length(), atSignIndex), href.substring(atSignIndex + 1)};
        return parts;
    }

    protected Properties createApiKeyProperties(String[] pair) {
        if (pair == null || pair.length != 2) {
            String msg = "applicationHref userInfo segment must consist of the following format: apiKeyId:apiKeySecret";
            throw new IllegalArgumentException(msg);
        }
        Properties props = new Properties();
        props.put("apiKey.id", this.urlDecode(pair[0]));
        props.put("apiKey.secret", this.urlDecode(pair[1]));
        return props;
    }

    protected String urlDecode(String s) {
        try {
            return this.urlDecode(s, ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unable to URL decode userInfo fragment: " + s, e);
        }
    }

    protected String urlDecode(String s, String encoding) throws UnsupportedEncodingException {
        return URLDecoder.decode(s, encoding);
    }
}

