/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.ReplicaGroup;
import com.sequoiadb.base.SDBMessage;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.base.SequoiadbConstants;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.util.SDBMessageHelper;
import java.nio.ByteBuffer;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class Node {
    private String hostName;
    private int port;
    private String nodeName;
    private int id;
    private ReplicaGroup rg;
    private Sequoiadb ddb;
    private NodeStatus status;

    Node(String hostName, int port, int nodeId, ReplicaGroup rg) {
        this.rg = rg;
        this.hostName = hostName;
        this.port = port;
        this.nodeName = hostName + ":" + port;
        this.id = nodeId;
    }

    public int getNodeId() {
        return this.id;
    }

    public ReplicaGroup getReplicaGroup() {
        return this.rg;
    }

    public void disconnect() throws BaseException {
        this.ddb.disconnect();
    }

    public Sequoiadb connect() throws BaseException {
        this.ddb = new Sequoiadb(this.hostName, this.port, this.rg.getSequoiadb().getUserName(), this.rg.getSequoiadb().getPassword());
        return this.ddb;
    }

    public Sequoiadb connect(String username, String password) throws BaseException {
        this.ddb = new Sequoiadb(this.hostName, this.port, username, password);
        return this.ddb;
    }

    public Sequoiadb getSdb() {
        return this.ddb;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public NodeStatus getStatus() throws BaseException {
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("GroupID", (Object)this.rg.getId());
        obj.put("NodeID", (Object)this.id);
        String commandString = "snapshot database";
        SDBMessage rtn = this.adminCommand(commandString, obj);
        int flags = rtn.getFlags();
        if (flags != 0) {
            if (flags == new BaseException("SDB_NET_CANNOT_CONNECT", new Object[0]).getErrorCode()) {
                this.status = NodeStatus.SDB_NODE_INACTIVE;
                return this.status;
            }
            throw new BaseException(flags, new Object[0]);
        }
        this.status = NodeStatus.SDB_NODE_ACTIVE;
        return this.status;
    }

    public void start() throws BaseException {
        this.startStop(true);
    }

    public void stop() throws BaseException {
        this.startStop(false);
    }

    private void startStop(boolean status) {
        BasicBSONObject config = new BasicBSONObject();
        config.put("HostName", (Object)this.hostName);
        config.put("svcname", (Object)Integer.toString(this.port));
        SDBMessage rtn = this.adminCommand(status ? "startup node" : "shutdown node", config);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, this.hostName, this.port);
        }
    }

    private SDBMessage adminCommand(String commandString, BSONObject obj) throws BaseException {
        BasicBSONObject dummyObj = new BasicBSONObject();
        SDBMessage sdbMessage = new SDBMessage();
        sdbMessage.setMatcher(obj);
        sdbMessage.setCollectionFullName("$" + commandString);
        sdbMessage.setVersion(1);
        sdbMessage.setW((short)0);
        sdbMessage.setPadding((short)0);
        sdbMessage.setFlags(0);
        sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        sdbMessage.setRequestID(this.rg.getSequoiadb().getNextRequstID());
        sdbMessage.setSkipRowsCount(-1L);
        sdbMessage.setReturnRowsCount(-1L);
        sdbMessage.setSelector(dummyObj);
        sdbMessage.setOrderBy(dummyObj);
        sdbMessage.setHint(dummyObj);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_QUERY);
        boolean endianConver = this.rg.getSequoiadb().endianConvert;
        byte[] request = SDBMessageHelper.buildQueryRequest(sdbMessage, endianConver);
        this.rg.getSequoiadb().getConnection().sendMessage(request);
        ByteBuffer byteBuffer = this.rg.getSequoiadb().getConnection().receiveMessage(endianConver);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        SDBMessageHelper.checkMessage(sdbMessage, rtnSDBMessage);
        return rtnSDBMessage;
    }

    public static enum NodeStatus {
        SDB_NODE_ALL(1),
        SDB_NODE_ACTIVE(2),
        SDB_NODE_INACTIVE(3),
        SDB_NODE_UNKNOWN(4);

        private final int key;

        private NodeStatus(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static NodeStatus getByKey(int key) {
            NodeStatus nodeStatus = SDB_NODE_ALL;
            for (NodeStatus status : NodeStatus.values()) {
                if (status.getKey() != key) continue;
                nodeStatus = status;
                break;
            }
            return nodeStatus;
        }
    }
}

