/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.uuid;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.UUID;

public final class FastUUID {
    private static final MethodHandle STRING_FACTORY;
    private static final int NUM_ALPHA_DIFF = 7;
    private static final int LOWER_UPPER_DIFF = 32;
    private static final char[] DIGITS;

    private FastUUID() {
    }

    public static UUID fromString(String str) {
        try {
            int dashCount = 4;
            int[] dashPos = new int[6];
            dashPos[0] = -1;
            dashPos[5] = str.length();
            for (int i = str.length() - 1; i >= 0; --i) {
                if (str.charAt(i) != '-') continue;
                if (dashCount == 0) {
                    throw new IllegalArgumentException("Too many dashes (-)");
                }
                dashPos[dashCount--] = i;
            }
            if (dashCount > 0) {
                throw new IllegalArgumentException("Not enough dashes (-)");
            }
            long mostSigBits = FastUUID.decode(str, dashPos, 0) & 0xFFFFFFFFL;
            mostSigBits <<= 16;
            mostSigBits |= FastUUID.decode(str, dashPos, 1) & 0xFFFFL;
            mostSigBits <<= 16;
            long leastSigBits = FastUUID.decode(str, dashPos, 3) & 0xFFFFL;
            leastSigBits <<= 48;
            return new UUID(mostSigBits |= FastUUID.decode(str, dashPos, 2) & 0xFFFFL, leastSigBits |= FastUUID.decode(str, dashPos, 4) & 0xFFFFFFFFFFFFL);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid UUID string: " + str, e);
        }
    }

    @VisibleForTesting
    static long decode(String str, int[] dashPos, int field) {
        int start = dashPos[field] + 1;
        int end = dashPos[field + 1];
        if (start >= end) {
            throw new IllegalArgumentException(String.format("In call to decode(), start (%d) >= end (%d)", start, end));
        }
        if (end - start > 16) {
            throw new NumberFormatException("long overflow");
        }
        long curr = 0L;
        for (int i = start; i < end; ++i) {
            curr <<= 4;
            curr |= (long)FastUUID.getNibbleFromChar(str.charAt(i));
        }
        return curr;
    }

    static int getNibbleFromChar(char c) {
        int x = c - 48;
        if (x > 9) {
            if ((x -= 7) > 15) {
                x -= 32;
            }
            if (x < 10) {
                throw new IllegalArgumentException(c + " is not a valid character for an UUID string");
            }
        }
        if (x < 0 || x > 15) {
            throw new IllegalArgumentException(c + " is not a valid character for an UUID string");
        }
        return x;
    }

    public static String toString(UUID uuid) {
        return FastUUID.toString(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static String toString(long msb, long lsb) {
        char[] uuidChars = new char[36];
        FastUUID.digits(uuidChars, 0, 8, msb >> 32);
        uuidChars[8] = 45;
        FastUUID.digits(uuidChars, 9, 4, msb >> 16);
        uuidChars[13] = 45;
        FastUUID.digits(uuidChars, 14, 4, msb);
        uuidChars[18] = 45;
        FastUUID.digits(uuidChars, 19, 4, lsb >> 48);
        uuidChars[23] = 45;
        FastUUID.digits(uuidChars, 24, 12, lsb);
        try {
            return STRING_FACTORY.invokeExact(uuidChars);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void digits(char[] dest, int offset, int digits, long val) {
        long hi = 1L << digits * 4;
        FastUUID.toUnsignedString(dest, offset, digits, hi | val & hi - 1L, 4);
    }

    private static void toUnsignedString(char[] dest, int offset, int len, long value, int shift) {
        int charPos = len;
        int radix = 1 << shift;
        long mask = radix - 1;
        long i = value;
        do {
            dest[offset + --charPos] = DIGITS[(int)(i & mask)];
        } while ((i >>>= shift) != 0L && charPos > 0);
    }

    static {
        MethodHandle factory;
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        Constructor constructor = null;
        try {
            constructor = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            factory = MethodHandles.lookup().findConstructor(String.class, MethodType.methodType(Void.TYPE, char[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        if (constructor != null) {
            try {
                MethodHandle fastFactory = MethodHandles.insertArguments(MethodHandles.lookup().unreflectConstructor(constructor), 1, true);
                char[] unsharedChars = "test".toCharArray();
                String testString = fastFactory.invokeExact(unsharedChars);
                Preconditions.checkState((boolean)"test".equals(testString));
                unsharedChars[0] = 114;
                Preconditions.checkState((boolean)"rest".equals(testString));
                factory = fastFactory;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        STRING_FACTORY = factory;
    }
}

