/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.util;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class Optionals {
    public static <X> Optional<X> unless(@Nonnull Optional<X> first, Supplier<X> second) {
        return first.isPresent() ? first : Optional.of(second.get());
    }

    public static <X> Optional<X> unlessOpt(@Nonnull Optional<X> first, Supplier<Optional<X>> second) {
        return first.isPresent() ? first : second.get();
    }

    public static <K, V> MapAdapter<K, V> mapAdapter(Map<K, V> map) {
        return key -> Optional.ofNullable(map.get(key));
    }

    public static <T> Stream<T> stream(Optional<T> source) {
        return source.map(Stream::of).orElseGet(Stream::empty);
    }

    public static <T> Optional<T> firstInList(List<T> list) {
        return list.isEmpty() ? Optional.empty() : Optional.ofNullable(list.get(0));
    }

    public static <K, V> Optional<V> getOpt(Map<K, V> map, K key) {
        return Optional.ofNullable(map.get(key));
    }

    @FunctionalInterface
    public static interface MapAdapter<K, V> {
        public Optional<V> getOpt(K var1);
    }
}

