/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.util;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JvmFallbackShutdown {
    private static final Logger LOG = LoggerFactory.getLogger(JvmFallbackShutdown.class);

    public static void fallbackTerminate(Duration waitTime) {
        Thread fallbackTerminateThread = new Thread(() -> JvmFallbackShutdown.fallbackKill(waitTime));
        fallbackTerminateThread.setName("T-1000");
        fallbackTerminateThread.setDaemon(true);
        fallbackTerminateThread.start();
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    private static void fallbackKill(Duration waitTime) {
        LOG.info("Service problem detected, fallback kill in {}...", (Object)waitTime.toString().substring(2));
        try {
            Thread.sleep(waitTime.toMillis());
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            LOG.error("in terminate thread", (Throwable)e2);
        }
        Thread.getAllStackTraces().entrySet().stream().filter(e -> !((Thread)e.getKey()).isDaemon()).filter(e -> ((Thread)e.getKey()).getState() != Thread.State.TERMINATED).forEach(e -> {
            Thread t = (Thread)e.getKey();
            LOG.error("Thread {} {} '{}': \n{}\n", new Object[]{t.getId(), t.getState(), t.getName(), Joiner.on((char)'\n').join((Object[])e.getValue())});
        });
        LOG.error("===UNCLEAN SHUTDOWN===");
        System.exit(254);
    }
}

