/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.util;

import com.opentable.function.ThrowingConsumer;
import com.opentable.function.ThrowingFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionSwallower {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionSwallower.class);

    public static Runnable swallowExceptions(Runnable in) {
        return () -> {
            block3: {
                try {
                    in.run();
                }
                catch (Throwable t) {
                    LOGGER.error("Uncaught exception swallowed", t);
                    if (t instanceof Error) {
                        throw t;
                    }
                    if (!(t instanceof InterruptedException)) break block3;
                    Thread.currentThread().interrupt();
                }
            }
        };
    }

    public static <T> Consumer<T> swallowExceptions(ThrowingConsumer<T> in) {
        return item -> {
            block3: {
                try {
                    in.accept(item);
                }
                catch (Throwable t) {
                    LOGGER.error("Uncaught exception swallowed", t);
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (!(t instanceof InterruptedException)) break block3;
                    Thread.currentThread().interrupt();
                }
            }
        };
    }

    public static <A, B> Function<A, B> forFunction(ThrowingFunction<A, B> in) {
        return item -> {
            try {
                return in.apply(item);
            }
            catch (Throwable t) {
                LOGGER.error("Uncaught exception swallowed", t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }
        };
    }
}

