/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.callback;

import com.opentable.callback.Callback;
import com.opentable.callback.CallbackRefusedException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Callbacks {
    private static final Logger LOG = LoggerFactory.getLogger(Callbacks.class);
    public static final Callback<Object> NOOP = new NoopCallback();

    private Callbacks() {
    }

    @SafeVarargs
    public static <T> void stream(Callback<T> callback, T ... items) throws Exception {
        Callbacks.stream(callback, Arrays.asList(items));
    }

    public static <T> void stream(Callback<T> callback, Iterable<T> iterable) throws Exception {
        for (T item : iterable) {
            try {
                callback.call(item);
            }
            catch (CallbackRefusedException e) {
                LOG.trace("callback refused", (Throwable)e);
                return;
            }
        }
    }

    public static <T> Callback<T> noop() {
        return NOOP;
    }

    @SafeVarargs
    public static <T> Callback<T> chain(Callback<T> ... callbacks) {
        return Callbacks.chain(Arrays.asList(callbacks));
    }

    public static <T> Callback<T> chain(Iterable<Callback<T>> callbacks) {
        return new ChainCallback<T>(callbacks);
    }

    private static class ChainCallback<T>
    implements Callback<T> {
        private final Iterable<Callback<T>> callbacks;

        ChainCallback(Iterable<Callback<T>> callbacks) {
            this.callbacks = callbacks;
        }

        @Override
        public void call(T item) throws Exception {
            for (Callback<T> callback : this.callbacks) {
                callback.call(item);
            }
        }
    }

    private static class NoopCallback
    implements Callback<Object> {
        private NoopCallback() {
        }

        @Override
        public void call(Object item) throws Exception {
        }
    }
}

