/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.callback;

import com.google.common.base.Throwables;
import com.opentable.callback.Callback;
import com.opentable.callback.CallbackRefusedException;
import com.opentable.callback.ExecutorBatchingCallback;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;

public class BatchingCallback<T>
implements Callback<T>,
Closeable {
    private final BlockingQueue<T> list;
    private final Callback<? super List<T>> out;
    private final int size;

    BatchingCallback(int size, Callback<? super List<T>> out) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive, was " + size);
        }
        if (out == null) {
            throw new IllegalArgumentException("Null callback");
        }
        this.size = size;
        this.list = new ArrayBlockingQueue<T>(size);
        this.out = out;
    }

    public static <T> BatchingCallback<T> batchInto(int size, Callback<? super List<T>> out) {
        return new BatchingCallback<T>(size, out);
    }

    public static <T> BatchingCallback<T> batchInto(int size, ExecutorService executor, Callback<? super List<T>> out, boolean failFast) {
        return new ExecutorBatchingCallback(size, executor, out, failFast);
    }

    @Override
    public void call(T item) throws CallbackRefusedException {
        while (!this.list.offer(item)) {
            this.commitInternal();
        }
    }

    @Override
    public void close() {
        this.commit();
    }

    public boolean commit() {
        try {
            this.commitInternal();
            return true;
        }
        catch (CallbackRefusedException e) {
            return false;
        }
    }

    Callback<? super List<T>> getOut() {
        return this.out;
    }

    private void commitInternal() throws CallbackRefusedException {
        ArrayList outList = new ArrayList(this.size);
        this.list.drainTo(outList);
        if (!outList.isEmpty()) {
            try {
                this.out.call(outList);
            }
            catch (Exception e) {
                Throwables.propagateIfInstanceOf((Throwable)e, CallbackRefusedException.class);
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

