/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.monitor.CompositeMonitor;
import com.netflix.servo.monitor.Counter;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.ResettableCounter;
import com.netflix.servo.tag.TagList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicCounter
implements CompositeMonitor<Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicCounter.class);
    private static final String DEFAULT_EXPIRATION = "15";
    private static final String DEFAULT_EXPIRATION_UNIT = "MINUTES";
    private static final String CLASS_NAME = DynamicCounter.class.getCanonicalName();
    private static final String EXPIRATION_PROP = CLASS_NAME + ".expiration";
    private static final String EXPIRATION_PROP_UNIT = CLASS_NAME + ".expirationUnit";
    private static final String INTERNAL_ID = "servoCounters";
    private static final String CACHE_MONITOR_ID = "servoCountersCache";
    private static final MonitorConfig BASE_CONFIG = new MonitorConfig.Builder("servoCounters").build();
    private static final DynamicCounter INSTANCE = new DynamicCounter();
    private final LoadingCache<MonitorConfig, Counter> counters;
    private final CompositeMonitor<?> cacheMonitor;

    private DynamicCounter() {
        String expiration = System.getProperty(EXPIRATION_PROP, DEFAULT_EXPIRATION);
        String expirationUnit = System.getProperty(EXPIRATION_PROP_UNIT, DEFAULT_EXPIRATION_UNIT);
        long expirationValue = Long.valueOf(expiration);
        TimeUnit expirationUnitValue = TimeUnit.valueOf(expirationUnit);
        this.counters = CacheBuilder.newBuilder().expireAfterAccess(expirationValue, expirationUnitValue).build((CacheLoader)new CacheLoader<MonitorConfig, Counter>(){

            public Counter load(MonitorConfig config) throws Exception {
                return new ResettableCounter(config);
            }
        });
        this.cacheMonitor = Monitors.newCacheMonitor(CACHE_MONITOR_ID, this.counters);
        DefaultMonitorRegistry.getInstance().register(this);
    }

    private Counter get(MonitorConfig config) {
        try {
            return (Counter)this.counters.get((Object)config);
        }
        catch (ExecutionException e) {
            LOGGER.error("Failed to get a counter for {}: {}", (Object)config, (Object)e.getMessage());
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void increment(MonitorConfig config) {
        INSTANCE.get(config).increment();
    }

    public static void increment(String name, String ... tags) {
        MonitorConfig.Builder configBuilder = MonitorConfig.builder(name);
        Preconditions.checkArgument((tags.length % 2 == 0 ? 1 : 0) != 0, (Object)"The sequence of (key, value) pairs must have even size: one key, one value");
        try {
            for (int i = 0; i < tags.length; i += 2) {
                configBuilder.withTag(tags[i], tags[i + 1]);
            }
            DynamicCounter.increment(configBuilder.build());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to get a counter to increment: {}", (Object)e.getMessage());
        }
    }

    public static void increment(MonitorConfig config, long delta) {
        INSTANCE.get(config).increment(delta);
    }

    public static void increment(String name, TagList list) {
        MonitorConfig config = new MonitorConfig.Builder(name).withTags(list).build();
        DynamicCounter.increment(config);
    }

    public static void increment(String name, TagList list, long delta) {
        MonitorConfig config = MonitorConfig.builder(name).withTags(list).build();
        DynamicCounter.increment(config, delta);
    }

    @Override
    public List<Monitor<?>> getMonitors() {
        ConcurrentMap countersMap = this.counters.asMap();
        return ImmutableList.copyOf(countersMap.values());
    }

    @Override
    public Long getValue() {
        return this.counters.asMap().size();
    }

    @Override
    public MonitorConfig getConfig() {
        return BASE_CONFIG;
    }

    public String toString() {
        ConcurrentMap map = this.counters.asMap();
        return Objects.toStringHelper((Object)this).add("baseConfig", (Object)BASE_CONFIG).add("totalCounters", map.size()).add("counters", (Object)map).toString();
    }
}

