/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.AbstractCommand;
import com.netflix.hystrix.HystrixCachedObservable;
import com.netflix.hystrix.HystrixEventType;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;

public class HystrixCommandResponseFromCache<R>
extends HystrixCachedObservable<R> {
    private final AbstractCommand<R> originalCommand;

    HystrixCommandResponseFromCache(Observable<R> originalObservable, AbstractCommand<R> originalCommand) {
        super(originalObservable);
        this.originalCommand = originalCommand;
    }

    public Observable<R> toObservableWithStateCopiedInto(final AbstractCommand<R> commandToCopyStateInto) {
        final AtomicBoolean completionLogicRun = new AtomicBoolean(false);
        return this.cachedObservable.doOnError((Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                if (!completionLogicRun.get()) {
                    HystrixCommandResponseFromCache.this.commandCompleted(commandToCopyStateInto);
                    completionLogicRun.set(true);
                }
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                if (!completionLogicRun.get()) {
                    HystrixCommandResponseFromCache.this.commandCompleted(commandToCopyStateInto);
                    completionLogicRun.set(true);
                }
            }
        }).doOnUnsubscribe(new Action0(){

            public void call() {
                if (!completionLogicRun.get()) {
                    HystrixCommandResponseFromCache.this.commandUnsubscribed(commandToCopyStateInto);
                    completionLogicRun.set(true);
                }
            }
        });
    }

    private void commandCompleted(AbstractCommand<R> commandToCopyStateInto) {
        commandToCopyStateInto.executionResult = this.originalCommand.executionResult;
    }

    private void commandUnsubscribed(AbstractCommand<R> commandToCopyStateInto) {
        commandToCopyStateInto.executionResult = commandToCopyStateInto.executionResult.addEvent(HystrixEventType.CANCELLED);
        commandToCopyStateInto.executionResult = commandToCopyStateInto.executionResult.setExecutionLatency(-1);
    }
}

