/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixEventType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class ExecutionResult {
    private final EventCounts eventCounts;
    private final Exception failedExecutionException;
    private final Exception executionException;
    private final long startTimestamp;
    private final int executionLatency;
    private final int userThreadLatency;
    private final boolean executionOccurred;
    private final boolean isExecutedInThread;
    private final HystrixCollapserKey collapserKey;
    private static final HystrixEventType[] ALL_EVENT_TYPES = HystrixEventType.values();
    private static final int NUM_EVENT_TYPES = ALL_EVENT_TYPES.length;
    private static final BitSet EXCEPTION_PRODUCING_EVENTS = new BitSet(NUM_EVENT_TYPES);
    static ExecutionResult EMPTY;

    private ExecutionResult(EventCounts eventCounts, long startTimestamp, int executionLatency, int userThreadLatency, Exception failedExecutionException, Exception executionException, boolean executionOccurred, boolean isExecutedInThread, HystrixCollapserKey collapserKey) {
        this.eventCounts = eventCounts;
        this.startTimestamp = startTimestamp;
        this.executionLatency = executionLatency;
        this.userThreadLatency = userThreadLatency;
        this.failedExecutionException = failedExecutionException;
        this.executionException = executionException;
        this.executionOccurred = executionOccurred;
        this.isExecutedInThread = isExecutedInThread;
        this.collapserKey = collapserKey;
    }

    public static ExecutionResult from(HystrixEventType ... eventTypes) {
        boolean didExecutionOccur = false;
        for (HystrixEventType eventType : eventTypes) {
            if (!ExecutionResult.didExecutionOccur(eventType)) continue;
            didExecutionOccur = true;
        }
        return new ExecutionResult(new EventCounts(eventTypes), -1L, -1, -1, null, null, didExecutionOccur, false, null);
    }

    private static boolean didExecutionOccur(HystrixEventType eventType) {
        switch (eventType) {
            case SUCCESS: {
                return true;
            }
            case FAILURE: {
                return true;
            }
            case BAD_REQUEST: {
                return true;
            }
            case TIMEOUT: {
                return true;
            }
            case CANCELLED: {
                return true;
            }
        }
        return false;
    }

    public ExecutionResult setExecutionOccurred() {
        return new ExecutionResult(this.eventCounts, this.startTimestamp, this.executionLatency, this.userThreadLatency, this.failedExecutionException, this.executionException, true, this.isExecutedInThread, this.collapserKey);
    }

    public ExecutionResult setExecutionLatency(int executionLatency) {
        return new ExecutionResult(this.eventCounts, this.startTimestamp, executionLatency, this.userThreadLatency, this.failedExecutionException, this.executionException, this.executionOccurred, this.isExecutedInThread, this.collapserKey);
    }

    public ExecutionResult setException(Exception e) {
        return new ExecutionResult(this.eventCounts, this.startTimestamp, this.executionLatency, this.userThreadLatency, e, this.executionException, this.executionOccurred, this.isExecutedInThread, this.collapserKey);
    }

    public ExecutionResult setExecutionException(Exception executionException) {
        return new ExecutionResult(this.eventCounts, this.startTimestamp, this.executionLatency, this.userThreadLatency, this.failedExecutionException, executionException, this.executionOccurred, this.isExecutedInThread, this.collapserKey);
    }

    public ExecutionResult setInvocationStartTime(long startTimestamp) {
        return new ExecutionResult(this.eventCounts, startTimestamp, this.executionLatency, this.userThreadLatency, this.failedExecutionException, this.executionException, this.executionOccurred, this.isExecutedInThread, this.collapserKey);
    }

    public ExecutionResult setExecutedInThread() {
        return new ExecutionResult(this.eventCounts, this.startTimestamp, this.executionLatency, this.userThreadLatency, this.failedExecutionException, this.executionException, this.executionOccurred, true, this.collapserKey);
    }

    public ExecutionResult setNotExecutedInThread() {
        return new ExecutionResult(this.eventCounts, this.startTimestamp, this.executionLatency, this.userThreadLatency, this.failedExecutionException, this.executionException, this.executionOccurred, false, this.collapserKey);
    }

    public ExecutionResult markCollapsed(HystrixCollapserKey collapserKey, int sizeOfBatch) {
        return new ExecutionResult(this.eventCounts.plus(HystrixEventType.COLLAPSED, sizeOfBatch), this.startTimestamp, this.executionLatency, this.userThreadLatency, this.failedExecutionException, this.executionException, this.executionOccurred, this.isExecutedInThread, collapserKey);
    }

    public ExecutionResult markUserThreadCompletion(long userThreadLatency) {
        if (this.startTimestamp > 0L && !this.isResponseRejected()) {
            return new ExecutionResult(this.eventCounts, this.startTimestamp, this.executionLatency, (int)userThreadLatency, this.failedExecutionException, this.executionException, this.executionOccurred, this.isExecutedInThread, this.collapserKey);
        }
        return this;
    }

    public ExecutionResult addEvent(HystrixEventType eventType) {
        return new ExecutionResult(this.eventCounts.plus(eventType), this.startTimestamp, this.executionLatency, this.userThreadLatency, this.failedExecutionException, this.executionException, this.executionOccurred, this.isExecutedInThread, this.collapserKey);
    }

    public ExecutionResult addEvent(int executionLatency, HystrixEventType eventType) {
        if (this.startTimestamp >= 0L && !this.isResponseRejected()) {
            return new ExecutionResult(this.eventCounts.plus(eventType), this.startTimestamp, executionLatency, this.userThreadLatency, this.failedExecutionException, this.executionException, this.executionOccurred, this.isExecutedInThread, this.collapserKey);
        }
        return this.addEvent(eventType);
    }

    public EventCounts getEventCounts() {
        return this.eventCounts;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public int getExecutionLatency() {
        return this.executionLatency;
    }

    public int getUserThreadLatency() {
        return this.userThreadLatency;
    }

    public long getCommandRunStartTimeInNanos() {
        return this.startTimestamp * 1000L * 1000L;
    }

    public Exception getException() {
        return this.failedExecutionException;
    }

    public Exception getExecutionException() {
        return this.executionException;
    }

    public HystrixCollapserKey getCollapserKey() {
        return this.collapserKey;
    }

    public boolean isResponseSemaphoreRejected() {
        return this.eventCounts.contains(HystrixEventType.SEMAPHORE_REJECTED);
    }

    public boolean isResponseThreadPoolRejected() {
        return this.eventCounts.contains(HystrixEventType.THREAD_POOL_REJECTED);
    }

    public boolean isResponseRejected() {
        return this.isResponseThreadPoolRejected() || this.isResponseSemaphoreRejected();
    }

    public List<HystrixEventType> getOrderedList() {
        ArrayList<HystrixEventType> eventList = new ArrayList<HystrixEventType>();
        for (HystrixEventType eventType : ALL_EVENT_TYPES) {
            if (!this.eventCounts.contains(eventType)) continue;
            eventList.add(eventType);
        }
        return eventList;
    }

    public boolean isExecutedInThread() {
        return this.isExecutedInThread;
    }

    public boolean executionOccurred() {
        return this.executionOccurred;
    }

    public String toString() {
        return "ExecutionResult{eventCounts=" + this.eventCounts + ", failedExecutionException=" + this.failedExecutionException + ", executionException=" + this.executionException + ", startTimestamp=" + this.startTimestamp + ", executionLatency=" + this.executionLatency + ", userThreadLatency=" + this.userThreadLatency + ", executionOccurred=" + this.executionOccurred + ", isExecutedInThread=" + this.isExecutedInThread + ", collapserKey=" + this.collapserKey + '}';
    }

    static {
        for (HystrixEventType eventType : HystrixEventType.EXCEPTION_PRODUCING_EVENT_TYPES) {
            EXCEPTION_PRODUCING_EVENTS.set(eventType.ordinal());
        }
        EMPTY = ExecutionResult.from(new HystrixEventType[0]);
    }

    public static class EventCounts {
        private final BitSet events;
        private final int numEmissions;
        private final int numFallbackEmissions;
        private final int numCollapsed;

        EventCounts() {
            this.events = new BitSet(NUM_EVENT_TYPES);
            this.numEmissions = 0;
            this.numFallbackEmissions = 0;
            this.numCollapsed = 0;
        }

        EventCounts(BitSet events, int numEmissions, int numFallbackEmissions, int numCollapsed) {
            this.events = events;
            this.numEmissions = numEmissions;
            this.numFallbackEmissions = numFallbackEmissions;
            this.numCollapsed = numCollapsed;
        }

        EventCounts(HystrixEventType ... eventTypes) {
            BitSet newBitSet = new BitSet(NUM_EVENT_TYPES);
            int localNumEmits = 0;
            int localNumFallbackEmits = 0;
            int localNumCollapsed = 0;
            block5: for (HystrixEventType eventType : eventTypes) {
                switch (eventType) {
                    case EMIT: {
                        newBitSet.set(HystrixEventType.EMIT.ordinal());
                        ++localNumEmits;
                        continue block5;
                    }
                    case FALLBACK_EMIT: {
                        newBitSet.set(HystrixEventType.FALLBACK_EMIT.ordinal());
                        ++localNumFallbackEmits;
                        continue block5;
                    }
                    case COLLAPSED: {
                        newBitSet.set(HystrixEventType.COLLAPSED.ordinal());
                        ++localNumCollapsed;
                        continue block5;
                    }
                    default: {
                        newBitSet.set(eventType.ordinal());
                    }
                }
            }
            this.events = newBitSet;
            this.numEmissions = localNumEmits;
            this.numFallbackEmissions = localNumFallbackEmits;
            this.numCollapsed = localNumCollapsed;
        }

        EventCounts plus(HystrixEventType eventType) {
            return this.plus(eventType, 1);
        }

        EventCounts plus(HystrixEventType eventType, int count) {
            BitSet newBitSet = (BitSet)this.events.clone();
            int localNumEmits = this.numEmissions;
            int localNumFallbackEmits = this.numFallbackEmissions;
            int localNumCollapsed = this.numCollapsed;
            switch (eventType) {
                case EMIT: {
                    newBitSet.set(HystrixEventType.EMIT.ordinal());
                    localNumEmits += count;
                    break;
                }
                case FALLBACK_EMIT: {
                    newBitSet.set(HystrixEventType.FALLBACK_EMIT.ordinal());
                    localNumFallbackEmits += count;
                    break;
                }
                case COLLAPSED: {
                    newBitSet.set(HystrixEventType.COLLAPSED.ordinal());
                    localNumCollapsed += count;
                    break;
                }
                default: {
                    newBitSet.set(eventType.ordinal());
                }
            }
            return new EventCounts(newBitSet, localNumEmits, localNumFallbackEmits, localNumCollapsed);
        }

        public boolean contains(HystrixEventType eventType) {
            return this.events.get(eventType.ordinal());
        }

        public boolean containsAnyOf(BitSet other) {
            return this.events.intersects(other);
        }

        public int getCount(HystrixEventType eventType) {
            switch (eventType) {
                case EMIT: {
                    return this.numEmissions;
                }
                case FALLBACK_EMIT: {
                    return this.numFallbackEmissions;
                }
                case EXCEPTION_THROWN: {
                    return this.containsAnyOf(EXCEPTION_PRODUCING_EVENTS) ? 1 : 0;
                }
                case COLLAPSED: {
                    return this.numCollapsed;
                }
            }
            return this.contains(eventType) ? 1 : 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventCounts that = (EventCounts)o;
            if (this.numEmissions != that.numEmissions) {
                return false;
            }
            if (this.numFallbackEmissions != that.numFallbackEmissions) {
                return false;
            }
            if (this.numCollapsed != that.numCollapsed) {
                return false;
            }
            return this.events.equals(that.events);
        }

        public int hashCode() {
            int result = this.events.hashCode();
            result = 31 * result + this.numEmissions;
            result = 31 * result + this.numFallbackEmissions;
            result = 31 * result + this.numCollapsed;
            return result;
        }

        public String toString() {
            return "EventCounts{events=" + this.events + ", numEmissions=" + this.numEmissions + ", numFallbackEmissions=" + this.numFallbackEmissions + ", numCollapsed=" + this.numCollapsed + '}';
        }
    }
}

