/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.retry;

import com.netflix.curator.retry.SleepingRetry;

public class RetryUntilElapsed
extends SleepingRetry {
    private final int maxElapsedTimeMs;
    private final int sleepMsBetweenRetries;

    public RetryUntilElapsed(int n, int n2) {
        super(Integer.MAX_VALUE);
        this.maxElapsedTimeMs = n;
        this.sleepMsBetweenRetries = n2;
    }

    @Override
    public boolean allowRetry(int n, long l) {
        return super.allowRetry(n, l) && l < (long)this.maxElapsedTimeMs;
    }

    @Override
    protected int getSleepTimeMs(int n, long l) {
        return this.sleepMsBetweenRetries;
    }
}

