/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.curator.ensemble.exhibitor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.curator.RetryPolicy;
import com.netflix.curator.ensemble.EnsembleProvider;
import com.netflix.curator.ensemble.exhibitor.ExhibitorRestClient;
import com.netflix.curator.ensemble.exhibitor.Exhibitors;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExhibitorEnsembleProvider
implements EnsembleProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AtomicReference<Exhibitors> exhibitors = new AtomicReference();
    private final AtomicReference<Exhibitors> masterExhibitors = new AtomicReference();
    private final ExhibitorRestClient restClient;
    private final String restUriPath;
    private final int pollingMs;
    private final RetryPolicy retryPolicy;
    private final ExecutorService service = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("ExhibitorEnsembleProvider-%d").build());
    private final Random random = new Random();
    private final AtomicReference<String> connectionString = new AtomicReference<String>("");
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private static final String MIME_TYPE = "application/x-www-form-urlencoded";

    public ExhibitorEnsembleProvider(Exhibitors exhibitors, ExhibitorRestClient exhibitorRestClient, String string, int n, RetryPolicy retryPolicy) {
        this.exhibitors.set(exhibitors);
        this.masterExhibitors.set(exhibitors);
        this.restClient = exhibitorRestClient;
        this.restUriPath = string;
        this.pollingMs = n;
        this.retryPolicy = retryPolicy;
    }

    public void setExhibitors(Exhibitors exhibitors) {
        this.exhibitors.set(exhibitors);
        this.masterExhibitors.set(exhibitors);
    }

    public void pollForInitialEnsemble() throws Exception {
        Preconditions.checkState((this.state.get() == State.LATENT ? 1 : 0) != 0, (Object)"Cannot be called after start()");
        this.poll();
    }

    @Override
    public void start() throws Exception {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.LATENT, State.STARTED), (Object)"Already started");
        this.service.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        ExhibitorEnsembleProvider.this.poll();
                        Thread.sleep(ExhibitorEnsembleProvider.this.pollingMs);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((boolean)this.state.compareAndSet(State.STARTED, State.CLOSED), (Object)"Already closed");
        this.service.shutdownNow();
    }

    @Override
    public String getConnectionString() {
        String string = this.connectionString.get();
        if (string == null || string.length() == 0) {
            string = this.exhibitors.get().getBackupConnectionString();
        }
        return string;
    }

    private static Map<String, String> decodeExhibitorList(String string) throws UnsupportedEncodingException {
        HashMap hashMap = Maps.newHashMap();
        for (String string2 : string.split("&")) {
            String[] stringArray = string2.split("=");
            if (stringArray.length != 2) continue;
            hashMap.put(stringArray[0], URLDecoder.decode(stringArray[1], "UTF-8"));
        }
        return hashMap;
    }

    private void poll() {
        long l = System.currentTimeMillis();
        int n = 0;
        boolean bl = false;
        while (!bl) {
            Exhibitors exhibitors = this.exhibitors.get();
            ArrayList arrayList = Lists.newArrayList(exhibitors.getHostnames());
            if (arrayList.size() == 0) {
                bl = true;
                continue;
            }
            String string = (String)arrayList.get(this.random.nextInt(arrayList.size()));
            try {
                String string2 = this.restClient.getRaw(string, exhibitors.getRestPort(), this.restUriPath, MIME_TYPE);
                Map<String, String> map = ExhibitorEnsembleProvider.decodeExhibitorList(string2);
                int n2 = Integer.parseInt(map.get("port"));
                StringBuilder stringBuilder = new StringBuilder();
                ArrayList arrayList2 = Lists.newArrayList();
                int n3 = Integer.parseInt(map.get("count"));
                if (n3 > 0) {
                    Object object;
                    for (int i = 0; i < n3; ++i) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(",");
                        }
                        object = map.get("server" + i);
                        stringBuilder.append((String)object).append(":").append(n2);
                        arrayList2.add(object);
                    }
                    String string3 = stringBuilder.toString();
                    if (!string3.equals(this.connectionString.get())) {
                        this.log.info("Connection string has changed. Old value (%s), new value (%s)", (Object)this.connectionString.get(), (Object)string3);
                    }
                    object = new Exhibitors(arrayList2, exhibitors.getRestPort()){

                        @Override
                        public String getBackupConnectionString() {
                            return ((Exhibitors)ExhibitorEnsembleProvider.this.masterExhibitors.get()).getBackupConnectionString();
                        }
                    };
                    this.connectionString.set(string3);
                    this.exhibitors.set((Exhibitors)object);
                }
                bl = true;
            }
            catch (Throwable throwable) {
                if (this.retryPolicy.allowRetry(n++, System.currentTimeMillis() - l)) {
                    this.log.warn("Couldn't get servers from Exhibitor. Retrying.", throwable);
                    continue;
                }
                this.log.error("Couldn't get servers from Exhibitor. Giving up.", throwable);
                bl = true;
            }
        }
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

