/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb.shard;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.core.CommandLineExecutor;
import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.core.OperatingSystem;
import com.lordofthejars.nosqlunit.core.OperatingSystemResolver;
import com.lordofthejars.nosqlunit.core.OsNameSystemPropertyOperatingSystemResolver;
import com.lordofthejars.nosqlunit.env.SystemEnvironmentVariables;
import com.lordofthejars.nosqlunit.mongodb.MongoDbLowLevelOps;
import com.lordofthejars.nosqlunit.mongodb.MongoDbLowLevelOpsFactory;
import com.lordofthejars.nosqlunit.util.CsvBuilder;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedMongosLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedMongosLifecycleManager.class);
    private static final String LOCALHOST = "localhost";
    protected static final String LOGPATH_ARGUMENT_NAME = "--logpath";
    protected static final String PORT_ARGUMENT_NAME = "--port";
    protected static final String CHUNK_SIZE_ARGUMENT_NAME = "--chunkSize";
    protected static final String CONFIG_DB_ARGUMENT_NAME = "--configdb";
    protected static final String DEFAULT_MONGO_LOGPATH = "logpath";
    protected static final String DEFAULT_MONGO_TARGET_PATH = "target" + File.separatorChar + "mongo-temp";
    protected static final int DEFAULT_CHUNK_SIZE = 1;
    protected static final String MONGODB_BINARY_DIRECTORY = "bin";
    protected static final String MONGOS_EXECUTABLE_X = "mongos";
    protected static final String MONGOS_EXECUTABLE_W = "mongos.exe";
    private static final String DEFAULT_PATH = "mongos";
    private String mongosPath = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"MONGO_HOME");
    private int chunkSize = 1;
    private int port = 27017;
    private String targetPath = DEFAULT_MONGO_TARGET_PATH;
    private String logRelativePath = "logpath";
    private List<String> configDatabases = new ArrayList<String>();
    private Map<String, String> extraCommandArguments = new HashMap<String, String>();
    private List<String> singleCommandArguments = new ArrayList<String>();
    private CommandLineExecutor commandLineExecutor = new CommandLineExecutor();
    private OperatingSystemResolver operatingSystemResolver = new OsNameSystemPropertyOperatingSystemResolver();
    private MongoDbLowLevelOps mongoDbLowLevelOps = MongoDbLowLevelOpsFactory.getSingletonInstance();
    private ProcessRunnable processRunnable;

    public String getHost() {
        return LOCALHOST;
    }

    public int getPort() {
        return this.port;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting {} Mongos instance.", (Object)this.mongosPath);
        File dbPath = this.ensureDbPathDoesNotExitsAndReturnCompositePath();
        if (dbPath.mkdirs()) {
            this.startMongoDBAsADaemon();
            boolean isServerUp = this.assertThatConnectionToMongoDbIsPossible();
            if (!isServerUp) {
                throw new IllegalStateException("Couldn't establish a connection with " + this.mongosPath + " server at /127.0.0.1:" + this.port);
            }
        } else {
            throw new IllegalStateException("Db Path " + dbPath + " could not be created.");
        }
        LOGGER.info("Started {} Mongos instance.", (Object)this.mongosPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() {
        LOGGER.info("Stopping {} Mongos instance.", (Object)this.mongosPath);
        try {
            if (this.processRunnable != null) {
                this.processRunnable.destroyProcess();
            }
        }
        finally {
            this.ensureDbPathDoesNotExitsAndReturnCompositePath();
        }
        LOGGER.info("Stopped {} Mongos instance.", (Object)this.mongosPath);
    }

    private List<String> startMongoDBAsADaemon() throws InterruptedException {
        CountDownLatch processIsReady = new CountDownLatch(1);
        this.processRunnable = new ProcessRunnable(processIsReady);
        Thread thread = new Thread(this.processRunnable);
        thread.start();
        processIsReady.await();
        return this.processRunnable.consoleOutput;
    }

    private List<String> buildOperationSystemProgramAndArguments() {
        ArrayList<String> programAndArguments = new ArrayList<String>();
        programAndArguments.add(this.getExecutablePath());
        programAndArguments.add(PORT_ARGUMENT_NAME);
        programAndArguments.add(Integer.toString(this.port));
        programAndArguments.add(LOGPATH_ARGUMENT_NAME);
        programAndArguments.add(this.logRelativePath);
        programAndArguments.add(CHUNK_SIZE_ARGUMENT_NAME);
        programAndArguments.add(Integer.toString(this.chunkSize));
        programAndArguments.add(CONFIG_DB_ARGUMENT_NAME);
        programAndArguments.add(CsvBuilder.joinFrom(this.configDatabases).trim());
        for (String argument : this.singleCommandArguments) {
            programAndArguments.add(argument);
        }
        for (String argumentName : this.extraCommandArguments.keySet()) {
            programAndArguments.add(argumentName);
            programAndArguments.add(this.extraCommandArguments.get(argumentName));
        }
        return programAndArguments;
    }

    private String getExecutablePath() {
        return this.mongosPath + File.separatorChar + MONGODB_BINARY_DIRECTORY + File.separatorChar + this.mongoExecutable();
    }

    private String mongoExecutable() {
        OperatingSystem operatingSystem = this.operatingSystemResolver.currentOperatingSystem();
        switch (operatingSystem.getFamily()) {
            case WINDOWS: {
                return MONGOS_EXECUTABLE_W;
            }
        }
        return "mongos";
    }

    private boolean assertThatConnectionToMongoDbIsPossible() throws InterruptedException, UnknownHostException {
        return this.mongoDbLowLevelOps.assertThatConnectionIsPossible(LOCALHOST, this.port);
    }

    private File ensureDbPathDoesNotExitsAndReturnCompositePath() {
        File dbPath = new File(this.targetPath + File.separatorChar + "mongos");
        if (dbPath.exists()) {
            IOUtils.deleteDir((File)dbPath);
        }
        return dbPath;
    }

    public void setLogRelativePath(String logRelativePath) {
        this.logRelativePath = logRelativePath;
    }

    public void setMongosPath(String mongodPath) {
        this.mongosPath = mongodPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public void addExtraCommandLineArgument(String argumentName, String argumentValue) {
        this.extraCommandArguments.put(argumentName, argumentValue);
    }

    public void addSingleCommandLineArgument(String argument) {
        this.singleCommandArguments.add(argument);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void addConfigurationDatabase(String hostAndPort) {
        this.configDatabases.add(hostAndPort);
    }

    protected String getMongosPath() {
        return this.mongosPath;
    }

    protected boolean areConfigDatabasesDefined() {
        return this.configDatabases.size() > 0;
    }

    protected void setCommandLineExecutor(CommandLineExecutor commandLineExecutor) {
        this.commandLineExecutor = commandLineExecutor;
    }

    protected void setOperatingSystemResolver(OperatingSystemResolver operatingSystemResolver) {
        this.operatingSystemResolver = operatingSystemResolver;
    }

    protected void setMongoDbLowLevelOps(MongoDbLowLevelOps mongoDbLowLevelOps) {
        this.mongoDbLowLevelOps = mongoDbLowLevelOps;
    }

    public class ProcessRunnable
    implements Runnable {
        private CountDownLatch processIsReady;
        private List<String> consoleOutput;
        private Process process;

        public ProcessRunnable(CountDownLatch processIsReady) {
            this.processIsReady = processIsReady;
        }

        @Override
        public void run() {
            try {
                this.process = this.startProcess();
                this.consoleOutput = this.getConsoleOutput(this.process);
            }
            catch (IOException e) {
                throw this.prepareException(e);
            }
            finally {
                this.processIsReady.countDown();
            }
            try {
                this.process.waitFor();
                if (this.process.exitValue() != 0) {
                    LOGGER.info("Mongos [" + ManagedMongosLifecycleManager.this.mongosPath + ManagedMongosLifecycleManager.PORT_ARGUMENT_NAME + ManagedMongosLifecycleManager.this.port + ManagedMongosLifecycleManager.LOGPATH_ARGUMENT_NAME + ManagedMongosLifecycleManager.this.logRelativePath + "] console output is: " + this.consoleOutput);
                }
            }
            catch (InterruptedException ie) {
                throw this.prepareException(ie);
            }
        }

        public void destroyProcess() {
            if (this.process != null) {
                this.process.destroy();
            }
        }

        private IllegalStateException prepareException(Exception e) {
            return new IllegalStateException("Mongos [" + ManagedMongosLifecycleManager.this.mongosPath + ManagedMongosLifecycleManager.PORT_ARGUMENT_NAME + ManagedMongosLifecycleManager.this.port + ManagedMongosLifecycleManager.LOGPATH_ARGUMENT_NAME + ManagedMongosLifecycleManager.this.logRelativePath + "] could not be started. Next console message was thrown: " + e.getMessage());
        }

        private Process startProcess() throws IOException {
            return ManagedMongosLifecycleManager.this.commandLineExecutor.startProcessInDirectoryAndArguments(ManagedMongosLifecycleManager.this.targetPath, ManagedMongosLifecycleManager.this.buildOperationSystemProgramAndArguments());
        }

        private List<String> getConsoleOutput(Process pwd) throws IOException {
            return ManagedMongosLifecycleManager.this.commandLineExecutor.getConsoleOutput(pwd);
        }
    }
}

