/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb.replicaset;

import com.lordofthejars.nosqlunit.mongodb.ManagedMongoDbLifecycleManager;
import com.lordofthejars.nosqlunit.mongodb.MongoDbCommands;
import com.lordofthejars.nosqlunit.mongodb.MongoDbLowLevelOps;
import com.lordofthejars.nosqlunit.mongodb.MongoDbLowLevelOpsFactory;
import com.lordofthejars.nosqlunit.mongodb.replicaset.ConfigurationDocument;
import com.lordofthejars.nosqlunit.mongodb.replicaset.ReplicaSetGroup;
import com.mongodb.CommandResult;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaSetManagedMongoDb
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicaSetManagedMongoDb.class);
    private ReplicaSetGroup replicaSetGroup;
    private MongoDbLowLevelOps mongoDbLowLevelOps = MongoDbLowLevelOpsFactory.getSingletonInstance();

    protected ReplicaSetManagedMongoDb(ReplicaSetGroup replicaSetGroup) {
        this.replicaSetGroup = replicaSetGroup;
    }

    public String replicaSetName() {
        return this.replicaSetGroup.getReplicaSetName();
    }

    public List<ManagedMongoDbLifecycleManager> getReplicaSetServers() {
        return this.replicaSetGroup.getServers();
    }

    public void shutdownServer(int port) {
        ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager = this.replicaSetGroup.getStartedServer(port);
        if (managedMongoDbLifecycleManager != null) {
            managedMongoDbLifecycleManager.stopEngine();
        }
    }

    public void waitUntilReplicaSetBecomesStable() {
        MongoClient mongoClient;
        try {
            mongoClient = this.getAvailableServersMongoClient();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        this.waitingToBecomeStable(mongoClient);
        mongoClient.close();
    }

    private void waitingToBecomeStable(MongoClient mongoClient) {
        if (this.replicaSetGroup.isAuthenticationSet()) {
            this.mongoDbLowLevelOps.waitUntilReplicaSetBecomeStable(mongoClient, this.replicaSetGroup.numberOfStartedServers(), this.replicaSetGroup.getUsername(), this.replicaSetGroup.getPassword());
        } else {
            this.mongoDbLowLevelOps.waitUntilReplicaSetBecomeStable(mongoClient, this.replicaSetGroup.numberOfStartedServers(), new String[0]);
        }
    }

    public void startupServer(int port) throws Throwable {
        ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager = this.replicaSetGroup.getStoppedServer(port);
        if (managedMongoDbLifecycleManager != null) {
            managedMongoDbLifecycleManager.startEngine();
        }
    }

    public ManagedMongoDbLifecycleManager getServerByPortAndState(int port, boolean state) {
        if (state) {
            return this.replicaSetGroup.getStartedServer(port);
        }
        return this.replicaSetGroup.getStoppedServer(port);
    }

    protected void before() throws Throwable {
        this.wakeUpServers();
        this.replicaSetInitiate();
        this.waitUntilConfigurationSpreadAcrossServersFromDefaultConnection();
    }

    public void startAllReplicaSet() throws Throwable {
        this.before();
    }

    private void waitUntilConfigurationSpreadAcrossServersFromDefaultConnection() throws UnknownHostException {
        MongoClient mongoClient = this.getDefaultMongoClient();
        this.waitingToBecomeStable(mongoClient);
        mongoClient.close();
    }

    protected void after() {
        this.shutdownServers();
    }

    public void stopAllReplicaSet() {
        this.after();
    }

    protected List<ManagedMongoDbLifecycleManager> getServers() {
        return this.replicaSetGroup.getServers();
    }

    protected ConfigurationDocument getConfigurationDocument() {
        return this.replicaSetGroup.getConfiguration();
    }

    private void replicaSetInitiate() throws UnknownHostException {
        CommandResult commandResult = this.runCommandToAdmin(this.getConfigurationDocument());
        LOGGER.info("Command {} has returned {}", (Object)"replSetInitiaite", (Object)commandResult.toString());
    }

    private CommandResult runCommandToAdmin(ConfigurationDocument cmd) throws UnknownHostException {
        MongoClient mongoClient = this.getDefaultMongoClient();
        CommandResult commandResult = null;
        commandResult = this.replicaSetGroup.isAuthenticationSet() ? MongoDbCommands.replicaSetInitiate(mongoClient, cmd, this.replicaSetGroup.getUsername(), this.replicaSetGroup.getPassword()) : MongoDbCommands.replicaSetInitiate(mongoClient, cmd);
        mongoClient.close();
        return commandResult;
    }

    private void shutdownServers() {
        LOGGER.info("Stopping Replica Set servers");
        for (ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager : this.replicaSetGroup.getServers()) {
            if (!this.isServerStarted(managedMongoDbLifecycleManager)) continue;
            managedMongoDbLifecycleManager.stopEngine();
        }
        LOGGER.info("Stopped Replica Set servers");
    }

    private void wakeUpServers() throws Throwable {
        LOGGER.info("Starting Replica Set servers");
        for (ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager : this.replicaSetGroup.getServers()) {
            if (!this.isServerStopped(managedMongoDbLifecycleManager)) continue;
            managedMongoDbLifecycleManager.startEngine();
        }
        LOGGER.info("Started Replica Set servers");
    }

    private boolean isServerStarted(ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager) {
        return managedMongoDbLifecycleManager.isReady();
    }

    private boolean isServerStopped(ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager) {
        return !managedMongoDbLifecycleManager.isReady();
    }

    private MongoClient getAvailableServersMongoClient() throws UnknownHostException {
        ArrayList<ServerAddress> seeds = new ArrayList<ServerAddress>();
        for (ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager : this.replicaSetGroup.getServers()) {
            if (!managedMongoDbLifecycleManager.isReady()) continue;
            ServerAddress serverAddress = new ServerAddress(managedMongoDbLifecycleManager.getHost(), managedMongoDbLifecycleManager.getPort());
            seeds.add(serverAddress);
        }
        return new MongoClient(seeds);
    }

    private MongoClient getDefaultMongoClient() throws UnknownHostException {
        ManagedMongoDbLifecycleManager defaultConnection = this.replicaSetGroup.getDefaultConnection();
        return new MongoClient(defaultConnection.getHost(), defaultConnection.getPort());
    }
}

