/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb.replicaset;

import com.lordofthejars.nosqlunit.mongodb.replicaset.ConfigurationDocument;
import com.lordofthejars.nosqlunit.mongodb.replicaset.Settings;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ReplicaSetConfigurationBuilder {
    public static final String ID_TAG = "_id";
    public static final String PRIORITY_TAG = "priority";
    public static final String HIDDEN_TAG = "hidden";
    public static final String HOST_TAG = "host";
    public static final String VERSION_TAG = "version";
    public static final String SLAVE_DELAY_TAG = "slaveDelay";
    public static final String ARBITER_TAG = "arbiterOnly";
    public static final String VOTES_TAG = "votes";
    public static final String TAGS_TAG = "tags";
    public static final String BUILD_INDEXES_TAG = "buildIndexes";
    public static final String MEMBERS_TAG = "members";
    public static final String SETTINGS_TAG = "settings";
    private BasicDBObjectBuilder configurationBuilder = new BasicDBObjectBuilder();
    private List<DBObject> members = new ArrayList<DBObject>();
    private Settings settings;
    private int numberOfMembers = 0;

    private ReplicaSetConfigurationBuilder() {
    }

    public static final ReplicaSetConfigurationBuilder replicaSetConfiguration(String replicaSetName) {
        ReplicaSetConfigurationBuilder replicaSetConfigurationBuilder = new ReplicaSetConfigurationBuilder();
        replicaSetConfigurationBuilder.replicaSetName(replicaSetName);
        return replicaSetConfigurationBuilder;
    }

    public ReplicaSetConfigurationBuilder replicaSetName(String replicaSetName) {
        this.configurationBuilder.append(ID_TAG, (Object)replicaSetName);
        return this;
    }

    public ReplicaSetConfigurationBuilder version(int version) {
        this.configurationBuilder.append(VERSION_TAG, (Object)version);
        return this;
    }

    public ReplicaSetConfigurationBuilder settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public MemberConfigurationBuilder member(String host) {
        return new MemberConfigurationBuilder(this, host);
    }

    public ConfigurationDocument get() {
        this.configurationBuilder.append(MEMBERS_TAG, this.members);
        if (this.settings != null) {
            this.configurationBuilder.append(SETTINGS_TAG, (Object)this.settings.getSettings());
        }
        return new ConfigurationDocument(this.configurationBuilder.get());
    }

    private void addMember(DBObject member) {
        this.members.add(member);
    }

    public static class SettingsBuilder {
        private static final String GET_LAST_ERROR_DEFAULTS_TAG = "getLastErrorDefaults";
        private static final String GET_LAST_ERROR_MODES_TAG = "getLastErrorModes";
        private BasicDBObjectBuilder basicDBObjectBuilder = new BasicDBObjectBuilder();

        private SettingsBuilder() {
        }

        public static SettingsBuilder settings() {
            return new SettingsBuilder();
        }

        public SettingsBuilder getLastErrorModes(String jsonDocument) {
            DBObject modes = (DBObject)JSON.parse((String)jsonDocument);
            this.basicDBObjectBuilder.append(GET_LAST_ERROR_MODES_TAG, (Object)modes);
            return this;
        }

        public SettingsBuilder getLastErrorDefaults(String jsonDocument) {
            DBObject error = (DBObject)JSON.parse((String)jsonDocument);
            this.basicDBObjectBuilder.append(GET_LAST_ERROR_DEFAULTS_TAG, (Object)error);
            return this;
        }

        public Settings get() {
            return new Settings(this.basicDBObjectBuilder.get());
        }
    }

    public class MemberConfigurationBuilder {
        private DBObject dbObject = new BasicDBObject();
        private ReplicaSetConfigurationBuilder parent;

        private MemberConfigurationBuilder(ReplicaSetConfigurationBuilder replicaSetBuilder, String host) {
            this.parent = replicaSetBuilder;
            this.dbObject.put(ReplicaSetConfigurationBuilder.ID_TAG, (Object)this.parent.numberOfMembers);
            this.dbObject.put(ReplicaSetConfigurationBuilder.HOST_TAG, (Object)host);
            this.parent.numberOfMembers++;
        }

        public MemberConfigurationBuilder priority(int priority) {
            this.dbObject.put(ReplicaSetConfigurationBuilder.PRIORITY_TAG, (Object)priority);
            return this;
        }

        public MemberConfigurationBuilder slaveDelay(long time, TimeUnit unit) {
            this.dbObject.put(ReplicaSetConfigurationBuilder.SLAVE_DELAY_TAG, (Object)TimeUnit.SECONDS.convert(time, unit));
            return this;
        }

        public MemberConfigurationBuilder arbiterOnly() {
            this.dbObject.put(ReplicaSetConfigurationBuilder.ARBITER_TAG, (Object)true);
            return this;
        }

        public MemberConfigurationBuilder votes(int votes) {
            this.dbObject.put(ReplicaSetConfigurationBuilder.VOTES_TAG, (Object)votes);
            return this;
        }

        public MemberConfigurationBuilder buildIndexes() {
            this.dbObject.put(ReplicaSetConfigurationBuilder.BUILD_INDEXES_TAG, (Object)true);
            return this;
        }

        public MemberConfigurationBuilder tags(String ... tags) {
            BasicDBObjectBuilder basicDBObjectBuilder = new BasicDBObjectBuilder();
            for (int i = 0; i < tags.length; i += 2) {
                basicDBObjectBuilder.append(tags[i], (Object)tags[i + 1]);
            }
            this.dbObject.put(ReplicaSetConfigurationBuilder.TAGS_TAG, (Object)basicDBObjectBuilder.get());
            return this;
        }

        public MemberConfigurationBuilder hidden() {
            this.dbObject.put(ReplicaSetConfigurationBuilder.HIDDEN_TAG, (Object)true);
            return this;
        }

        public ReplicaSetConfigurationBuilder configure() {
            this.parent.addMember(this.dbObject);
            return this.parent;
        }
    }
}

