/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb.replicaset;

import com.lordofthejars.nosqlunit.mongodb.ManagedMongoDbLifecycleManager;
import com.lordofthejars.nosqlunit.mongodb.replicaset.ReplicaSetConfigurationBuilder;
import com.lordofthejars.nosqlunit.mongodb.replicaset.ReplicaSetGroup;
import com.lordofthejars.nosqlunit.mongodb.replicaset.ReplicaSetManagedMongoDb;
import com.lordofthejars.nosqlunit.mongodb.replicaset.Settings;
import java.util.concurrent.TimeUnit;

public class ReplicaSetBuilder {
    private static final int DEFAULT_VERSION = 1;
    private String replicaSetName;
    private ReplicaSetGroup replicaSetGroup = new ReplicaSetGroup();
    private ReplicaSetConfigurationBuilder replicaSetConfigurationBuilder;

    private ReplicaSetBuilder() {
    }

    public static ReplicaSetBuilder replicaSet(String name) {
        ReplicaSetBuilder replicaSetBuilder = new ReplicaSetBuilder();
        replicaSetBuilder.replicaSetName = name;
        replicaSetBuilder.replicaSetConfigurationBuilder = ReplicaSetConfigurationBuilder.replicaSetConfiguration(name).version(1);
        return replicaSetBuilder;
    }

    public static ReplicaSetBuilder replicaSet(String name, Settings settings) {
        ReplicaSetBuilder replicaSetBuilder = new ReplicaSetBuilder();
        replicaSetBuilder.replicaSetConfigurationBuilder = ReplicaSetConfigurationBuilder.replicaSetConfiguration(name).version(1).settings(settings);
        replicaSetBuilder.replicaSetName = name;
        return replicaSetBuilder;
    }

    public ReplicaSetBuilder eligible(ManagedMongoDbLifecycleManager managedInstance) {
        return this.server(managedInstance).configure();
    }

    public ReplicaSetBuilder secondary(ManagedMongoDbLifecycleManager managedInstance) {
        return this.server(managedInstance).priority(0).configure();
    }

    public ReplicaSetBuilder hidden(ManagedMongoDbLifecycleManager managedInstance) {
        return this.server(managedInstance).priority(0).hidden().configure();
    }

    public ReplicaSetBuilder delayed(ManagedMongoDbLifecycleManager managedInstance, long time, TimeUnit unit) {
        return this.server(managedInstance).priority(0).slaveDelay(time, unit).configure();
    }

    public ReplicaSetBuilder arbiter(ManagedMongoDbLifecycleManager managedInstance) {
        return this.server(managedInstance).arbiterOnly().configure();
    }

    public ReplicaSetBuilder noneVoter(ManagedMongoDbLifecycleManager managedInstance) {
        return this.server(managedInstance).votes(0).configure();
    }

    public ReplicaSetBuilder withAuthentication(String username, String password) {
        this.replicaSetGroup.setUsername(username);
        this.replicaSetGroup.setPassword(password);
        return this;
    }

    public CustomConfigurationBuilder server(ManagedMongoDbLifecycleManager server) {
        if (!server.isReplicaSetNameSet()) {
            server.setReplicaSetName(this.replicaSetName);
        }
        this.replicaSetGroup.addServer(server);
        return new CustomConfigurationBuilder(this, this.host(server));
    }

    public ReplicaSetManagedMongoDb get() {
        return this.buildReplicaSetRule();
    }

    public ReplicaSetManagedMongoDb get(int index) {
        this.replicaSetGroup.setConnectionIndex(index);
        return this.buildReplicaSetRule();
    }

    private ReplicaSetManagedMongoDb buildReplicaSetRule() {
        this.replicaSetGroup.setConfigurationDocument(this.replicaSetConfigurationBuilder.get());
        return new ReplicaSetManagedMongoDb(this.replicaSetGroup);
    }

    private String host(ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager) {
        return managedMongoDbLifecycleManager.getHost() + ":" + managedMongoDbLifecycleManager.getPort();
    }

    public class CustomConfigurationBuilder {
        private ReplicaSetBuilder parent;
        private ReplicaSetConfigurationBuilder.MemberConfigurationBuilder memberConfigurationBuilder;

        private CustomConfigurationBuilder(ReplicaSetBuilder replicaSetBuilder2, String host) {
            this.parent = replicaSetBuilder2;
            this.memberConfigurationBuilder = this.parent.replicaSetConfigurationBuilder.member(host);
        }

        public CustomConfigurationBuilder priority(int priority) {
            this.memberConfigurationBuilder.priority(priority);
            return this;
        }

        public CustomConfigurationBuilder slaveDelay(long time, TimeUnit unit) {
            this.memberConfigurationBuilder.slaveDelay(time, unit);
            return this;
        }

        public CustomConfigurationBuilder arbiterOnly() {
            this.memberConfigurationBuilder.arbiterOnly();
            return this;
        }

        public CustomConfigurationBuilder votes(int votes) {
            this.memberConfigurationBuilder.votes(votes);
            return this;
        }

        public CustomConfigurationBuilder buildIndexes() {
            this.memberConfigurationBuilder.buildIndexes();
            return this;
        }

        public CustomConfigurationBuilder tags(String ... tags) {
            this.memberConfigurationBuilder.tags(tags);
            return this;
        }

        public CustomConfigurationBuilder hidden() {
            this.memberConfigurationBuilder.hidden();
            return this;
        }

        public ReplicaSetBuilder configure() {
            this.memberConfigurationBuilder.configure();
            return this.parent;
        }
    }
}

