/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import ch.lambdaj.collection.LambdaCollections;
import com.lordofthejars.nosqlunit.core.PropertyGetter;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConfiguration;
import com.lordofthejars.nosqlunit.mongodb.MongoDbRule;
import com.lordofthejars.nosqlunit.mongodb.MongoOperation;
import com.mongodb.Mongo;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.springframework.context.ApplicationContext;

public class SpringMongoDbRule
extends MongoDbRule {
    private PropertyGetter<ApplicationContext> propertyGetter = new PropertyGetter();
    private MongoDbConfiguration mongoDbConfiguration;

    public SpringMongoDbRule(MongoDbConfiguration mongoDbConfiguration) {
        super(mongoDbConfiguration);
        this.mongoDbConfiguration = mongoDbConfiguration;
    }

    public SpringMongoDbRule(MongoDbConfiguration mongoDbConfiguration, Object object) {
        super(mongoDbConfiguration, object);
        this.mongoDbConfiguration = mongoDbConfiguration;
    }

    public Statement apply(Statement base, FrameworkMethod method, Object testObject) {
        this.databaseOperation = new MongoOperation(this.definedMongo(testObject), this.mongoDbConfiguration);
        return super.apply(base, method, testObject);
    }

    private Mongo definedMongo(Object testObject) {
        ApplicationContext applicationContext = (ApplicationContext)this.propertyGetter.propertyByType(testObject, ApplicationContext.class);
        Map beansOfType = applicationContext.getBeansOfType(Mongo.class);
        if (beansOfType == null) {
            throw new IllegalArgumentException("At least one Mongo instance should be defined into Spring Application Context.");
        }
        Mongo mongo = (Mongo)LambdaCollections.with((Map)beansOfType).values().first(CoreMatchers.anything());
        if (mongo == null) {
            throw new IllegalArgumentException("At least one Mongo instance should be defined into Spring Application Context.");
        }
        return mongo;
    }
}

