/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.mongodb.MongoDbCommands;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConfiguration;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class ReplicationMongoDbConfigurationBuilder {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 27017;
    private MongoDbConfiguration mongoDbConfiguration = new MongoDbConfiguration();
    private List<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
    private boolean enableSharding = false;
    private WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;

    private ReplicationMongoDbConfigurationBuilder() {
    }

    public static ReplicationMongoDbConfigurationBuilder replicationMongoDbConfiguration() {
        return new ReplicationMongoDbConfigurationBuilder();
    }

    public ReplicationMongoDbConfigurationBuilder seed(String host, int port) {
        try {
            this.serverAddresses.add(new ServerAddress(host, port));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        return this;
    }

    public ReplicationMongoDbConfigurationBuilder databaseName(String databaseName) {
        this.mongoDbConfiguration.setDatabaseName(databaseName);
        return this;
    }

    public ReplicationMongoDbConfigurationBuilder username(String username) {
        this.mongoDbConfiguration.setUsername(username);
        return this;
    }

    public ReplicationMongoDbConfigurationBuilder password(String password) {
        this.mongoDbConfiguration.setPassword(password);
        return this;
    }

    public ReplicationMongoDbConfigurationBuilder connectionIdentifier(String identifier) {
        this.mongoDbConfiguration.setConnectionIdentifier(identifier);
        return this;
    }

    public ReplicationMongoDbConfigurationBuilder enableSharding() {
        this.enableSharding = true;
        return this;
    }

    public ReplicationMongoDbConfigurationBuilder writeConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    public MongoDbConfiguration configure() {
        if (this.serverAddresses.isEmpty()) {
            this.addDefaultSeed();
        }
        MongoClient mongoClient = new MongoClient(this.serverAddresses);
        if (this.enableSharding) {
            this.enableSharding(mongoClient);
        }
        this.mongoDbConfiguration.setWriteConcern(this.writeConcern);
        this.mongoDbConfiguration.setMongo((Mongo)mongoClient);
        return this.mongoDbConfiguration;
    }

    private void enableSharding(MongoClient mongoClient) {
        if (this.isAuthenticationSet()) {
            MongoDbCommands.enableSharding(mongoClient, this.mongoDbConfiguration.getDatabaseName(), this.mongoDbConfiguration.getUsername(), this.mongoDbConfiguration.getPassword());
        } else {
            MongoDbCommands.enableSharding(mongoClient, this.mongoDbConfiguration.getDatabaseName());
        }
    }

    private boolean isAuthenticationSet() {
        return this.mongoDbConfiguration.getUsername() != null && this.mongoDbConfiguration.getPassword() != null;
    }

    private void addDefaultSeed() {
        try {
            this.serverAddresses.add(new ServerAddress(DEFAULT_HOST, 27017));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

