/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.core.AbstractCustomizableDatabaseOperation;
import com.lordofthejars.nosqlunit.core.NoSqlAssertionError;
import com.lordofthejars.nosqlunit.mongodb.DefaultComparisonStrategy;
import com.lordofthejars.nosqlunit.mongodb.DefaultInsertionStrategy;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConfiguration;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConnectionCallback;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import java.io.InputStream;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoOperation
extends AbstractCustomizableDatabaseOperation<MongoDbConnectionCallback, Mongo> {
    private static Logger LOGGER = LoggerFactory.getLogger(MongoOptions.class);
    private Mongo mongo;
    private MongoDbConfiguration mongoDbConfiguration;

    protected MongoOperation(Mongo mongo, MongoDbConfiguration mongoDbConfiguration) {
        this.mongo = mongo;
        this.mongoDbConfiguration = mongoDbConfiguration;
        this.setInsertionStrategy(new DefaultInsertionStrategy());
        this.setComparisonStrategy(new DefaultComparisonStrategy());
    }

    public MongoOperation(MongoDbConfiguration mongoDbConfiguration) {
        try {
            this.mongo = mongoDbConfiguration.getMongo();
            this.mongo.setWriteConcern(mongoDbConfiguration.getWriteConcern());
            this.mongoDbConfiguration = mongoDbConfiguration;
            this.setInsertionStrategy(new DefaultInsertionStrategy());
            this.setComparisonStrategy(new DefaultComparisonStrategy());
        }
        catch (MongoException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void insert(InputStream contentStream) {
        this.insertData(contentStream);
    }

    private void insertData(InputStream contentStream) {
        try {
            final DB mongoDb = this.getMongoDb();
            this.executeInsertion(new MongoDbConnectionCallback(){

                @Override
                public DB db() {
                    return mongoDb;
                }
            }, contentStream);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Unexpected error reading data set file.", e);
        }
    }

    public void deleteAll() {
        DB mongoDb = this.getMongoDb();
        this.deleteAllElements(mongoDb);
    }

    private void deleteAllElements(DB mongoDb) {
        Set collectionaNames = mongoDb.getCollectionNames();
        for (String collectionName : collectionaNames) {
            if (!this.isNotASystemCollection(collectionName)) continue;
            LOGGER.debug("Dropping Collection {}.", (Object)collectionName);
            DBCollection dbCollection = mongoDb.getCollection(collectionName);
            dbCollection.drop();
        }
    }

    private boolean isNotASystemCollection(String collectionName) {
        return !collectionName.startsWith("system");
    }

    public boolean databaseIs(InputStream contentStream) {
        return this.compareData(contentStream);
    }

    private boolean compareData(InputStream contentStream) throws NoSqlAssertionError {
        try {
            final DB mongoDb = this.getMongoDb();
            this.executeComparison(new MongoDbConnectionCallback(){

                @Override
                public DB db() {
                    return mongoDb;
                }
            }, contentStream);
            return true;
        }
        catch (NoSqlAssertionError e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Unexpected error reading expected data set file.", e);
        }
    }

    private DB getMongoDb() {
        boolean authenticated;
        DB db = this.mongo.getDB(this.mongoDbConfiguration.getDatabaseName());
        if (this.mongoDbConfiguration.isAuthenticateParametersSet() && !db.isAuthenticated() && !(authenticated = db.authenticate(this.mongoDbConfiguration.getUsername(), this.mongoDbConfiguration.getPassword().toCharArray()))) {
            throw new IllegalArgumentException("Login/Password provided to connect to MongoDb are not valid");
        }
        return db;
    }

    public Mongo connectionManager() {
        return this.mongo;
    }
}

