/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.mongodb.BasicDBList;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.HashSet;
import java.util.Set;

public class MongoDbAssertion {
    private static final String SYSTEM_COLLECTIONS_PATTERN = "system.";
    private static final String DATA = "data";

    private MongoDbAssertion() {
    }

    public static final void strictAssertEquals(DBObject expectedData, DB mongoDb) {
        Set collectionaNames = expectedData.keySet();
        Set mongodbCollectionNames = mongoDb.getCollectionNames();
        MongoDbAssertion.checkCollectionsName(collectionaNames, mongodbCollectionNames);
        for (String collectionName : collectionaNames) {
            MongoDbAssertion.checkCollectionObjects(expectedData, mongoDb, collectionaNames, collectionName);
        }
    }

    private static void checkCollectionsName(Set<String> expectedCollectionNames, Set<String> mongodbCollectionNames) {
        Set<String> mongoDbUserCollectionNames = MongoDbAssertion.getUserCollections(mongodbCollectionNames);
        HashSet<String> allCollections = new HashSet<String>(mongoDbUserCollectionNames);
        allCollections.addAll(expectedCollectionNames);
        if (allCollections.size() != expectedCollectionNames.size() || allCollections.size() != mongoDbUserCollectionNames.size()) {
            throw FailureHandler.createFailure((String)"Expected collection names are %s but insert collection names are %s", (Object[])new Object[]{expectedCollectionNames, mongoDbUserCollectionNames});
        }
    }

    private static Set<String> getUserCollections(Set<String> mongodbCollectionNames) {
        HashSet<String> mongoDbUserCollectionNames = new HashSet<String>();
        for (String mongodbCollectionName : mongodbCollectionNames) {
            if (!MongoDbAssertion.isUserCollection(mongodbCollectionName)) continue;
            mongoDbUserCollectionNames.add(mongodbCollectionName);
        }
        return mongoDbUserCollectionNames;
    }

    private static boolean isUserCollection(String mongodbCollectionName) {
        return !mongodbCollectionName.contains(SYSTEM_COLLECTIONS_PATTERN);
    }

    private static void checkCollectionObjects(DBObject expectedData, DB mongoDb, Set<String> collectionaNames, String collectionName) throws Error {
        long insertedDataObjectsCount;
        DBObject object = (DBObject)expectedData.get(collectionName);
        BasicDBList dataObjects = null;
        dataObjects = MongoDbAssertion.isShardOrIndexCollection(object) ? (BasicDBList)object.get(DATA) : (BasicDBList)object;
        DBCollection dbCollection = mongoDb.getCollection(collectionName);
        int expectedDataObjectsCount = dataObjects.size();
        if ((long)expectedDataObjectsCount != (insertedDataObjectsCount = dbCollection.count())) {
            throw FailureHandler.createFailure((String)"Expected collection has %s elements but insert collection has %s", (Object[])new Object[]{expectedDataObjectsCount, insertedDataObjectsCount});
        }
        for (Object dataObject : dataObjects) {
            DBObject expectedDataObject = (DBObject)dataObject;
            DBObject foundObject = dbCollection.findOne(expectedDataObject);
            if (!MongoDbAssertion.exists(foundObject)) {
                throw FailureHandler.createFailure((String)"Object # %s # is not found into collection %s", (Object[])new Object[]{expectedDataObject.toString(), collectionaNames});
            }
            MongoDbAssertion.checkSameKeys(expectedDataObject, foundObject);
        }
    }

    private static boolean isShardOrIndexCollection(DBObject dbObject) {
        return !(dbObject instanceof BasicDBList);
    }

    private static void checkSameKeys(DBObject expectedDataObject, DBObject foundObject) {
        Set expectedKeys = expectedDataObject.keySet();
        Set<String> expectedNoneSystemKeys = MongoDbAssertion.noneSystemKeys(expectedKeys);
        Set foundKeys = foundObject.keySet();
        Set<String> foundNoneSystemKeys = MongoDbAssertion.noneSystemKeys(foundKeys);
        HashSet<String> allKeys = new HashSet<String>(expectedNoneSystemKeys);
        allKeys.addAll(foundNoneSystemKeys);
        if (allKeys.size() != expectedNoneSystemKeys.size() || allKeys.size() != foundNoneSystemKeys.size()) {
            throw FailureHandler.createFailure((String)"Expected DbObject and insert DbObject have different keys: Expected: %s Inserted: %s", (Object[])new Object[]{expectedNoneSystemKeys, foundNoneSystemKeys});
        }
    }

    private static Set<String> noneSystemKeys(Set<String> keys) {
        HashSet<String> noneSystemKeys = new HashSet<String>();
        for (String key : keys) {
            if (key.startsWith("_")) continue;
            noneSystemKeys.add(key);
        }
        return noneSystemKeys;
    }

    private static boolean exists(DBObject foundObject) {
        return foundObject != null;
    }
}

