/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.core.CommandLineExecutor;
import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.core.OperatingSystem;
import com.lordofthejars.nosqlunit.core.OperatingSystemResolver;
import com.lordofthejars.nosqlunit.core.OsNameSystemPropertyOperatingSystemResolver;
import com.lordofthejars.nosqlunit.env.SystemEnvironmentVariables;
import com.lordofthejars.nosqlunit.mongodb.MongoDbLowLevelOps;
import com.lordofthejars.nosqlunit.mongodb.MongoDbLowLevelOpsFactory;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedMongoDbLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedMongoDbLifecycleManager.class);
    private static final String LOCALHOST = "localhost";
    protected static final String CONFIG_SERVER_ENABLED = "--configsvr";
    protected static final String SHARD_SERVER_ENABLED = "--shardsvr";
    protected static final String JOURNALING_ENABLED = "--journal";
    protected static final String NONE_JOURNALING_ENABLED = "--nojournal";
    protected static final String LOGPATH_ARGUMENT_NAME = "--logpath";
    protected static final String DBPATH_ARGUMENT_NAME = "--dbpath";
    protected static final String REPLICA_SET_ARGUMENT_NAME = "--replSet";
    protected static final String PORT_ARGUMENT_NAME = "--port";
    protected static final String DEFAULT_MONGO_LOGPATH = "logpath";
    protected static final String DEFAULT_MONGO_DBPATH = "mongo-dbpath";
    protected static final String DEFAULT_MONGO_TARGET_PATH = "target" + File.separatorChar + "mongo-temp";
    protected static final String DEFAULT_MONGO_REPLICA_SET_NAME = "";
    protected static final boolean DEFAULT_MONGO_SHARD_SERVER = false;
    protected static final boolean DEFAULT_MONGO_CONFIG_SERVER = false;
    protected static final String MONGODB_BINARY_DIRECTORY = "bin";
    protected static final String MONGODB_EXECUTABLE_X = "mongod";
    protected static final String MONGODB_EXECUTABLE_W = "mongod.exe";
    private String mongodPath = SystemEnvironmentVariables.getEnvironmentOrPropertyVariable((String)"MONGO_HOME");
    private int port = 27017;
    private String targetPath = DEFAULT_MONGO_TARGET_PATH;
    private String dbRelativePath = "mongo-dbpath";
    private String logRelativePath = "logpath";
    private String replicaSetName = "";
    private boolean shardServer = false;
    private boolean configServer = false;
    private boolean journaling = false;
    private Map<String, String> extraCommandArguments = new HashMap<String, String>();
    private List<String> singleCommandArguments = new ArrayList<String>();
    private CommandLineExecutor commandLineExecutor = new CommandLineExecutor();
    private OperatingSystemResolver operatingSystemResolver = new OsNameSystemPropertyOperatingSystemResolver();
    private MongoDbLowLevelOps mongoDbLowLevelOps = MongoDbLowLevelOpsFactory.getSingletonInstance();
    private ProcessRunnable processRunnable;

    public String getHost() {
        return LOCALHOST;
    }

    public int getPort() {
        return this.port;
    }

    public void doStart() throws Throwable {
        LOGGER.info("Starting {} MongoDb instance.", (Object)this.mongodPath);
        File dbPath = this.ensureDbPathDoesNotExitsAndReturnCompositePath();
        if (dbPath.mkdirs()) {
            this.startMongoDBAsADaemon();
            boolean isServerUp = this.assertThatConnectionToMongoDbIsPossible();
            if (!isServerUp) {
                throw new IllegalStateException("Couldn't establish a connection with " + this.mongodPath + " server at /127.0.0.1:" + this.port);
            }
        } else {
            throw new IllegalStateException("Db Path " + dbPath + " could not be created.");
        }
        LOGGER.info("Started {} MongoDb instance.", (Object)this.mongodPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() {
        LOGGER.info("Stopping {} MongoDb instance.", (Object)this.mongodPath);
        try {
            if (this.processRunnable != null) {
                this.processRunnable.destroyProcess();
            }
        }
        finally {
            this.ensureDbPathDoesNotExitsAndReturnCompositePath();
        }
        LOGGER.info("Stopped {} MongoDb instance.", (Object)this.mongodPath);
    }

    private List<String> startMongoDBAsADaemon() throws InterruptedException {
        CountDownLatch processIsReady = new CountDownLatch(1);
        this.processRunnable = new ProcessRunnable(processIsReady);
        Thread thread = new Thread(this.processRunnable);
        thread.start();
        processIsReady.await();
        return this.processRunnable.consoleOutput;
    }

    private List<String> buildOperationSystemProgramAndArguments() {
        ArrayList<String> programAndArguments = new ArrayList<String>();
        programAndArguments.add(this.getExecutablePath());
        if (this.isReplicaSetNameSet()) {
            programAndArguments.add(REPLICA_SET_ARGUMENT_NAME);
            programAndArguments.add(this.replicaSetName);
        }
        programAndArguments.add(DBPATH_ARGUMENT_NAME);
        programAndArguments.add(this.dbRelativePath);
        programAndArguments.add(PORT_ARGUMENT_NAME);
        programAndArguments.add(Integer.toString(this.port));
        programAndArguments.add(LOGPATH_ARGUMENT_NAME);
        programAndArguments.add(this.logRelativePath);
        programAndArguments.add(this.journalingArgument());
        if (this.isShardServerConfigured()) {
            programAndArguments.add(SHARD_SERVER_ENABLED);
        }
        if (this.isConfigServerConfigured()) {
            programAndArguments.add(CONFIG_SERVER_ENABLED);
        }
        for (String argument : this.singleCommandArguments) {
            programAndArguments.add(argument);
        }
        for (String argumentName : this.extraCommandArguments.keySet()) {
            programAndArguments.add(argumentName);
            programAndArguments.add(this.extraCommandArguments.get(argumentName));
        }
        return programAndArguments;
    }

    private boolean isConfigServerConfigured() {
        return this.configServer;
    }

    private boolean isShardServerConfigured() {
        return this.shardServer;
    }

    public boolean isReplicaSetNameSet() {
        return this.replicaSetName != DEFAULT_MONGO_REPLICA_SET_NAME;
    }

    private String getExecutablePath() {
        return this.mongodPath + File.separatorChar + MONGODB_BINARY_DIRECTORY + File.separatorChar + this.mongoExecutable();
    }

    private String mongoExecutable() {
        OperatingSystem operatingSystem = this.operatingSystemResolver.currentOperatingSystem();
        switch (operatingSystem.getFamily()) {
            case WINDOWS: {
                return MONGODB_EXECUTABLE_W;
            }
        }
        return MONGODB_EXECUTABLE_X;
    }

    private boolean assertThatConnectionToMongoDbIsPossible() throws InterruptedException, UnknownHostException {
        return this.mongoDbLowLevelOps.assertThatConnectionIsPossible(LOCALHOST, this.port);
    }

    private File ensureDbPathDoesNotExitsAndReturnCompositePath() {
        File dbPath = new File(this.targetPath + File.separatorChar + this.dbRelativePath);
        if (dbPath.exists()) {
            IOUtils.deleteDir((File)dbPath);
        }
        return dbPath;
    }

    public void setDbRelativePath(String dbRelativePath) {
        this.dbRelativePath = dbRelativePath;
    }

    public void setLogRelativePath(String logRelativePath) {
        this.logRelativePath = logRelativePath;
    }

    public void setMongodPath(String mongodPath) {
        this.mongodPath = mongodPath;
    }

    public void setReplicaSetName(String replicaSetName) {
        this.replicaSetName = replicaSetName;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public void addExtraCommandLineArgument(String argumentName, String argumentValue) {
        this.extraCommandArguments.put(argumentName, argumentValue);
    }

    public void addSingleCommandLineArgument(String argument) {
        this.singleCommandArguments.add(argument);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setJournaling(boolean journaling) {
        this.journaling = journaling;
    }

    public void setShardServer(boolean shardServer) {
        this.shardServer = shardServer;
    }

    public void setConfigServer(boolean configServer) {
        this.configServer = configServer;
    }

    protected String getMongodPath() {
        return this.mongodPath;
    }

    protected void setCommandLineExecutor(CommandLineExecutor commandLineExecutor) {
        this.commandLineExecutor = commandLineExecutor;
    }

    protected void setOperatingSystemResolver(OperatingSystemResolver operatingSystemResolver) {
        this.operatingSystemResolver = operatingSystemResolver;
    }

    protected void setMongoDbLowLevelOps(MongoDbLowLevelOps mongoDbLowLevelOps) {
        this.mongoDbLowLevelOps = mongoDbLowLevelOps;
    }

    protected String journalingArgument() {
        return this.journaling ? JOURNALING_ENABLED : NONE_JOURNALING_ENABLED;
    }

    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    public class ProcessRunnable
    implements Runnable {
        private CountDownLatch processIsReady;
        private List<String> consoleOutput;
        private Process process;

        public ProcessRunnable(CountDownLatch processIsReady) {
            this.processIsReady = processIsReady;
        }

        @Override
        public void run() {
            try {
                this.process = this.startProcess();
                this.consoleOutput = this.getConsoleOutput(this.process);
            }
            catch (IOException e) {
                throw this.prepareException(e);
            }
            finally {
                this.processIsReady.countDown();
            }
            try {
                this.process.waitFor();
                if (this.process.exitValue() != 0) {
                    LOGGER.info("Mongodb [" + ManagedMongoDbLifecycleManager.this.mongodPath + ManagedMongoDbLifecycleManager.DBPATH_ARGUMENT_NAME + ManagedMongoDbLifecycleManager.this.dbRelativePath + ManagedMongoDbLifecycleManager.PORT_ARGUMENT_NAME + ManagedMongoDbLifecycleManager.this.port + ManagedMongoDbLifecycleManager.LOGPATH_ARGUMENT_NAME + ManagedMongoDbLifecycleManager.this.logRelativePath + "] console output is: " + this.consoleOutput);
                }
            }
            catch (InterruptedException ie) {
                throw this.prepareException(ie);
            }
        }

        public void destroyProcess() {
            if (this.process != null) {
                this.process.destroy();
            }
        }

        private IllegalStateException prepareException(Exception e) {
            return new IllegalStateException("Mongodb [" + ManagedMongoDbLifecycleManager.this.mongodPath + ManagedMongoDbLifecycleManager.DBPATH_ARGUMENT_NAME + ManagedMongoDbLifecycleManager.this.dbRelativePath + ManagedMongoDbLifecycleManager.PORT_ARGUMENT_NAME + ManagedMongoDbLifecycleManager.this.port + ManagedMongoDbLifecycleManager.LOGPATH_ARGUMENT_NAME + ManagedMongoDbLifecycleManager.this.logRelativePath + "] could not be started. Next console message was thrown: " + e.getMessage());
        }

        private Process startProcess() throws IOException {
            return ManagedMongoDbLifecycleManager.this.commandLineExecutor.startProcessInDirectoryAndArguments(ManagedMongoDbLifecycleManager.this.targetPath, ManagedMongoDbLifecycleManager.this.buildOperationSystemProgramAndArguments());
        }

        private List<String> getConsoleOutput(Process pwd) throws IOException {
            return ManagedMongoDbLifecycleManager.this.commandLineExecutor.getConsoleOutput(pwd);
        }
    }
}

