/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb;

import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.mongodb.MongoComparisonStrategy;
import com.lordofthejars.nosqlunit.mongodb.MongoDbAssertion;
import com.lordofthejars.nosqlunit.mongodb.MongoDbConnectionCallback;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.io.IOException;
import java.io.InputStream;

public class DefaultComparisonStrategy
implements MongoComparisonStrategy {
    public boolean compare(MongoDbConnectionCallback connection, InputStream dataset) throws IOException {
        String expectedJsonData = this.loadContentFromInputStream(dataset);
        DBObject parsedData = this.parseData(expectedJsonData);
        MongoDbAssertion.strictAssertEquals(parsedData, connection.db());
        return true;
    }

    private String loadContentFromInputStream(InputStream inputStreamContent) throws IOException {
        return IOUtils.readFullStream((InputStream)inputStreamContent);
    }

    private DBObject parseData(String jsonData) throws IOException {
        DBObject parsedData = (DBObject)JSON.parse((String)jsonData);
        return parsedData;
    }
}

