/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.CommandList;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterIndexRename;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.AlterTableAlterColumn;
import org.h2.command.ddl.AlterTableDropConstraint;
import org.h2.command.ddl.AlterTableRename;
import org.h2.command.ddl.AlterTableRenameColumn;
import org.h2.command.ddl.AlterUser;
import org.h2.command.ddl.AlterView;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CreateAggregate;
import org.h2.command.ddl.CreateConstant;
import org.h2.command.ddl.CreateFunctionAlias;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateLinkedTable;
import org.h2.command.ddl.CreateRole;
import org.h2.command.ddl.CreateSchema;
import org.h2.command.ddl.CreateSequence;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.ddl.CreateTrigger;
import org.h2.command.ddl.CreateUser;
import org.h2.command.ddl.CreateUserDataType;
import org.h2.command.ddl.CreateView;
import org.h2.command.ddl.DeallocateProcedure;
import org.h2.command.ddl.DropAggregate;
import org.h2.command.ddl.DropConstant;
import org.h2.command.ddl.DropDatabase;
import org.h2.command.ddl.DropFunctionAlias;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropRole;
import org.h2.command.ddl.DropSchema;
import org.h2.command.ddl.DropSequence;
import org.h2.command.ddl.DropTable;
import org.h2.command.ddl.DropTrigger;
import org.h2.command.ddl.DropUser;
import org.h2.command.ddl.DropUserDataType;
import org.h2.command.ddl.DropView;
import org.h2.command.ddl.GrantRevoke;
import org.h2.command.ddl.PrepareProcedure;
import org.h2.command.ddl.SetComment;
import org.h2.command.ddl.TruncateTable;
import org.h2.command.dml.AlterSequence;
import org.h2.command.dml.AlterTableSet;
import org.h2.command.dml.BackupCommand;
import org.h2.command.dml.Call;
import org.h2.command.dml.Delete;
import org.h2.command.dml.ExecuteProcedure;
import org.h2.command.dml.ExplainPlan;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.NoOperation;
import org.h2.command.dml.Query;
import org.h2.command.dml.RunScriptCommand;
import org.h2.command.dml.ScriptCommand;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectOrderBy;
import org.h2.command.dml.SelectUnion;
import org.h2.command.dml.Set;
import org.h2.command.dml.SetTypes;
import org.h2.command.dml.TransactionCommand;
import org.h2.command.dml.Update;
import org.h2.constant.SysProperties;
import org.h2.engine.Database;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Procedure;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.Aggregate;
import org.h2.expression.Alias;
import org.h2.expression.CompareLike;
import org.h2.expression.Comparison;
import org.h2.expression.Condition;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.ConditionExists;
import org.h2.expression.ConditionIn;
import org.h2.expression.ConditionInSelect;
import org.h2.expression.ConditionNot;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.Function;
import org.h2.expression.FunctionCall;
import org.h2.expression.JavaAggregate;
import org.h2.expression.JavaFunction;
import org.h2.expression.Operation;
import org.h2.expression.Parameter;
import org.h2.expression.Rownum;
import org.h2.expression.SequenceValue;
import org.h2.expression.Subquery;
import org.h2.expression.TableFunction;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.expression.Wildcard;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.FunctionTable;
import org.h2.table.IndexColumn;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final int CHAR_END = 1;
    private static final int CHAR_VALUE = 2;
    private static final int CHAR_QUOTED = 3;
    private static final int CHAR_NAME = 4;
    private static final int CHAR_SPECIAL_1 = 5;
    private static final int CHAR_SPECIAL_2 = 6;
    private static final int CHAR_STRING = 7;
    private static final int CHAR_DOT = 8;
    private static final int CHAR_DOLLAR_QUOTED_STRING = 9;
    private static final int KEYWORD = 1;
    private static final int IDENTIFIER = 2;
    private static final int PARAMETER = 3;
    private static final int END = 4;
    private static final int VALUE = 5;
    private static final int EQUAL = 6;
    private static final int BIGGER_EQUAL = 7;
    private static final int BIGGER = 8;
    private static final int SMALLER = 9;
    private static final int SMALLER_EQUAL = 10;
    private static final int NOT_EQUAL = 11;
    private static final int AT = 12;
    private static final int MINUS = 13;
    private static final int PLUS = 14;
    private static final int STRING_CONCAT = 15;
    private static final int OPEN = 16;
    private static final int CLOSE = 17;
    private static final int NULL = 18;
    private static final int TRUE = 19;
    private static final int FALSE = 20;
    private static final int CURRENT_TIMESTAMP = 21;
    private static final int CURRENT_DATE = 22;
    private static final int CURRENT_TIME = 23;
    private static final int ROWNUM = 24;
    private final Database database;
    private final Session session;
    private int[] characterTypes;
    private int currentTokenType;
    private String currentToken;
    private boolean currentTokenQuoted;
    private Value currentValue;
    private String sqlCommand;
    private String originalSQL;
    private char[] sqlCommandChars;
    private int lastParseIndex;
    private int parseIndex;
    private CreateView createView;
    private Prepared currentPrepared;
    private Select currentSelect;
    private ArrayList<Parameter> parameters;
    private String schemaName;
    private ArrayList<String> expectedList;
    private boolean rightsChecked;
    private boolean recompileAlways;
    private ArrayList<Parameter> indexedParameterList;
    private boolean identifiersToUpper = SysProperties.IDENTIFIERS_TO_UPPER;

    public Parser(Session session) {
        this.database = session.getDatabase();
        this.session = session;
    }

    public Prepared prepare(String string) {
        Prepared prepared = this.parse(string);
        prepared.prepare();
        return prepared;
    }

    public Prepared parseOnly(String string) {
        return this.parse(string);
    }

    public Command prepareCommand(String string) {
        try {
            Prepared prepared = this.parse(string);
            prepared.prepare();
            Command command = new CommandContainer(this, string, prepared);
            prepared.setCommand(command);
            if (this.isToken(";")) {
                String string2 = this.originalSQL.substring(this.parseIndex);
                if (string2.trim().length() != 0) {
                    CommandList commandList = new CommandList(this, string, command, string2);
                    command = commandList;
                }
            } else if (this.currentTokenType != 4) {
                throw this.getSyntaxError();
            }
            return command;
        }
        catch (DbException dbException) {
            throw dbException.addSQL(this.originalSQL);
        }
    }

    private Prepared parse(String string) {
        Prepared prepared;
        try {
            prepared = this.parse(string, false);
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 42000) {
                prepared = this.parse(string, true);
            }
            throw dbException.addSQL(string);
        }
        prepared.setPrepareAlways(this.recompileAlways);
        prepared.setParameterList(this.parameters);
        return prepared;
    }

    private Prepared parse(String string, boolean bl) {
        this.initialize(string);
        this.expectedList = bl ? New.arrayList() : null;
        this.parameters = New.arrayList();
        this.currentSelect = null;
        this.currentPrepared = null;
        this.createView = null;
        this.recompileAlways = false;
        this.indexedParameterList = null;
        this.read();
        return this.parsePrepared();
    }

    private Prepared parsePrepared() {
        int n = this.lastParseIndex;
        Prepared prepared = null;
        String string = this.currentToken;
        if (string.length() == 0) {
            prepared = new NoOperation(this.session);
        } else {
            int n2;
            char c = string.charAt(0);
            switch (c) {
                case '(': {
                    prepared = this.parseSelect();
                    break;
                }
                case 'A': 
                case 'a': {
                    if (this.readIf("ALTER")) {
                        prepared = this.parseAlter();
                        break;
                    }
                    if (!this.readIf("ANALYZE")) break;
                    prepared = this.parseAnalyze();
                    break;
                }
                case 'B': 
                case 'b': {
                    if (this.readIf("BACKUP")) {
                        prepared = this.parseBackup();
                        break;
                    }
                    if (!this.readIf("BEGIN")) break;
                    prepared = this.parseBegin();
                    break;
                }
                case 'C': 
                case 'c': {
                    if (this.readIf("COMMIT")) {
                        prepared = this.parseCommit();
                        break;
                    }
                    if (this.readIf("CREATE")) {
                        prepared = this.parseCreate();
                        break;
                    }
                    if (this.readIf("CALL")) {
                        prepared = this.parserCall();
                        break;
                    }
                    if (this.readIf("CHECKPOINT")) {
                        prepared = this.parseCheckpoint();
                        break;
                    }
                    if (!this.readIf("COMMENT")) break;
                    prepared = this.parseComment();
                    break;
                }
                case 'D': 
                case 'd': {
                    if (this.readIf("DELETE")) {
                        prepared = this.parseDelete();
                        break;
                    }
                    if (this.readIf("DROP")) {
                        prepared = this.parseDrop();
                        break;
                    }
                    if (this.readIf("DECLARE")) {
                        prepared = this.parseCreate();
                        break;
                    }
                    if (!this.readIf("DEALLOCATE")) break;
                    prepared = this.parseDeallocate();
                    break;
                }
                case 'E': 
                case 'e': {
                    if (this.readIf("EXPLAIN")) {
                        prepared = this.parseExplain();
                        break;
                    }
                    if (!this.readIf("EXECUTE")) break;
                    prepared = this.parseExecute();
                    break;
                }
                case 'F': 
                case 'f': {
                    if (!this.isToken("FROM")) break;
                    prepared = this.parseSelect();
                    break;
                }
                case 'G': 
                case 'g': {
                    if (!this.readIf("GRANT")) break;
                    prepared = this.parseGrantRevoke(0);
                    break;
                }
                case 'H': 
                case 'h': {
                    if (!this.readIf("HELP")) break;
                    prepared = this.parseHelp();
                    break;
                }
                case 'I': 
                case 'i': {
                    if (!this.readIf("INSERT")) break;
                    prepared = this.parseInsert();
                    break;
                }
                case 'M': 
                case 'm': {
                    if (!this.readIf("MERGE")) break;
                    prepared = this.parseMerge();
                    break;
                }
                case 'P': 
                case 'p': {
                    if (!this.readIf("PREPARE")) break;
                    prepared = this.parsePrepare();
                    break;
                }
                case 'R': 
                case 'r': {
                    if (this.readIf("ROLLBACK")) {
                        prepared = this.parseRollback();
                        break;
                    }
                    if (this.readIf("REVOKE")) {
                        prepared = this.parseGrantRevoke(1);
                        break;
                    }
                    if (this.readIf("RUNSCRIPT")) {
                        prepared = this.parseRunScript();
                        break;
                    }
                    if (!this.readIf("RELEASE")) break;
                    prepared = this.parseReleaseSavepoint();
                    break;
                }
                case 'S': 
                case 's': {
                    if (this.isToken("SELECT")) {
                        prepared = this.parseSelect();
                        break;
                    }
                    if (this.readIf("SET")) {
                        prepared = this.parseSet();
                        break;
                    }
                    if (this.readIf("SAVEPOINT")) {
                        prepared = this.parseSavepoint();
                        break;
                    }
                    if (this.readIf("SCRIPT")) {
                        prepared = this.parseScript();
                        break;
                    }
                    if (this.readIf("SHUTDOWN")) {
                        prepared = this.parseShutdown();
                        break;
                    }
                    if (!this.readIf("SHOW")) break;
                    prepared = this.parseShow();
                    break;
                }
                case 'T': 
                case 't': {
                    if (!this.readIf("TRUNCATE")) break;
                    prepared = this.parseTruncate();
                    break;
                }
                case 'U': 
                case 'u': {
                    if (!this.readIf("UPDATE")) break;
                    prepared = this.parseUpdate();
                    break;
                }
                case 'V': 
                case 'v': {
                    if (!this.readIf("VALUES")) break;
                    prepared = this.parserCall();
                    break;
                }
                case 'W': 
                case 'w': {
                    if (!this.readIf("WITH")) break;
                    prepared = this.parserWith();
                    break;
                }
                default: {
                    throw this.getSyntaxError();
                }
            }
            if (this.indexedParameterList != null) {
                for (n2 = 0; n2 < this.indexedParameterList.size(); ++n2) {
                    if (this.indexedParameterList.get(n2) != null) continue;
                    this.indexedParameterList.set(n2, new Parameter(n2));
                }
                this.parameters = this.indexedParameterList;
            }
            if (this.readIf("{")) {
                do {
                    if ((n2 = (int)this.readLong() - 1) < 0 || n2 >= this.parameters.size()) {
                        throw this.getSyntaxError();
                    }
                    Parameter parameter = this.parameters.get(n2);
                    if (parameter == null) {
                        throw this.getSyntaxError();
                    }
                    this.read(":");
                    Expression expression = this.readExpression();
                    expression = expression.optimize(this.session);
                    parameter.setValue(expression.getValue(this.session));
                } while (this.readIf(","));
                this.read("}");
                for (Parameter parameter : this.parameters) {
                    parameter.checkSet();
                }
                this.parameters.clear();
            }
        }
        if (prepared == null) {
            throw this.getSyntaxError();
        }
        this.setSQL(prepared, null, n);
        return prepared;
    }

    private DbException getSyntaxError() {
        if (this.expectedList == null || this.expectedList.size() == 0) {
            return DbException.getSyntaxError(this.sqlCommand, this.parseIndex);
        }
        StatementBuilder statementBuilder = new StatementBuilder();
        for (String string : this.expectedList) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(string);
        }
        return DbException.getSyntaxError(this.sqlCommand, this.parseIndex, statementBuilder.toString());
    }

    private Prepared parseBackup() {
        BackupCommand backupCommand = new BackupCommand(this.session);
        this.read("TO");
        backupCommand.setFileName(this.readExpression());
        return backupCommand;
    }

    private Prepared parseAnalyze() {
        Analyze analyze = new Analyze(this.session);
        if (this.readIf("SAMPLE_SIZE")) {
            analyze.setTop(this.getPositiveInt());
        }
        return analyze;
    }

    private TransactionCommand parseBegin() {
        if (!this.readIf("WORK")) {
            this.readIf("TRANSACTION");
        }
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 15);
        return transactionCommand;
    }

    private TransactionCommand parseCommit() {
        if (this.readIf("TRANSACTION")) {
            TransactionCommand transactionCommand = new TransactionCommand(this.session, 10);
            transactionCommand.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand;
        }
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 3);
        this.readIf("WORK");
        return transactionCommand;
    }

    private TransactionCommand parseShutdown() {
        int n = 12;
        if (this.readIf("IMMEDIATELY")) {
            n = 13;
        } else if (this.readIf("COMPACT")) {
            n = 14;
        } else {
            this.readIf("SCRIPT");
        }
        return new TransactionCommand(this.session, n);
    }

    private TransactionCommand parseRollback() {
        TransactionCommand transactionCommand;
        if (this.readIf("TRANSACTION")) {
            TransactionCommand transactionCommand2 = new TransactionCommand(this.session, 11);
            transactionCommand2.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand2;
        }
        if (this.readIf("TO")) {
            this.read("SAVEPOINT");
            transactionCommand = new TransactionCommand(this.session, 7);
            transactionCommand.setSavepointName(this.readUniqueIdentifier());
        } else {
            this.readIf("WORK");
            transactionCommand = new TransactionCommand(this.session, 4);
        }
        return transactionCommand;
    }

    private Prepared parsePrepare() {
        Object object;
        if (this.readIf("COMMIT")) {
            TransactionCommand transactionCommand = new TransactionCommand(this.session, 9);
            transactionCommand.setTransactionName(this.readUniqueIdentifier());
            return transactionCommand;
        }
        String string = this.readAliasIdentifier();
        if (this.readIf("(")) {
            object = New.arrayList();
            int n = 0;
            while (true) {
                Column column = this.parseColumnForTable("C" + n);
                ((ArrayList)object).add(column);
                if (this.readIf(")")) break;
                this.read(",");
                ++n;
            }
        }
        this.read("AS");
        object = this.parsePrepared();
        PrepareProcedure prepareProcedure = new PrepareProcedure(this.session);
        prepareProcedure.setProcedureName(string);
        prepareProcedure.setPrepared((Prepared)object);
        return prepareProcedure;
    }

    private TransactionCommand parseSavepoint() {
        TransactionCommand transactionCommand = new TransactionCommand(this.session, 6);
        transactionCommand.setSavepointName(this.readUniqueIdentifier());
        return transactionCommand;
    }

    private Prepared parseReleaseSavepoint() {
        NoOperation noOperation = new NoOperation(this.session);
        this.readIf("SAVEPOINT");
        this.readUniqueIdentifier();
        return noOperation;
    }

    private Schema getSchema() {
        if (this.schemaName == null) {
            return null;
        }
        Schema schema = this.database.findSchema(this.schemaName);
        if (schema == null) {
            if (this.equalsToken("SESSION", this.schemaName)) {
                schema = this.database.getSchema(this.session.getCurrentSchemaName());
            } else {
                throw DbException.get(90079, this.schemaName);
            }
        }
        return schema;
    }

    private Column readTableColumn(TableFilter tableFilter) {
        String string = null;
        String string2 = this.readColumnIdentifier();
        if (this.readIf(".")) {
            string = string2;
            string2 = this.readColumnIdentifier();
            if (this.readIf(".")) {
                String string3 = string;
                string = string2;
                string2 = this.readColumnIdentifier();
                if (this.readIf(".")) {
                    String string4 = string3;
                    string3 = string;
                    string = string2;
                    string2 = this.readColumnIdentifier();
                    if (!this.equalsToken(string4, this.database.getShortName())) {
                        throw DbException.get(90013, string4);
                    }
                }
                if (!this.equalsToken(string3, tableFilter.getTable().getSchema().getName())) {
                    throw DbException.get(90079, string3);
                }
            }
            if (!this.equalsToken(string, tableFilter.getTableAlias())) {
                throw DbException.get(42102, string);
            }
        }
        return tableFilter.getTable().getColumn(string2);
    }

    private Update parseUpdate() {
        Object object;
        Update update = new Update(this.session);
        this.currentPrepared = update;
        int n = this.lastParseIndex;
        TableFilter tableFilter = this.readSimpleTableFilter();
        update.setTableFilter(tableFilter);
        this.read("SET");
        if (this.readIf("(")) {
            Object object2;
            object = New.arrayList();
            do {
                object2 = this.readTableColumn(tableFilter);
                ((ArrayList)object).add(object2);
            } while (this.readIf(","));
            this.read(")");
            this.read("=");
            object2 = this.readExpression();
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                Column column = (Column)((ArrayList)object).get(i);
                Function function = Function.getFunction(this.database, "ARRAY_GET");
                function.setParameter(0, (Expression)object2);
                function.setParameter(1, ValueExpression.get(ValueInt.get(i + 1)));
                function.doneWithParameters();
                update.setAssignment(column, function);
            }
        } else {
            do {
                object = this.readTableColumn(tableFilter);
                this.read("=");
                Expression expression = this.readIf("DEFAULT") ? ValueExpression.getDefault() : this.readExpression();
                update.setAssignment((Column)object, expression);
            } while (this.readIf(","));
        }
        if (this.readIf("WHERE")) {
            object = this.readExpression();
            update.setCondition((Expression)object);
        }
        this.setSQL(update, "UPDATE", n);
        return update;
    }

    private TableFilter readSimpleTableFilter() {
        Table table = this.readTableOrView();
        String string = null;
        if (this.readIf("AS")) {
            string = this.readAliasIdentifier();
        } else if (this.currentTokenType == 2 && !this.equalsToken("SET", this.currentToken)) {
            string = this.readAliasIdentifier();
        }
        return new TableFilter(this.session, table, string, this.rightsChecked, this.currentSelect);
    }

    private Delete parseDelete() {
        Delete delete = new Delete(this.session);
        this.currentPrepared = delete;
        int n = this.lastParseIndex;
        this.readIf("FROM");
        TableFilter tableFilter = this.readSimpleTableFilter();
        delete.setTableFilter(tableFilter);
        if (this.readIf("WHERE")) {
            Expression expression = this.readExpression();
            delete.setCondition(expression);
        }
        this.setSQL(delete, "DELETE", n);
        return delete;
    }

    private IndexColumn[] parseIndexColumnList() {
        ArrayList<IndexColumn> arrayList = New.arrayList();
        do {
            IndexColumn indexColumn = new IndexColumn();
            indexColumn.columnName = this.readColumnIdentifier();
            arrayList.add(indexColumn);
            if (!this.readIf("ASC") && this.readIf("DESC")) {
                indexColumn.sortType = 1;
            }
            if (!this.readIf("NULLS")) continue;
            if (this.readIf("FIRST")) {
                indexColumn.sortType |= 2;
                continue;
            }
            this.read("LAST");
            indexColumn.sortType |= 4;
        } while (this.readIf(","));
        this.read(")");
        return arrayList.toArray(new IndexColumn[arrayList.size()]);
    }

    private String[] parseColumnList() {
        ArrayList<String> arrayList = New.arrayList();
        do {
            String string = this.readColumnIdentifier();
            arrayList.add(string);
        } while (this.readIfMore());
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Column[] parseColumnList(Table table) {
        ArrayList<Column> arrayList = New.arrayList();
        HashSet hashSet = New.hashSet();
        if (!this.readIf(")")) {
            do {
                Column column;
                if (!hashSet.add(column = table.getColumn(this.readColumnIdentifier()))) {
                    throw DbException.get(42121, column.getSQL());
                }
                arrayList.add(column);
            } while (this.readIfMore());
        }
        return arrayList.toArray(new Column[arrayList.size()]);
    }

    private boolean readIfMore() {
        if (this.readIf(",")) {
            return !this.readIf(")");
        }
        this.read(")");
        return false;
    }

    private Prepared parseHelp() {
        StringBuilder stringBuilder = new StringBuilder("SELECT * FROM INFORMATION_SCHEMA.HELP");
        int n = 0;
        ArrayList<Value> arrayList = New.arrayList();
        while (this.currentTokenType != 4) {
            String string = this.currentToken;
            this.read();
            if (n == 0) {
                stringBuilder.append(" WHERE ");
            } else {
                stringBuilder.append(" AND ");
            }
            ++n;
            stringBuilder.append("UPPER(TOPIC) LIKE ?");
            arrayList.add(ValueString.get("%" + string + "%"));
        }
        return this.prepare(this.session, stringBuilder.toString(), arrayList);
    }

    private Prepared parseShow() {
        ArrayList<Value> arrayList = New.arrayList();
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        if (this.readIf("CLIENT_ENCODING")) {
            stringBuilder.append("'UNICODE' AS CLIENT_ENCODING FROM DUAL");
        } else if (this.readIf("DEFAULT_TRANSACTION_ISOLATION")) {
            stringBuilder.append("'read committed' AS DEFAULT_TRANSACTION_ISOLATION FROM DUAL");
        } else if (this.readIf("DATESTYLE")) {
            stringBuilder.append("'ISO' AS DATESTYLE FROM DUAL");
        } else if (this.readIf("SERVER_VERSION")) {
            stringBuilder.append("'8.1.4' AS SERVER_VERSION FROM DUAL");
        } else if (this.readIf("SERVER_ENCODING")) {
            stringBuilder.append("'UTF8' AS SERVER_ENCODING FROM DUAL");
        } else if (this.readIf("TABLES")) {
            String string = "PUBLIC";
            if (this.readIf("FROM")) {
                string = this.readUniqueIdentifier();
            }
            stringBuilder.append("TABLE_NAME, TABLE_SCHEMA FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=? ORDER BY TABLE_NAME");
            arrayList.add(ValueString.get(string));
        } else if (this.readIf("COLUMNS")) {
            this.read("FROM");
            String string = this.readUniqueIdentifier();
            arrayList.add(ValueString.get(string));
            String string2 = "PUBLIC";
            if (this.readIf("FROM")) {
                string2 = this.readUniqueIdentifier();
            }
            stringBuilder.append("C.COLUMN_NAME FIELD, C.TYPE_NAME || '(' || C.NUMERIC_PRECISION || ')' TYPE, C.IS_NULLABLE \"NULL\", CASE (SELECT MAX(I.INDEX_TYPE_NAME) FROM INFORMATION_SCHEMA.INDEXES I WHERE I.TABLE_SCHEMA=C.TABLE_SCHEMA AND I.TABLE_NAME=C.TABLE_NAME AND I.COLUMN_NAME=C.COLUMN_NAME)WHEN 'PRIMARY KEY' THEN 'PRI' WHEN 'UNIQUE INDEX' THEN 'UNI' ELSE '' END KEY, IFNULL(COLUMN_DEFAULT, 'NULL') DEFAULT FROM INFORMATION_SCHEMA.COLUMNS C WHERE C.TABLE_NAME=? AND C.TABLE_SCHEMA=? ORDER BY C.ORDINAL_POSITION");
            arrayList.add(ValueString.get(string2));
        } else if (this.readIf("DATABASES") || this.readIf("SCHEMAS")) {
            stringBuilder.append("SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA");
        }
        return this.prepare(this.session, stringBuilder.toString(), arrayList);
    }

    private Prepared prepare(Session session, String string, ArrayList<Value> arrayList) {
        Prepared prepared = session.prepare(string);
        ArrayList<Parameter> arrayList2 = prepared.getParameters();
        for (int i = 0; arrayList2 != null && i < arrayList2.size(); ++i) {
            Parameter parameter = arrayList2.get(i);
            parameter.setValue(arrayList.get(i));
        }
        return prepared;
    }

    private boolean isSelect() {
        int n = this.lastParseIndex;
        while (this.readIf("(")) {
        }
        boolean bl = this.isToken("SELECT") || this.isToken("FROM");
        this.parseIndex = n;
        this.read();
        return bl;
    }

    private Merge parseMerge() {
        Column[] columnArray;
        Merge merge = new Merge(this.session);
        this.currentPrepared = merge;
        this.read("INTO");
        Table table = this.readTableOrView();
        merge.setTable(table);
        if (this.readIf("(")) {
            if (this.isSelect()) {
                merge.setQuery(this.parseSelect());
                this.read(")");
                return merge;
            }
            columnArray = this.parseColumnList(table);
            merge.setColumns(columnArray);
        }
        if (this.readIf("KEY")) {
            this.read("(");
            columnArray = this.parseColumnList(table);
            merge.setKeys(columnArray);
        }
        if (this.readIf("VALUES")) {
            do {
                columnArray = New.arrayList();
                this.read("(");
                if (!this.readIf(")")) {
                    do {
                        if (this.readIf("DEFAULT")) {
                            columnArray.add(null);
                            continue;
                        }
                        columnArray.add(this.readExpression());
                    } while (this.readIfMore());
                }
                merge.addRow(columnArray.toArray(new Expression[columnArray.size()]));
            } while (this.readIf(","));
        } else {
            merge.setQuery(this.parseSelect());
        }
        return merge;
    }

    private Insert parseInsert() {
        Object object;
        Insert insert = new Insert(this.session);
        this.currentPrepared = insert;
        this.read("INTO");
        Table table = this.readTableOrView();
        insert.setTable(table);
        if (this.readIf("SORTED")) {
            insert.setSortedInsertMode(true);
        }
        if (this.readIf("(")) {
            if (this.isSelect()) {
                insert.setQuery(this.parseSelect());
                this.read(")");
                return insert;
            }
            object = this.parseColumnList(table);
            insert.setColumns((Column[])object);
        }
        if (this.readIf("DEFAULT")) {
            this.read("VALUES");
            object = new Expression[]{};
            insert.addRow((Expression[])object);
        } else if (this.readIf("VALUES")) {
            do {
                object = New.arrayList();
                this.read("(");
                if (!this.readIf(")")) {
                    do {
                        if (this.readIf("DEFAULT")) {
                            ((ArrayList)object).add(null);
                            continue;
                        }
                        ((ArrayList)object).add(this.readExpression());
                    } while (this.readIfMore());
                }
                insert.addRow(((ArrayList)object).toArray(new Expression[((ArrayList)object).size()]));
            } while (this.readIf(","));
        } else {
            insert.setQuery(this.parseSelect());
        }
        return insert;
    }

    /*
     * Enabled aggressive block sorting
     */
    private TableFilter readTableFilter(boolean bl) {
        Table table;
        String string;
        block10: {
            string = null;
            if (this.readIf("(")) {
                if (this.isSelect()) {
                    int n = this.lastParseIndex;
                    Query query = this.parseSelectUnion();
                    this.read(")");
                    query = this.parseSelectUnionExtension(query, n, true);
                    ArrayList<Parameter> arrayList = New.arrayList();
                    for (int i = 0; i < this.parameters.size(); ++i) {
                        arrayList.add(this.parameters.get(i));
                    }
                    query.setParameterList(arrayList);
                    query.init();
                    Session session = this.createView != null ? this.database.getSystemSession() : this.session;
                    string = this.session.getNextSystemIdentifier(this.sqlCommand);
                    table = TableView.createTempView(session, this.session.getUser(), string, query, this.currentSelect);
                    break block10;
                } else {
                    TableFilter tableFilter = this.readTableFilter(bl);
                    tableFilter = this.readJoin(tableFilter, this.currentSelect, bl);
                    this.read(")");
                    string = this.readFromAlias(null);
                    if (string != null) {
                        tableFilter.setAlias(string);
                    }
                    return tableFilter;
                }
            }
            String string2 = this.readIdentifierWithSchema(null);
            if (this.readIf("(")) {
                Schema schema = this.database.getSchema("PUBLIC");
                if (this.equalsToken(string2, "SYSTEM_RANGE")) {
                    Expression expression = this.readExpression();
                    this.read(",");
                    Expression expression2 = this.readExpression();
                    this.read(")");
                    table = new RangeTable(schema, expression, expression2);
                } else {
                    Expression expression = this.readFunction(string2);
                    if (!(expression instanceof FunctionCall)) {
                        throw this.getSyntaxError();
                    }
                    table = new FunctionTable(schema, this.session, expression, (FunctionCall)((Object)expression));
                }
            } else {
                table = this.equalsToken("DUAL", string2) ? this.getDualTable() : this.readTableOrView(string2);
            }
        }
        string = this.readFromAlias(string);
        return new TableFilter(this.session, table, string, this.rightsChecked, this.currentSelect);
    }

    private String readFromAlias(String string) {
        if (this.readIf("AS")) {
            string = this.readAliasIdentifier();
        } else if (!(this.currentTokenType != 2 || this.isToken("LEFT") || this.isToken("RIGHT") || this.isToken("FULL"))) {
            string = this.readAliasIdentifier();
        }
        return string;
    }

    private Prepared parseTruncate() {
        this.read("TABLE");
        Table table = this.readTableOrView();
        TruncateTable truncateTable = new TruncateTable(this.session);
        truncateTable.setTable(table);
        return truncateTable;
    }

    private boolean readIfExists(boolean bl) {
        if (this.readIf("IF")) {
            this.read("EXISTS");
            bl = true;
        }
        return bl;
    }

    private Prepared parseComment() {
        int n = 0;
        this.read("ON");
        boolean bl = false;
        if (this.readIf("TABLE") || this.readIf("VIEW")) {
            n = 0;
        } else if (this.readIf("COLUMN")) {
            bl = true;
            n = 0;
        } else if (this.readIf("CONSTANT")) {
            n = 11;
        } else if (this.readIf("CONSTRAINT")) {
            n = 5;
        } else if (this.readIf("ALIAS")) {
            n = 9;
        } else if (this.readIf("INDEX")) {
            n = 1;
        } else if (this.readIf("ROLE")) {
            n = 7;
        } else if (this.readIf("SCHEMA")) {
            n = 10;
        } else if (this.readIf("SEQUENCE")) {
            n = 3;
        } else if (this.readIf("TRIGGER")) {
            n = 4;
        } else if (this.readIf("USER")) {
            n = 2;
        } else if (this.readIf("DOMAIN")) {
            n = 12;
        } else {
            throw this.getSyntaxError();
        }
        SetComment setComment = new SetComment(this.session);
        String string = this.readIdentifierWithSchema();
        if (bl) {
            String string2 = string;
            string = this.schemaName;
            this.schemaName = this.session.getCurrentSchemaName();
            if (this.readIf(".")) {
                this.schemaName = string;
                string = string2;
                string2 = this.readUniqueIdentifier();
            }
            setComment.setColumn(true);
            setComment.setColumnName(string2);
        }
        setComment.setSchemaName(this.schemaName);
        setComment.setObjectName(string);
        setComment.setObjectType(n);
        this.read("IS");
        setComment.setCommentExpression(this.readExpression());
        return setComment;
    }

    private Prepared parseDrop() {
        if (this.readIf("TABLE")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropTable dropTable = new DropTable(this.session, this.getSchema());
            dropTable.setTableName(string);
            while (this.readIf(",")) {
                string = this.readIdentifierWithSchema();
                DropTable dropTable2 = new DropTable(this.session, this.getSchema());
                dropTable2.setTableName(string);
                dropTable.addNextDropTable(dropTable2);
            }
            bl = this.readIfExists(bl);
            dropTable.setIfExists(bl);
            if (this.readIf("CASCADE")) {
                this.readIf("CONSTRAINTS");
            }
            return dropTable;
        }
        if (this.readIf("INDEX")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropIndex dropIndex = new DropIndex(this.session, this.getSchema());
            dropIndex.setIndexName(string);
            bl = this.readIfExists(bl);
            dropIndex.setIfExists(bl);
            return dropIndex;
        }
        if (this.readIf("USER")) {
            boolean bl = this.readIfExists(false);
            DropUser dropUser = new DropUser(this.session);
            dropUser.setUserName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            this.readIf("CASCADE");
            dropUser.setIfExists(bl);
            return dropUser;
        }
        if (this.readIf("SEQUENCE")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropSequence dropSequence = new DropSequence(this.session, this.getSchema());
            dropSequence.setSequenceName(string);
            bl = this.readIfExists(bl);
            dropSequence.setIfExists(bl);
            return dropSequence;
        }
        if (this.readIf("CONSTANT")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropConstant dropConstant = new DropConstant(this.session, this.getSchema());
            dropConstant.setConstantName(string);
            bl = this.readIfExists(bl);
            dropConstant.setIfExists(bl);
            return dropConstant;
        }
        if (this.readIf("TRIGGER")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropTrigger dropTrigger = new DropTrigger(this.session, this.getSchema());
            dropTrigger.setTriggerName(string);
            bl = this.readIfExists(bl);
            dropTrigger.setIfExists(bl);
            return dropTrigger;
        }
        if (this.readIf("VIEW")) {
            boolean bl = this.readIfExists(false);
            String string = this.readIdentifierWithSchema();
            DropView dropView = new DropView(this.session, this.getSchema());
            dropView.setViewName(string);
            bl = this.readIfExists(bl);
            dropView.setIfExists(bl);
            return dropView;
        }
        if (this.readIf("ROLE")) {
            boolean bl = this.readIfExists(false);
            DropRole dropRole = new DropRole(this.session);
            dropRole.setRoleName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            dropRole.setIfExists(bl);
            return dropRole;
        }
        if (this.readIf("ALIAS")) {
            boolean bl = this.readIfExists(false);
            DropFunctionAlias dropFunctionAlias = new DropFunctionAlias(this.session);
            dropFunctionAlias.setAliasName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            dropFunctionAlias.setIfExists(bl);
            return dropFunctionAlias;
        }
        if (this.readIf("SCHEMA")) {
            boolean bl = this.readIfExists(false);
            DropSchema dropSchema = new DropSchema(this.session);
            dropSchema.setSchemaName(this.readUniqueIdentifier());
            bl = this.readIfExists(bl);
            dropSchema.setIfExists(bl);
            return dropSchema;
        }
        if (this.readIf("ALL")) {
            this.read("OBJECTS");
            DropDatabase dropDatabase = new DropDatabase(this.session);
            dropDatabase.setDropAllObjects(true);
            if (this.readIf("DELETE")) {
                this.read("FILES");
                dropDatabase.setDeleteFiles(true);
            }
            return dropDatabase;
        }
        if (this.readIf("DOMAIN")) {
            return this.parseDropUserDataType();
        }
        if (this.readIf("TYPE")) {
            return this.parseDropUserDataType();
        }
        if (this.readIf("DATATYPE")) {
            return this.parseDropUserDataType();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseDropAggregate();
        }
        throw this.getSyntaxError();
    }

    private DropUserDataType parseDropUserDataType() {
        boolean bl = this.readIfExists(false);
        DropUserDataType dropUserDataType = new DropUserDataType(this.session);
        dropUserDataType.setTypeName(this.readUniqueIdentifier());
        bl = this.readIfExists(bl);
        dropUserDataType.setIfExists(bl);
        return dropUserDataType;
    }

    private DropAggregate parseDropAggregate() {
        boolean bl = this.readIfExists(false);
        DropAggregate dropAggregate = new DropAggregate(this.session);
        dropAggregate.setName(this.readUniqueIdentifier());
        bl = this.readIfExists(bl);
        dropAggregate.setIfExists(bl);
        return dropAggregate;
    }

    private TableFilter readJoin(TableFilter tableFilter, Select select, boolean bl) {
        TableFilter tableFilter2 = tableFilter;
        while (true) {
            Column[] columnArray;
            TableFilter tableFilter3;
            if (this.readIf("RIGHT")) {
                this.readIf("OUTER");
                this.read("JOIN");
                tableFilter3 = this.readTableFilter(bl);
                tableFilter3 = this.readJoin(tableFilter3, select, true);
                columnArray = null;
                if (this.readIf("ON")) {
                    columnArray = this.readExpression();
                }
                tableFilter3.addJoin(tableFilter, true, (Expression)columnArray);
                tableFilter = tableFilter3;
                tableFilter2 = tableFilter3;
                continue;
            }
            if (this.readIf("LEFT")) {
                this.readIf("OUTER");
                this.read("JOIN");
                tableFilter3 = this.readTableFilter(true);
                tableFilter = this.readJoin(tableFilter, select, true);
                columnArray = null;
                if (this.readIf("ON")) {
                    columnArray = this.readExpression();
                }
                tableFilter.addJoin(tableFilter3, true, (Expression)columnArray);
                tableFilter2 = tableFilter3;
                continue;
            }
            if (this.readIf("FULL")) {
                throw this.getSyntaxError();
            }
            if (this.readIf("INNER")) {
                this.read("JOIN");
                tableFilter3 = this.readTableFilter(bl);
                tableFilter = this.readJoin(tableFilter, select, false);
                columnArray = null;
                if (this.readIf("ON")) {
                    columnArray = this.readExpression();
                }
                tableFilter.addJoin(tableFilter3, bl, (Expression)columnArray);
                tableFilter2 = tableFilter3;
                continue;
            }
            if (this.readIf("JOIN")) {
                tableFilter3 = this.readTableFilter(bl);
                tableFilter = this.readJoin(tableFilter, select, false);
                columnArray = null;
                if (this.readIf("ON")) {
                    columnArray = this.readExpression();
                }
                tableFilter.addJoin(tableFilter3, bl, (Expression)columnArray);
                tableFilter2 = tableFilter3;
                continue;
            }
            if (this.readIf("CROSS")) {
                this.read("JOIN");
                tableFilter3 = this.readTableFilter(bl);
                tableFilter.addJoin(tableFilter3, bl, null);
                tableFilter2 = tableFilter3;
                continue;
            }
            if (!this.readIf("NATURAL")) break;
            this.read("JOIN");
            tableFilter3 = this.readTableFilter(bl);
            columnArray = tableFilter2.getTable().getColumns();
            Column[] columnArray2 = tableFilter3.getTable().getColumns();
            String string = tableFilter2.getTable().getSchema().getName();
            String string2 = tableFilter3.getTable().getSchema().getName();
            Condition condition = null;
            for (Column column : columnArray) {
                String string3 = column.getName();
                for (Column column2 : columnArray2) {
                    String string4 = column2.getName();
                    if (!this.equalsToken(string3, string4)) continue;
                    tableFilter3.addNaturalJoinColumn(column2);
                    ExpressionColumn expressionColumn = new ExpressionColumn(this.database, string, tableFilter2.getTableAlias(), string3);
                    ExpressionColumn expressionColumn2 = new ExpressionColumn(this.database, string2, tableFilter3.getTableAlias(), string4);
                    Comparison comparison = new Comparison(this.session, 0, expressionColumn, expressionColumn2);
                    condition = condition == null ? comparison : new ConditionAndOr(0, condition, comparison);
                }
            }
            tableFilter.addJoin(tableFilter3, bl, condition);
            tableFilter2 = tableFilter3;
        }
        return tableFilter;
    }

    private Prepared parseExecute() {
        ExecuteProcedure executeProcedure = new ExecuteProcedure(this.session);
        String string = this.readAliasIdentifier();
        Procedure procedure = this.session.getProcedure(string);
        if (procedure == null) {
            throw DbException.get(90077, string);
        }
        executeProcedure.setProcedure(procedure);
        if (this.readIf("(")) {
            int n = 0;
            while (true) {
                executeProcedure.setExpression(n, this.readExpression());
                if (this.readIf(")")) break;
                this.read(",");
                ++n;
            }
        }
        return executeProcedure;
    }

    private DeallocateProcedure parseDeallocate() {
        this.readIf("PLAN");
        String string = this.readAliasIdentifier();
        DeallocateProcedure deallocateProcedure = new DeallocateProcedure(this.session);
        deallocateProcedure.setProcedureName(string);
        return deallocateProcedure;
    }

    private ExplainPlan parseExplain() {
        ExplainPlan explainPlan = new ExplainPlan(this.session);
        this.readIf("PLAN");
        this.readIf("FOR");
        if (this.isToken("SELECT") || this.isToken("FROM") || this.isToken("(")) {
            explainPlan.setCommand(this.parseSelect());
        } else if (this.readIf("DELETE")) {
            explainPlan.setCommand(this.parseDelete());
        } else if (this.readIf("UPDATE")) {
            explainPlan.setCommand(this.parseUpdate());
        } else if (this.readIf("INSERT")) {
            explainPlan.setCommand(this.parseInsert());
        } else if (this.readIf("MERGE")) {
            explainPlan.setCommand(this.parseMerge());
        } else {
            throw this.getSyntaxError();
        }
        return explainPlan;
    }

    private Query parseSelect() {
        int n = this.parameters.size();
        Query query = this.parseSelectUnion();
        ArrayList<Parameter> arrayList = New.arrayList();
        for (int i = n; i < this.parameters.size(); ++i) {
            arrayList.add(this.parameters.get(i));
        }
        query.setParameterList(arrayList);
        query.init();
        return query;
    }

    private Query parseSelectUnion() {
        int n = this.lastParseIndex;
        Query query = this.parseSelectSub();
        return this.parseSelectUnionExtension(query, n, false);
    }

    private Query parseSelectUnionExtension(Query query, int n, boolean bl) {
        while (true) {
            SelectUnion selectUnion;
            if (this.readIf("UNION")) {
                selectUnion = new SelectUnion(this.session, query);
                if (this.readIf("ALL")) {
                    selectUnion.setUnionType(1);
                } else {
                    this.readIf("DISTINCT");
                    selectUnion.setUnionType(0);
                }
                selectUnion.setRight(this.parseSelectSub());
                query = selectUnion;
                continue;
            }
            if (this.readIf("MINUS") || this.readIf("EXCEPT")) {
                selectUnion = new SelectUnion(this.session, query);
                selectUnion.setUnionType(2);
                selectUnion.setRight(this.parseSelectSub());
                query = selectUnion;
                continue;
            }
            if (!this.readIf("INTERSECT")) break;
            selectUnion = new SelectUnion(this.session, query);
            selectUnion.setUnionType(3);
            selectUnion.setRight(this.parseSelectSub());
            query = selectUnion;
        }
        if (!bl) {
            this.parseEndOfQuery(query);
        }
        this.setSQL(query, null, n);
        return query;
    }

    private void parseEndOfQuery(Query query) {
        Object object;
        Select select;
        if (this.readIf("ORDER")) {
            this.read("BY");
            select = this.currentSelect;
            if (query instanceof Select) {
                this.currentSelect = (Select)query;
            }
            object = New.arrayList();
            do {
                boolean bl = true;
                if (this.readIf("=")) {
                    bl = false;
                }
                SelectOrderBy selectOrderBy = new SelectOrderBy();
                Expression expression = this.readExpression();
                if (bl && expression instanceof ValueExpression && expression.getType() == 4) {
                    selectOrderBy.columnIndexExpr = expression;
                } else if (expression instanceof Parameter) {
                    this.recompileAlways = true;
                    selectOrderBy.columnIndexExpr = expression;
                } else {
                    selectOrderBy.expression = expression;
                }
                if (this.readIf("DESC")) {
                    selectOrderBy.descending = true;
                } else {
                    this.readIf("ASC");
                }
                if (this.readIf("NULLS")) {
                    if (this.readIf("FIRST")) {
                        selectOrderBy.nullsFirst = true;
                    } else {
                        this.read("LAST");
                        selectOrderBy.nullsLast = true;
                    }
                }
                ((ArrayList)object).add(selectOrderBy);
            } while (this.readIf(","));
            query.setOrder((ArrayList<SelectOrderBy>)object);
            this.currentSelect = select;
        }
        if (this.database.getMode().supportOffsetFetch) {
            select = this.currentSelect;
            this.currentSelect = null;
            if (this.readIf("OFFSET")) {
                query.setOffset(this.readExpression().optimize(this.session));
                if (!this.readIf("ROW")) {
                    this.read("ROWS");
                }
            }
            if (this.readIf("FETCH")) {
                this.read("FIRST");
                if (this.readIf("ROW")) {
                    query.setLimit(ValueExpression.get(ValueInt.get(1)));
                } else {
                    object = this.readExpression().optimize(this.session);
                    query.setLimit((Expression)object);
                    if (!this.readIf("ROW")) {
                        this.read("ROWS");
                    }
                }
                this.read("ONLY");
            }
            this.currentSelect = select;
        }
        if (this.readIf("LIMIT")) {
            select = this.currentSelect;
            this.currentSelect = null;
            object = this.readExpression().optimize(this.session);
            query.setLimit((Expression)object);
            if (this.readIf("OFFSET")) {
                Expression expression = this.readExpression().optimize(this.session);
                query.setOffset(expression);
            } else if (this.readIf(",")) {
                Object object2 = object;
                object = this.readExpression().optimize(this.session);
                query.setOffset((Expression)object2);
                query.setLimit((Expression)object);
            }
            if (this.readIf("SAMPLE_SIZE")) {
                query.setSampleSize(this.getPositiveInt());
            }
            this.currentSelect = select;
        }
        if (this.readIf("FOR")) {
            if (this.readIf("UPDATE")) {
                if (this.readIf("OF")) {
                    do {
                        this.readIdentifierWithSchema();
                    } while (this.readIf(","));
                } else if (!this.readIf("NOWAIT") && this.readIf("WITH")) {
                    this.read("RR");
                }
                query.setForUpdate(true);
            } else if (this.readIf("READ")) {
                this.read("ONLY");
                if (this.readIf("WITH")) {
                    this.read("RS");
                }
            }
        }
    }

    private Query parseSelectSub() {
        if (this.readIf("(")) {
            Query query = this.parseSelectUnion();
            this.read(")");
            return query;
        }
        Select select = this.parseSelectSimple();
        return select;
    }

    private void parseSelectSimpleFromPart(Select select) {
        do {
            TableFilter tableFilter = this.readTableFilter(false);
            this.parseJoinTableFilter(tableFilter, select);
        } while (this.readIf(","));
    }

    private void parseJoinTableFilter(TableFilter tableFilter, Select select) {
        TableFilter tableFilter2;
        tableFilter = this.readJoin(tableFilter, select, tableFilter.isJoinOuter());
        select.addTableFilter(tableFilter, true);
        boolean bl = false;
        while ((tableFilter2 = tableFilter.getJoin()) != null) {
            if (bl |= tableFilter2.isJoinOuter()) {
                select.addTableFilter(tableFilter2, false);
            } else {
                Expression expression = tableFilter2.getJoinCondition();
                if (expression != null) {
                    select.addCondition(expression);
                }
                tableFilter2.removeJoinCondition();
                tableFilter.removeJoin();
                select.addTableFilter(tableFilter2, true);
            }
            tableFilter = tableFilter2;
        }
    }

    private void parseSelectSimpleSelectPart(Select select) {
        Expression expression;
        Object object;
        Select select2 = this.currentSelect;
        this.currentSelect = null;
        if (this.readIf("TOP")) {
            object = this.readTerm().optimize(this.session);
            select.setLimit((Expression)object);
        } else if (this.readIf("LIMIT")) {
            object = this.readTerm().optimize(this.session);
            select.setOffset((Expression)object);
            expression = this.readTerm().optimize(this.session);
            select.setLimit(expression);
        }
        this.currentSelect = select2;
        if (this.readIf("DISTINCT")) {
            select.setDistinct(true);
        } else {
            this.readIf("ALL");
        }
        object = New.arrayList();
        do {
            if (this.readIf("*")) {
                ((ArrayList)object).add(new Wildcard(null, null));
                continue;
            }
            expression = this.readExpression();
            if (this.readIf("AS") || this.currentTokenType == 2) {
                String string = this.readAliasIdentifier();
                expression = new Alias(expression, string, this.database.getMode().aliasColumnName);
            }
            ((ArrayList)object).add(expression);
        } while (this.readIf(","));
        select.setExpressions((ArrayList<Expression>)object);
    }

    private Select parseSelectSimple() {
        Object object;
        Object object2;
        boolean bl;
        if (this.readIf("SELECT")) {
            bl = false;
        } else if (this.readIf("FROM")) {
            bl = true;
        } else {
            throw this.getSyntaxError();
        }
        Select select = new Select(this.session);
        int n = this.lastParseIndex;
        Select select2 = this.currentSelect;
        this.currentSelect = select;
        this.currentPrepared = select;
        if (bl) {
            this.parseSelectSimpleFromPart(select);
            this.read("SELECT");
            this.parseSelectSimpleSelectPart(select);
        } else {
            this.parseSelectSimpleSelectPart(select);
            if (!this.readIf("FROM")) {
                object2 = this.getDualTable();
                object = new TableFilter(this.session, (Table)object2, null, this.rightsChecked, this.currentSelect);
                select.addTableFilter((TableFilter)object, true);
            } else {
                this.parseSelectSimpleFromPart(select);
            }
        }
        if (this.readIf("WHERE")) {
            object2 = this.readExpression();
            select.addCondition((Expression)object2);
        }
        this.currentSelect = select2;
        if (this.readIf("GROUP")) {
            this.read("BY");
            select.setGroupQuery();
            object2 = New.arrayList();
            do {
                object = this.readExpression();
                ((ArrayList)object2).add(object);
            } while (this.readIf(","));
            select.setGroupBy((ArrayList<Expression>)object2);
        }
        this.currentSelect = select;
        if (this.readIf("HAVING")) {
            select.setGroupQuery();
            object2 = this.readExpression();
            select.setHaving((Expression)object2);
        }
        select.setParameterList(this.parameters);
        this.currentSelect = select2;
        this.setSQL(select, "SELECT", n);
        return select;
    }

    private Table getDualTable() {
        Schema schema = this.database.findSchema("PUBLIC");
        ValueExpression valueExpression = ValueExpression.get(ValueLong.get(1L));
        return new RangeTable(schema, valueExpression, valueExpression);
    }

    private void setSQL(Prepared prepared, String string, int n) {
        String string2 = this.originalSQL.substring(n, this.lastParseIndex).trim();
        if (string != null) {
            string2 = string + " " + string2;
        }
        prepared.setSQL(string2);
    }

    private Expression readExpression() {
        Expression expression = this.readAnd();
        while (this.readIf("OR")) {
            expression = new ConditionAndOr(1, expression, this.readAnd());
        }
        return expression;
    }

    private Expression readAnd() {
        Expression expression = this.readCondition();
        while (this.readIf("AND")) {
            expression = new ConditionAndOr(0, expression, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() {
        if (this.readIf("NOT")) {
            return new ConditionNot(this.readCondition());
        }
        if (this.readIf("EXISTS")) {
            this.read("(");
            Query query = this.parseSelect();
            this.read(")");
            return new ConditionExists(query);
        }
        Expression expression = this.readConcat();
        while (true) {
            Object object;
            Expression expression2;
            Object object2;
            int n = this.parseIndex;
            boolean bl = false;
            if (this.readIf("NOT")) {
                bl = true;
                if (this.isToken("NULL")) {
                    this.parseIndex = n;
                    this.currentToken = "NOT";
                    break;
                }
            }
            if (this.readIf("LIKE")) {
                Expression expression3 = this.readConcat();
                object2 = null;
                if (this.readIf("ESCAPE")) {
                    object2 = this.readConcat();
                }
                this.recompileAlways = true;
                expression = new CompareLike(this.database.getCompareMode(), expression, expression3, (Expression)object2, false);
            } else if (this.readIf("REGEXP")) {
                Expression expression4 = this.readConcat();
                expression = new CompareLike(this.database.getCompareMode(), expression, expression4, null, true);
            } else if (this.readIf("IS")) {
                int n2 = this.readIf("NOT") ? 7 : 6;
                this.read("NULL");
                expression = new Comparison(this.session, n2, expression, null);
            } else if (this.readIf("IN")) {
                this.read("(");
                if (this.readIf(")")) {
                    expression = ValueExpression.get(ValueBoolean.get(false));
                } else {
                    Object object3;
                    if (this.isSelect()) {
                        object3 = this.parseSelect();
                        expression = new ConditionInSelect(this.database, expression, (Query)object3, false, 0);
                    } else {
                        object3 = New.arrayList();
                        do {
                            object2 = this.readExpression();
                            ((ArrayList)object3).add(object2);
                        } while (this.readIf(","));
                        if (((ArrayList)object3).size() == 1 && object2 instanceof Subquery) {
                            expression2 = (Subquery)object2;
                            object = ((Subquery)expression2).getQuery();
                            expression = new ConditionInSelect(this.database, expression, (Query)object, false, 0);
                        } else {
                            expression = new ConditionIn(this.database, expression, (List<Expression>)object3);
                        }
                    }
                    this.read(")");
                }
            } else if (this.readIf("BETWEEN")) {
                Expression expression5 = this.readConcat();
                this.read("AND");
                object2 = this.readConcat();
                expression2 = new Comparison(this.session, 3, expression5, expression);
                object = new Comparison(this.session, 1, (Expression)object2, expression);
                expression = new ConditionAndOr(0, expression2, (Expression)object);
            } else {
                int n3 = this.getCompareType(this.currentTokenType);
                if (n3 < 0) break;
                this.read();
                if (this.readIf("ALL")) {
                    this.read("(");
                    object2 = this.parseSelect();
                    expression = new ConditionInSelect(this.database, expression, (Query)object2, true, n3);
                    this.read(")");
                } else if (this.readIf("ANY") || this.readIf("SOME")) {
                    this.read("(");
                    object2 = this.parseSelect();
                    expression = new ConditionInSelect(this.database, expression, (Query)object2, false, n3);
                    this.read(")");
                } else {
                    object2 = this.readConcat();
                    if (this.readIf("(") && this.readIf("+") && this.readIf(")")) {
                        if (expression instanceof ExpressionColumn && object2 instanceof ExpressionColumn) {
                            TableFilter tableFilter;
                            expression2 = (ExpressionColumn)expression;
                            object = (ExpressionColumn)object2;
                            ArrayList<TableFilter> arrayList = this.currentSelect.getTopFilters();
                            Object object4 = arrayList.iterator();
                            while (object4.hasNext()) {
                                for (tableFilter = object4.next(); tableFilter != null; tableFilter = tableFilter.getJoin()) {
                                    ((ExpressionColumn)expression2).mapColumns(tableFilter, 0);
                                    ((ExpressionColumn)object).mapColumns(tableFilter, 0);
                                }
                            }
                            object4 = ((ExpressionColumn)expression2).getTableFilter();
                            tableFilter = ((ExpressionColumn)object).getTableFilter();
                            expression = new Comparison(this.session, n3, expression, (Expression)object2);
                            if (object4 != null && tableFilter != null) {
                                int n4 = arrayList.indexOf(tableFilter);
                                if (n4 >= 0) {
                                    arrayList.remove(n4);
                                    ((TableFilter)object4).addJoin(tableFilter, true, expression);
                                } else {
                                    tableFilter.mapAndAddFilter(expression);
                                }
                                expression = ValueExpression.get(ValueBoolean.get(true));
                            }
                        }
                    } else {
                        expression = new Comparison(this.session, n3, expression, (Expression)object2);
                    }
                }
            }
            if (!bl) continue;
            expression = new ConditionNot(expression);
        }
        return expression;
    }

    private Expression readConcat() {
        Expression expression = this.readSum();
        while (true) {
            Function function;
            if (this.readIf("||")) {
                expression = new Operation(0, expression, this.readSum());
                continue;
            }
            if (this.readIf("~")) {
                if (this.readIf("*")) {
                    function = Function.getFunction(this.database, "CAST");
                    function.setDataType(new Column("X", 14));
                    function.setParameter(0, expression);
                    expression = function;
                }
                expression = new CompareLike(this.database.getCompareMode(), expression, this.readSum(), null, true);
                continue;
            }
            if (!this.readIf("!~")) break;
            if (this.readIf("*")) {
                function = Function.getFunction(this.database, "CAST");
                function.setDataType(new Column("X", 14));
                function.setParameter(0, expression);
                expression = function;
            }
            expression = new ConditionNot(new CompareLike(this.database.getCompareMode(), expression, this.readSum(), null, true));
        }
        return expression;
    }

    private Expression readSum() {
        Expression expression = this.readFactor();
        while (true) {
            if (this.readIf("+")) {
                expression = new Operation(1, expression, this.readFactor());
                continue;
            }
            if (!this.readIf("-")) break;
            expression = new Operation(2, expression, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() {
        Expression expression = this.readTerm();
        while (true) {
            if (this.readIf("*")) {
                expression = new Operation(3, expression, this.readTerm());
                continue;
            }
            if (!this.readIf("/")) break;
            expression = new Operation(4, expression, this.readTerm());
        }
        return expression;
    }

    private Expression readAggregate(int n) {
        Aggregate aggregate;
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        this.currentSelect.setGroupQuery();
        if (n == 1) {
            if (this.readIf("*")) {
                aggregate = new Aggregate(0, null, this.currentSelect, false);
            } else {
                boolean bl = this.readIf("DISTINCT");
                Expression expression = this.readExpression();
                aggregate = expression instanceof Wildcard && !bl ? new Aggregate(0, null, this.currentSelect, false) : new Aggregate(1, expression, this.currentSelect, bl);
            }
        } else if (n == 2) {
            boolean bl = this.readIf("DISTINCT");
            Aggregate aggregate2 = new Aggregate(2, this.readExpression(), this.currentSelect, bl);
            if (this.readIf("ORDER")) {
                this.read("BY");
                aggregate2.setOrder(this.parseSimpleOrderList());
            }
            if (this.readIf("SEPARATOR")) {
                aggregate2.setSeparator(this.readExpression());
            }
            aggregate = aggregate2;
        } else {
            boolean bl = this.readIf("DISTINCT");
            aggregate = new Aggregate(n, this.readExpression(), this.currentSelect, bl);
        }
        this.read(")");
        return aggregate;
    }

    private ArrayList<SelectOrderBy> parseSimpleOrderList() {
        ArrayList<SelectOrderBy> arrayList = New.arrayList();
        do {
            Expression expression;
            SelectOrderBy selectOrderBy = new SelectOrderBy();
            selectOrderBy.expression = expression = this.readExpression();
            if (this.readIf("DESC")) {
                selectOrderBy.descending = true;
            } else {
                this.readIf("ASC");
            }
            arrayList.add(selectOrderBy);
        } while (this.readIf(","));
        return arrayList;
    }

    private JavaFunction readJavaFunction(String string) {
        FunctionAlias functionAlias = this.database.findFunctionAlias(string);
        if (functionAlias == null) {
            throw DbException.get(90022, string);
        }
        ArrayList<Expression> arrayList = New.arrayList();
        int n = 0;
        while (!this.readIf(")")) {
            if (n++ > 0) {
                this.read(",");
            }
            arrayList.add(this.readExpression());
        }
        Expression[] expressionArray = new Expression[n];
        arrayList.toArray(expressionArray);
        JavaFunction javaFunction = new JavaFunction(functionAlias, expressionArray);
        return javaFunction;
    }

    private JavaAggregate readJavaAggregate(UserAggregate userAggregate) {
        ArrayList<Expression> arrayList = New.arrayList();
        do {
            arrayList.add(this.readExpression());
        } while (this.readIf(","));
        this.read(")");
        Expression[] expressionArray = new Expression[arrayList.size()];
        arrayList.toArray(expressionArray);
        JavaAggregate javaAggregate = new JavaAggregate(userAggregate, expressionArray, this.currentSelect);
        this.currentSelect.setGroupQuery();
        return javaAggregate;
    }

    private Expression readFunction(String string) {
        int n = Aggregate.getAggregateType(string);
        if (n >= 0) {
            return this.readAggregate(n);
        }
        Function function = Function.getFunction(this.database, string);
        if (function == null) {
            UserAggregate userAggregate = this.database.findAggregate(string);
            if (userAggregate != null) {
                return this.readJavaAggregate(userAggregate);
            }
            return this.readJavaFunction(string);
        }
        switch (function.getFunctionType()) {
            case 203: {
                function.setParameter(0, this.readExpression());
                this.read("AS");
                Column column = this.parseColumn(null);
                function.setDataType(column);
                this.read(")");
                break;
            }
            case 202: {
                function.setParameter(0, this.readExpression());
                this.read(",");
                Column column = this.parseColumn(null);
                function.setDataType(column);
                this.read(")");
                break;
            }
            case 120: {
                function.setParameter(0, ValueExpression.get(ValueString.get(this.currentToken)));
                this.read();
                this.read("FROM");
                function.setParameter(1, this.readExpression());
                this.read(")");
                break;
            }
            case 103: {
                if (Function.isDatePart(this.currentToken)) {
                    function.setParameter(0, ValueExpression.get(ValueString.get(this.currentToken)));
                    this.read();
                } else {
                    function.setParameter(0, this.readExpression());
                }
                this.read(",");
                function.setParameter(1, this.readExpression());
                this.read(",");
                function.setParameter(2, this.readExpression());
                this.read(")");
                break;
            }
            case 73: {
                function.setParameter(0, this.readExpression());
                if (!this.readIf(",")) {
                    this.read("FROM");
                }
                function.setParameter(1, this.readExpression());
                if (this.readIf("FOR") || this.readIf(",")) {
                    function.setParameter(2, this.readExpression());
                }
                this.read(")");
                break;
            }
            case 77: {
                function.setParameter(0, this.readConcat());
                if (!this.readIf(",")) {
                    this.read("IN");
                }
                function.setParameter(1, this.readExpression());
                this.read(")");
                break;
            }
            case 78: {
                Expression expression = null;
                if (this.readIf("LEADING")) {
                    function = Function.getFunction(this.database, "LTRIM");
                    if (!this.readIf("FROM")) {
                        expression = this.readExpression();
                        this.read("FROM");
                    }
                } else if (this.readIf("TRAILING")) {
                    function = Function.getFunction(this.database, "RTRIM");
                    if (!this.readIf("FROM")) {
                        expression = this.readExpression();
                        this.read("FROM");
                    }
                } else if (this.readIf("BOTH") && !this.readIf("FROM")) {
                    expression = this.readExpression();
                    this.read("FROM");
                }
                Expression expression2 = this.readExpression();
                if (this.readIf(",")) {
                    expression = this.readExpression();
                } else if (this.readIf("FROM")) {
                    expression = expression2;
                    expression2 = this.readExpression();
                }
                function.setParameter(0, expression2);
                if (expression != null) {
                    function.setParameter(1, expression);
                }
                this.read(")");
                break;
            }
            case 223: 
            case 224: {
                Object object;
                int n2 = 0;
                ArrayList<Column> arrayList = New.arrayList();
                do {
                    object = this.readAliasIdentifier();
                    Column column = this.parseColumn((String)object);
                    arrayList.add(column);
                    this.read("=");
                    function.setParameter(n2, this.readExpression());
                    ++n2;
                } while (this.readIf(","));
                this.read(")");
                object = (TableFunction)function;
                ((TableFunction)object).setColumns(arrayList);
                break;
            }
            default: {
                if (this.readIf(")")) break;
                int n3 = 0;
                do {
                    function.setParameter(n3++, this.readExpression());
                } while (this.readIf(","));
                this.read(")");
            }
        }
        function.doneWithParameters();
        return function;
    }

    private Function readFunctionWithoutParameters(String string) {
        if (this.readIf("(")) {
            this.read(")");
        }
        Function function = Function.getFunction(this.database, string);
        function.doneWithParameters();
        return function;
    }

    private Expression readWildcardOrSequenceValue(String string, String string2) {
        Sequence sequence;
        if (this.readIf("*")) {
            return new Wildcard(string, string2);
        }
        if (string == null) {
            string = this.session.getCurrentSchemaName();
        }
        if (this.readIf("NEXTVAL")) {
            Sequence sequence2 = this.findSequence(string, string2);
            if (sequence2 != null) {
                return new SequenceValue(sequence2);
            }
        } else if (this.readIf("CURRVAL") && (sequence = this.findSequence(string, string2)) != null) {
            Function function = Function.getFunction(this.database, "CURRVAL");
            function.setParameter(0, ValueExpression.get(ValueString.get(sequence.getSchema().getName())));
            function.setParameter(1, ValueExpression.get(ValueString.get(sequence.getName())));
            function.doneWithParameters();
            return function;
        }
        return null;
    }

    private Expression readTermObjectDot(String string) {
        Expression expression = this.readWildcardOrSequenceValue(null, string);
        if (expression != null) {
            return expression;
        }
        String string2 = this.readColumnIdentifier();
        if (this.readIf(".")) {
            String string3 = string;
            expression = this.readWildcardOrSequenceValue(string3, string = string2);
            if (expression != null) {
                return expression;
            }
            string2 = this.readColumnIdentifier();
            if (this.readIf(".")) {
                String string4 = string3;
                if (!this.equalsToken(this.database.getShortName(), string4)) {
                    throw DbException.get(90013, string4);
                }
                string3 = string;
                expression = this.readWildcardOrSequenceValue(string3, string = string2);
                if (expression != null) {
                    return expression;
                }
                string2 = this.readColumnIdentifier();
                return new ExpressionColumn(this.database, string3, string, string2);
            }
            return new ExpressionColumn(this.database, string3, string, string2);
        }
        return new ExpressionColumn(this.database, null, string, string2);
    }

    private Expression readTerm() {
        Expression expression;
        Object object;
        Object object2;
        switch (this.currentTokenType) {
            case 12: {
                this.read();
                object2 = new Variable(this.session, this.readAliasIdentifier());
                if (!this.readIf(":=")) break;
                object = this.readExpression();
                expression = Function.getFunction(this.database, "SET");
                ((Function)expression).setParameter(0, (Expression)object2);
                ((Function)expression).setParameter(1, (Expression)object);
                object2 = expression;
                break;
            }
            case 3: {
                boolean bl = Character.isDigit(this.sqlCommandChars[this.parseIndex]);
                this.read();
                if (bl && this.currentTokenType == 5 && this.currentValue.getType() == 4) {
                    int n;
                    if (this.indexedParameterList == null) {
                        if (this.parameters == null) {
                            throw this.getSyntaxError();
                        }
                        if (this.parameters.size() > 0) {
                            throw DbException.get(90123);
                        }
                        this.indexedParameterList = New.arrayList();
                    }
                    if ((n = this.currentValue.getInt() - 1) < 0 || n >= 100000) {
                        throw DbException.getInvalidValueException("" + n, "Parameter Index");
                    }
                    if (this.indexedParameterList.size() <= n) {
                        this.indexedParameterList.ensureCapacity(n + 1);
                        while (this.indexedParameterList.size() <= n) {
                            this.indexedParameterList.add(null);
                        }
                    }
                    if ((expression = this.indexedParameterList.get(n)) == null) {
                        expression = new Parameter(n);
                        this.indexedParameterList.set(n, (Parameter)expression);
                    }
                    this.read();
                } else {
                    if (this.indexedParameterList != null) {
                        throw DbException.get(90123);
                    }
                    expression = new Parameter(this.parameters.size());
                }
                this.parameters.add((Parameter)expression);
                object2 = expression;
                break;
            }
            case 1: {
                if (this.isToken("SELECT") || this.isToken("FROM")) {
                    Query query = this.parseSelect();
                    object2 = new Subquery(query);
                    break;
                }
                throw this.getSyntaxError();
            }
            case 2: {
                String string = this.currentToken;
                if (this.currentTokenQuoted) {
                    this.read();
                    if (this.readIf("(")) {
                        object2 = this.readFunction(string);
                        break;
                    }
                    if (this.readIf(".")) {
                        object2 = this.readTermObjectDot(string);
                        break;
                    }
                    object2 = new ExpressionColumn(this.database, null, null, string);
                    break;
                }
                this.read();
                if (this.equalsToken("X", string) && this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    this.read();
                    byte[] byArray = Utils.convertStringToBytes(this.currentValue.getString());
                    object2 = ValueExpression.get(ValueBytes.getNoCopy(byArray));
                    break;
                }
                if (this.readIf(".")) {
                    object2 = this.readTermObjectDot(string);
                    break;
                }
                if (this.equalsToken("CASE", string)) {
                    if (this.isToken("WHEN")) {
                        object2 = this.readWhen(null);
                        break;
                    }
                    Expression expression2 = this.readExpression();
                    object2 = this.readWhen(expression2);
                    break;
                }
                if (this.readIf("(")) {
                    object2 = this.readFunction(string);
                    break;
                }
                if (this.equalsToken("CURRENT_USER", string)) {
                    object2 = this.readFunctionWithoutParameters("USER");
                    break;
                }
                if (this.equalsToken("CURRENT", string)) {
                    if (this.readIf("TIMESTAMP")) {
                        object2 = this.readFunctionWithoutParameters("CURRENT_TIMESTAMP");
                        break;
                    }
                    if (this.readIf("TIME")) {
                        object2 = this.readFunctionWithoutParameters("CURRENT_TIME");
                        break;
                    }
                    if (this.readIf("DATE")) {
                        object2 = this.readFunctionWithoutParameters("CURRENT_DATE");
                        break;
                    }
                    object2 = new ExpressionColumn(this.database, null, null, string);
                    break;
                }
                if (this.equalsToken("NEXT", string) && this.readIf("VALUE")) {
                    this.read("FOR");
                    Sequence sequence = this.readSequence();
                    object2 = new SequenceValue(sequence);
                    break;
                }
                if (this.equalsToken("DATE", string) && this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    String string2 = this.currentValue.getString();
                    this.read();
                    object2 = ValueExpression.get(ValueDate.get(ValueDate.parseDate(string2)));
                    break;
                }
                if (this.equalsToken("TIME", string) && this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    String string3 = this.currentValue.getString();
                    this.read();
                    object2 = ValueExpression.get(ValueTime.get(ValueTime.parseTime(string3)));
                    break;
                }
                if (this.equalsToken("TIMESTAMP", string) && this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    String string4 = this.currentValue.getString();
                    this.read();
                    object2 = ValueExpression.get(ValueTimestamp.getNoCopy(ValueTimestamp.parseTimestamp(string4)));
                    break;
                }
                if (this.equalsToken("E", string) && this.currentTokenType == 5 && this.currentValue.getType() == 13) {
                    String string5 = this.currentValue.getString();
                    this.read();
                    object2 = ValueExpression.get(ValueString.get(string5));
                    break;
                }
                object2 = new ExpressionColumn(this.database, null, null, string);
                break;
            }
            case 13: {
                this.read();
                if (this.currentTokenType == 5) {
                    object2 = ValueExpression.get(this.currentValue.negate());
                    if (((Expression)object2).getType() == 5 && ((Expression)object2).getValue(this.session).getLong() == Integer.MIN_VALUE) {
                        object2 = ValueExpression.get(ValueInt.get(Integer.MIN_VALUE));
                    } else if (((Expression)object2).getType() == 6 && ((Expression)object2).getValue(this.session).getBigDecimal().compareTo(ValueLong.MIN_BD) == 0) {
                        object2 = ValueExpression.get(ValueLong.get(Long.MIN_VALUE));
                    }
                    this.read();
                    break;
                }
                object2 = new Operation(5, this.readTerm(), null);
                break;
            }
            case 14: {
                this.read();
                object2 = this.readTerm();
                break;
            }
            case 16: {
                this.read();
                object2 = this.readExpression();
                if (this.readIf(",")) {
                    ArrayList<Expression> arrayList = New.arrayList();
                    arrayList.add((Expression)object2);
                    do {
                        object2 = this.readExpression();
                        arrayList.add((Expression)object2);
                    } while (this.readIf(","));
                    Expression[] expressionArray = new Expression[arrayList.size()];
                    arrayList.toArray(expressionArray);
                    object2 = new ExpressionList(expressionArray);
                }
                this.read(")");
                break;
            }
            case 19: {
                this.read();
                object2 = ValueExpression.get(ValueBoolean.get(true));
                break;
            }
            case 20: {
                this.read();
                object2 = ValueExpression.get(ValueBoolean.get(false));
                break;
            }
            case 23: {
                this.read();
                object2 = this.readFunctionWithoutParameters("CURRENT_TIME");
                break;
            }
            case 22: {
                this.read();
                object2 = this.readFunctionWithoutParameters("CURRENT_DATE");
                break;
            }
            case 21: {
                Function function = Function.getFunction(this.database, "CURRENT_TIMESTAMP");
                this.read();
                if (this.readIf("(") && !this.readIf(")")) {
                    function.setParameter(0, this.readExpression());
                    this.read(")");
                }
                function.doneWithParameters();
                object2 = function;
                break;
            }
            case 24: {
                this.read();
                if (this.readIf("(")) {
                    this.read(")");
                }
                object2 = new Rownum(this.currentSelect == null ? this.currentPrepared : this.currentSelect);
                break;
            }
            case 18: {
                this.read();
                object2 = ValueExpression.getNull();
                break;
            }
            case 5: {
                object2 = ValueExpression.get(this.currentValue);
                this.read();
                break;
            }
            default: {
                throw this.getSyntaxError();
            }
        }
        if (this.readIf("[")) {
            object = Function.getFunction(this.database, "ARRAY_GET");
            ((Function)object).setParameter(0, (Expression)object2);
            object2 = this.readExpression();
            object2 = new Operation(1, (Expression)object2, ValueExpression.get(ValueInt.get(1)));
            ((Function)object).setParameter(1, (Expression)object2);
            object2 = object;
            this.read("]");
        }
        if (this.readIf("::")) {
            object = this.parseColumn(null);
            expression = Function.getFunction(this.database, "CAST");
            ((Function)expression).setDataType((Column)object);
            ((Function)expression).setParameter(0, (Expression)object2);
            object2 = expression;
        }
        return object2;
    }

    private Expression readWhen(Expression expression) {
        if (this.readIf("END")) {
            this.readIf("CASE");
            return ValueExpression.getNull();
        }
        if (this.readIf("ELSE")) {
            Expression expression2 = this.readExpression();
            this.read("END");
            this.readIf("CASE");
            return expression2;
        }
        this.readIf("WHEN");
        Expression expression3 = this.readExpression();
        if (expression != null) {
            expression3 = new Comparison(this.session, 0, expression, expression3);
        }
        this.read("THEN");
        Expression expression4 = this.readExpression();
        Expression expression5 = this.readWhen(expression);
        Function function = Function.getFunction(this.session.getDatabase(), "CASEWHEN");
        function.setParameter(0, expression3);
        function.setParameter(1, expression4);
        function.setParameter(2, expression5);
        function.doneWithParameters();
        return function;
    }

    private int getPositiveInt() {
        int n = this.getInt();
        if (n < 0) {
            throw DbException.getInvalidValueException("" + n, "positive integer");
        }
        return n;
    }

    private int getInt() {
        boolean bl = false;
        if (this.currentTokenType == 13) {
            bl = true;
            this.read();
        } else if (this.currentTokenType == 14) {
            this.read();
        }
        if (this.currentTokenType != 5 || this.currentValue.getType() != 4) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "integer");
        }
        int n = this.currentValue.getInt();
        this.read();
        return bl ? -n : n;
    }

    private long readLong() {
        boolean bl = false;
        if (this.currentTokenType == 13) {
            bl = true;
            this.read();
        }
        if (this.currentTokenType != 5 || this.currentValue.getType() != 4 && this.currentValue.getType() != 5) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "long");
        }
        long l = this.currentValue.getLong();
        this.read();
        return bl ? -l : l;
    }

    private boolean readBooleanSetting() {
        if (this.currentTokenType == 5) {
            boolean bl = this.currentValue.getBoolean();
            this.read();
            return bl;
        }
        if (this.readIf("TRUE") || this.readIf("ON")) {
            return true;
        }
        if (this.readIf("FALSE") || this.readIf("OFF")) {
            return false;
        }
        throw this.getSyntaxError();
    }

    private String readString() {
        Expression expression = this.readExpression().optimize(this.session);
        if (!(expression instanceof ValueExpression)) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "string");
        }
        String string = expression.getValue(this.session).getString();
        return string;
    }

    private String readIdentifierWithSchema(String string) {
        if (this.currentTokenType != 2) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String string2 = this.currentToken;
        this.read();
        this.schemaName = string;
        if (this.readIf(".")) {
            this.schemaName = string2;
            if (this.currentTokenType != 2) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
            }
            string2 = this.currentToken;
            this.read();
        }
        if (this.equalsToken(".", this.currentToken) && this.equalsToken(this.schemaName, this.database.getShortName())) {
            this.read(".");
            this.schemaName = string2;
            if (this.currentTokenType != 2) {
                throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
            }
            string2 = this.currentToken;
            this.read();
        }
        return string2;
    }

    private String readIdentifierWithSchema() {
        return this.readIdentifierWithSchema(this.session.getCurrentSchemaName());
    }

    private String readAliasIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readUniqueIdentifier() {
        return this.readColumnIdentifier();
    }

    private String readColumnIdentifier() {
        if (this.currentTokenType != 2) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, "identifier");
        }
        String string = this.currentToken;
        this.read();
        return string;
    }

    private void read(String string) {
        if (this.currentTokenQuoted || !this.equalsToken(string, this.currentToken)) {
            throw DbException.getSyntaxError(this.sqlCommand, this.parseIndex, string);
        }
        this.read();
    }

    private boolean readIf(String string) {
        if (!this.currentTokenQuoted && this.equalsToken(string, this.currentToken)) {
            this.read();
            return true;
        }
        this.addExpected(string);
        return false;
    }

    private boolean isToken(String string) {
        boolean bl;
        boolean bl2 = bl = this.equalsToken(string, this.currentToken) && !this.currentTokenQuoted;
        if (bl) {
            return true;
        }
        this.addExpected(string);
        return false;
    }

    private boolean equalsToken(String string, String string2) {
        if (string.equals(string2)) {
            return true;
        }
        return !this.identifiersToUpper && string.equalsIgnoreCase(string2);
    }

    private void addExpected(String string) {
        if (this.expectedList != null) {
            this.expectedList.add(string);
        }
    }

    private void read() {
        this.currentTokenQuoted = false;
        if (this.expectedList != null) {
            this.expectedList.clear();
        }
        int[] nArray = this.characterTypes;
        this.lastParseIndex = this.parseIndex;
        int n = this.parseIndex;
        int n2 = nArray[n];
        while (n2 == 0) {
            n2 = nArray[++n];
        }
        int n3 = n;
        char[] cArray = this.sqlCommandChars;
        char c = cArray[n++];
        this.currentToken = "";
        switch (n2) {
            case 4: {
                while ((n2 = nArray[n]) == 4 || n2 == 2) {
                    ++n;
                }
                this.currentToken = StringUtils.fromCacheOrNew(this.sqlCommand.substring(n3, n));
                this.currentTokenType = this.getTokenType(this.currentToken);
                this.parseIndex = n;
                return;
            }
            case 3: {
                String string = null;
                while (true) {
                    int n4 = ++n;
                    while (true) {
                        if (cArray[n] == '\"') {
                            if (string == null) {
                                string = this.sqlCommand.substring(n4, n);
                                break;
                            }
                            string = string + this.sqlCommand.substring(n4 - 1, n);
                            break;
                        }
                        ++n;
                    }
                    if (cArray[++n] != '\"') break;
                }
                this.currentToken = StringUtils.fromCacheOrNew(string);
                this.parseIndex = n;
                this.currentTokenQuoted = true;
                this.currentTokenType = 2;
                return;
            }
            case 6: {
                if (nArray[n] == 6) {
                    ++n;
                }
                this.currentToken = this.sqlCommand.substring(n3, n);
                this.currentTokenType = this.getSpecialType(this.currentToken);
                this.parseIndex = n;
                return;
            }
            case 5: {
                this.currentToken = this.sqlCommand.substring(n3, n);
                this.currentTokenType = this.getSpecialType(this.currentToken);
                this.parseIndex = n;
                return;
            }
            case 2: {
                if (c == '0' && cArray[n] == 'X') {
                    long l = 0L;
                    n3 += 2;
                    ++n;
                    while (true) {
                        if (!((c = cArray[n]) >= '0' && c <= '9' || c >= 'A' && c <= 'F')) {
                            this.checkLiterals(false);
                            this.currentValue = ValueInt.get((int)l);
                            this.currentTokenType = 5;
                            this.currentToken = "0";
                            this.parseIndex = n;
                            return;
                        }
                        if ((l = (l << 4) + (long)c - (long)(c >= 'A' ? 55 : 48)) > Integer.MAX_VALUE) {
                            this.readHexDecimal(n3, n);
                            return;
                        }
                        ++n;
                    }
                }
                long l = c - 48;
                while (true) {
                    if ((c = cArray[n]) < '0' || c > '9') {
                        if (c == '.') {
                            this.readDecimal(n3, n);
                            break;
                        }
                        if (c == 'E') {
                            this.readDecimal(n3, n);
                            break;
                        }
                        this.checkLiterals(false);
                        this.currentValue = ValueInt.get((int)l);
                        this.currentTokenType = 5;
                        this.currentToken = "0";
                        this.parseIndex = n;
                        break;
                    }
                    if ((l = l * 10L + (long)(c - 48)) > Integer.MAX_VALUE) {
                        this.readDecimal(n3, n);
                        break;
                    }
                    ++n;
                }
                return;
            }
            case 8: {
                if (nArray[n] != 2) {
                    this.currentTokenType = 1;
                    this.currentToken = ".";
                    this.parseIndex = n;
                    return;
                }
                this.readDecimal(n - 1, n);
                return;
            }
            case 7: {
                String string = null;
                while (true) {
                    int n5 = ++n;
                    while (true) {
                        if (cArray[n] == '\'') {
                            if (string == null) {
                                string = this.sqlCommand.substring(n5, n);
                                break;
                            }
                            string = string + this.sqlCommand.substring(n5 - 1, n);
                            break;
                        }
                        ++n;
                    }
                    if (cArray[++n] != '\'') break;
                }
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(StringUtils.fromCacheOrNew(string));
                this.parseIndex = n;
                this.currentTokenType = 5;
                return;
            }
            case 9: {
                String string = null;
                int n6 = n - 1;
                while (nArray[n] == 9) {
                    ++n;
                }
                string = this.sqlCommand.substring(n6, n);
                this.currentToken = "'";
                this.checkLiterals(true);
                this.currentValue = ValueString.get(StringUtils.fromCacheOrNew(string));
                this.parseIndex = n;
                this.currentTokenType = 5;
                return;
            }
            case 1: {
                this.currentToken = "";
                this.currentTokenType = 4;
                this.parseIndex = n;
                return;
            }
        }
        throw this.getSyntaxError();
    }

    private void checkLiterals(boolean bl) {
        int n;
        if (!this.session.getAllowLiterals() && ((n = this.database.getAllowLiterals()) == 0 || bl && n != 2)) {
            throw DbException.get(90116);
        }
    }

    private void readHexDecimal(int n, int n2) {
        char c;
        char[] cArray = this.sqlCommandChars;
        while ((c = cArray[++n2]) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
        }
        this.parseIndex = n2;
        String string = this.sqlCommand.substring(n, n2);
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(string, 16));
        this.checkLiterals(false);
        this.currentValue = ValueDecimal.get(bigDecimal);
        this.currentTokenType = 5;
    }

    private void readDecimal(int n, int n2) {
        Number number;
        int n3;
        char[] cArray = this.sqlCommandChars;
        int[] nArray = this.characterTypes;
        while ((n3 = nArray[n2]) == 8 || n3 == 2) {
            ++n2;
        }
        n3 = 0;
        if (cArray[n2] == 'E' || cArray[n2] == 'e') {
            n3 = 1;
            if (cArray[++n2] == '+' || cArray[n2] == '-') {
                ++n2;
            }
            if (nArray[n2] != 2) {
                throw this.getSyntaxError();
            }
            while (nArray[++n2] == 2) {
            }
        }
        this.parseIndex = n2;
        String string = this.sqlCommand.substring(n, n2);
        this.checkLiterals(false);
        if (n3 == 0 && string.indexOf(46) < 0 && ((BigInteger)(number = new BigInteger(string))).compareTo(ValueLong.MAX) <= 0) {
            this.currentValue = ValueLong.get(((BigInteger)number).longValue());
            this.currentTokenType = 5;
            return;
        }
        try {
            number = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw DbException.get(90021, numberFormatException, string);
        }
        this.currentValue = ValueDecimal.get((BigDecimal)number);
        this.currentTokenType = 5;
    }

    public Session getSession() {
        return this.session;
    }

    private void initialize(String string) {
        if (string == null) {
            string = "";
        }
        this.originalSQL = string;
        this.sqlCommand = string;
        int n = string.length() + 1;
        char[] cArray = new char[n];
        int[] nArray = new int[n];
        string.getChars(0, --n, cArray, 0);
        boolean bl = false;
        cArray[n] = 32;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            int n4 = 0;
            switch (c) {
                case '/': {
                    if (cArray[i + 1] == '*') {
                        bl = true;
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        n2 = i;
                        this.checkRunOver(i += 2, n, n2);
                        while (cArray[i] != '*' || cArray[i + 1] != '/') {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (cArray[i + 1] == '/') {
                        bl = true;
                        n2 = i;
                        while ((c = cArray[i]) != '\n' && c != '\r' && i < n - 1) {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '-': {
                    if (cArray[i + 1] == '-') {
                        bl = true;
                        n2 = i;
                        while ((c = cArray[i]) != '\n' && c != '\r' && i < n - 1) {
                            cArray[i++] = 32;
                            this.checkRunOver(i, n, n2);
                        }
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '$': {
                    if (cArray[i + 1] == '$' && (i == 0 || cArray[i - 1] <= ' ')) {
                        bl = true;
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        n2 = i;
                        this.checkRunOver(i += 2, n, n2);
                        while (cArray[i] != '$' || cArray[i + 1] != '$') {
                            nArray[i++] = 9;
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 32;
                        cArray[i + 1] = 32;
                        ++i;
                        break;
                    }
                    if (n3 == 4 || n3 == 2) {
                        n4 = 4;
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '?': 
                case '@': 
                case ']': 
                case '{': 
                case '}': {
                    n4 = 5;
                    break;
                }
                case '!': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '|': 
                case '~': {
                    n4 = 6;
                    break;
                }
                case '.': {
                    n4 = 8;
                    break;
                }
                case '\'': {
                    nArray[i] = 7;
                    n4 = 7;
                    n2 = i;
                    while (cArray[++i] != '\'') {
                        this.checkRunOver(i, n, n2);
                    }
                    break;
                }
                case '[': {
                    if (this.database.getMode().squareBracketQuotedNames) {
                        cArray[i] = 34;
                        bl = true;
                        nArray[i] = 3;
                        n4 = 3;
                        n2 = i;
                        while (cArray[++i] != ']') {
                            this.checkRunOver(i, n, n2);
                        }
                        cArray[i] = 34;
                        break;
                    }
                    n4 = 5;
                    break;
                }
                case '`': {
                    cArray[i] = 34;
                    bl = true;
                    nArray[i] = 3;
                    n4 = 3;
                    n2 = i;
                    while (cArray[++i] != '`') {
                        this.checkRunOver(i, n, n2);
                        c = cArray[i];
                        cArray[i] = Character.toUpperCase(c);
                    }
                    cArray[i] = 34;
                    break;
                }
                case '\"': {
                    nArray[i] = 3;
                    n4 = 3;
                    n2 = i;
                    while (cArray[++i] != '\"') {
                        this.checkRunOver(i, n, n2);
                    }
                    break;
                }
                case '_': {
                    n4 = 4;
                    break;
                }
                default: {
                    char c2;
                    if (c >= 'a' && c <= 'z') {
                        if (this.identifiersToUpper) {
                            cArray[i] = (char)(c - 32);
                            bl = true;
                        }
                        n4 = 4;
                        break;
                    }
                    if (c >= 'A' && c <= 'Z') {
                        n4 = 4;
                        break;
                    }
                    if (c >= '0' && c <= '9') {
                        n4 = 2;
                        break;
                    }
                    if (!Character.isJavaIdentifierPart(c)) break;
                    n4 = 4;
                    if (!this.identifiersToUpper || (c2 = Character.toUpperCase(c)) == c) break;
                    cArray[i] = c2;
                    bl = true;
                }
            }
            nArray[i] = n4;
            n3 = n4;
        }
        this.sqlCommandChars = cArray;
        nArray[n] = 1;
        this.characterTypes = nArray;
        if (bl) {
            this.sqlCommand = new String(cArray);
        }
        this.parseIndex = 0;
    }

    private void checkRunOver(int n, int n2, int n3) {
        if (n >= n2) {
            this.parseIndex = n3;
            throw this.getSyntaxError();
        }
    }

    private int getSpecialType(String string) {
        char c = string.charAt(0);
        if (string.length() == 1) {
            switch (c) {
                case '$': 
                case '?': {
                    return 3;
                }
                case '@': {
                    return 12;
                }
                case '+': {
                    return 14;
                }
                case '-': {
                    return 13;
                }
                case '*': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '[': 
                case ']': 
                case '{': 
                case '}': 
                case '~': {
                    return 1;
                }
                case '(': {
                    return 16;
                }
                case ')': {
                    return 17;
                }
                case '<': {
                    return 9;
                }
                case '>': {
                    return 8;
                }
                case '=': {
                    return 6;
                }
            }
        } else if (string.length() == 2) {
            switch (c) {
                case ':': {
                    if ("::".equals(string)) {
                        return 1;
                    }
                    if (!":=".equals(string)) break;
                    return 1;
                }
                case '>': {
                    if (!">=".equals(string)) break;
                    return 7;
                }
                case '<': {
                    if ("<=".equals(string)) {
                        return 10;
                    }
                    if (!"<>".equals(string)) break;
                    return 11;
                }
                case '!': {
                    if ("!=".equals(string)) {
                        return 11;
                    }
                    if (!"!~".equals(string)) break;
                    return 1;
                }
                case '|': {
                    if (!"||".equals(string)) break;
                    return 15;
                }
            }
        }
        throw this.getSyntaxError();
    }

    private int getTokenType(String string) {
        int n = string.length();
        if (n == 0) {
            throw this.getSyntaxError();
        }
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        return Parser.getSaveTokenType(string, this.database.getMode().supportOffsetFetch);
    }

    private boolean isKeyword(String string) {
        if (!this.identifiersToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        return Parser.isKeyword(string, false);
    }

    public static boolean isKeyword(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return Parser.getSaveTokenType(string, bl) != 2;
    }

    private static int getSaveTokenType(String string, boolean bl) {
        switch (string.charAt(0)) {
            case 'C': {
                if (string.equals("CURRENT_TIMESTAMP")) {
                    return 21;
                }
                if (string.equals("CURRENT_TIME")) {
                    return 23;
                }
                if (string.equals("CURRENT_DATE")) {
                    return 22;
                }
                return Parser.getKeywordOrIdentifier(string, "CROSS", 1);
            }
            case 'D': {
                return Parser.getKeywordOrIdentifier(string, "DISTINCT", 1);
            }
            case 'E': {
                if ("EXCEPT".equals(string)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(string, "EXISTS", 1);
            }
            case 'F': {
                if ("FROM".equals(string)) {
                    return 1;
                }
                if ("FOR".equals(string)) {
                    return 1;
                }
                if ("FULL".equals(string)) {
                    return 1;
                }
                if (bl && "FETCH".equals(string)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(string, "FALSE", 20);
            }
            case 'G': {
                return Parser.getKeywordOrIdentifier(string, "GROUP", 1);
            }
            case 'H': {
                return Parser.getKeywordOrIdentifier(string, "HAVING", 1);
            }
            case 'I': {
                if ("INNER".equals(string)) {
                    return 1;
                }
                if ("INTERSECT".equals(string)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(string, "IS", 1);
            }
            case 'J': {
                return Parser.getKeywordOrIdentifier(string, "JOIN", 1);
            }
            case 'L': {
                if ("LIMIT".equals(string)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(string, "LIKE", 1);
            }
            case 'M': {
                return Parser.getKeywordOrIdentifier(string, "MINUS", 1);
            }
            case 'N': {
                if ("NOT".equals(string)) {
                    return 1;
                }
                if ("NATURAL".equals(string)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(string, "NULL", 18);
            }
            case 'O': {
                if ("ON".equals(string)) {
                    return 1;
                }
                if (bl && "OFFSET".equals(string)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(string, "ORDER", 1);
            }
            case 'P': {
                return Parser.getKeywordOrIdentifier(string, "PRIMARY", 1);
            }
            case 'R': {
                return Parser.getKeywordOrIdentifier(string, "ROWNUM", 24);
            }
            case 'S': {
                if (string.equals("SYSTIMESTAMP")) {
                    return 21;
                }
                if (string.equals("SYSTIME")) {
                    return 23;
                }
                if (string.equals("SYSDATE")) {
                    return 21;
                }
                return Parser.getKeywordOrIdentifier(string, "SELECT", 1);
            }
            case 'T': {
                if ("TODAY".equals(string)) {
                    return 22;
                }
                return Parser.getKeywordOrIdentifier(string, "TRUE", 19);
            }
            case 'U': {
                if ("UNIQUE".equals(string)) {
                    return 1;
                }
                return Parser.getKeywordOrIdentifier(string, "UNION", 1);
            }
            case 'W': {
                return Parser.getKeywordOrIdentifier(string, "WHERE", 1);
            }
        }
        return 2;
    }

    private static int getKeywordOrIdentifier(String string, String string2, int n) {
        if (string.equals(string2)) {
            return n;
        }
        return 2;
    }

    private Column parseColumnForTable(String string) {
        String string2;
        Column column;
        boolean bl = false;
        if (this.readIf("IDENTITY") || this.readIf("SERIAL")) {
            column = new Column(string, 5);
            column.setOriginalSQL("IDENTITY");
            this.parseAutoIncrement(column);
            column.setPrimaryKey(true);
        } else {
            column = this.parseColumn(string);
        }
        if (this.readIf("NOT")) {
            this.read("NULL");
            column.setNullable(false);
        } else {
            this.readIf("NULL");
            column.setNullable(true);
        }
        if (this.readIf("AS")) {
            if (bl) {
                this.getSyntaxError();
            }
            Expression expression = this.readExpression();
            column.setComputedExpression(expression);
        } else if (this.readIf("DEFAULT")) {
            Expression expression = this.readExpression();
            column.setDefaultExpression(this.session, expression);
        } else if (this.readIf("GENERATED")) {
            if (!this.readIf("ALWAYS")) {
                this.read("BY");
                this.read("DEFAULT");
            }
            this.read("AS");
            this.read("IDENTITY");
            long l = 1L;
            long l2 = 1L;
            if (this.readIf("(")) {
                this.read("START");
                this.readIf("WITH");
                l = this.readLong();
                this.readIf(",");
                if (this.readIf("INCREMENT")) {
                    this.readIf("BY");
                    l2 = this.readLong();
                }
                this.read(")");
            }
            column.setPrimaryKey(true);
            column.setAutoIncrement(true, l, l2);
        }
        if (this.readIf("NOT")) {
            this.read("NULL");
            column.setNullable(false);
        } else {
            this.readIf("NULL");
        }
        if (this.readIf("AUTO_INCREMENT")) {
            this.parseAutoIncrement(column);
            if (this.readIf("NOT")) {
                this.read("NULL");
            }
        } else if (this.readIf("IDENTITY")) {
            this.parseAutoIncrement(column);
            column.setPrimaryKey(true);
            if (this.readIf("NOT")) {
                this.read("NULL");
            }
        }
        if (this.readIf("NULL_TO_DEFAULT")) {
            column.setConvertNullToDefault(true);
        }
        if (this.readIf("SEQUENCE")) {
            Sequence sequence = this.readSequence();
            column.setSequence(sequence);
        }
        if (this.readIf("SELECTIVITY")) {
            int n = this.getPositiveInt();
            column.setSelectivity(n);
        }
        if ((string2 = this.readCommentIf()) != null) {
            column.setComment(string2);
        }
        return column;
    }

    private void parseAutoIncrement(Column column) {
        long l = 1L;
        long l2 = 1L;
        if (this.readIf("(")) {
            l = this.readLong();
            if (this.readIf(",")) {
                l2 = this.readLong();
            }
            this.read(")");
        }
        column.setAutoIncrement(true, l, l2);
    }

    private String readCommentIf() {
        if (this.readIf("COMMENT")) {
            this.readIf("IS");
            return this.readString();
        }
        return null;
    }

    private Column parseColumn(String string) {
        DataType dataType;
        UserDataType userDataType;
        String string2 = this.currentToken;
        boolean bl = false;
        if (this.readIf("LONG")) {
            if (this.readIf("RAW")) {
                string2 = string2 + " RAW";
            }
        } else if (this.readIf("DOUBLE")) {
            if (this.readIf("PRECISION")) {
                string2 = string2 + " PRECISION";
            }
        } else if (this.readIf("CHARACTER")) {
            if (this.readIf("VARYING")) {
                string2 = string2 + " VARYING";
            }
        } else {
            bl = true;
        }
        long l = -1L;
        int n = -1;
        int n2 = -1;
        String string3 = null;
        Column column = null;
        if (!this.identifiersToUpper) {
            string2 = StringUtils.toUpperEnglish(string2);
        }
        if ((userDataType = this.database.findUserDataType(string2)) != null) {
            column = userDataType.getColumn();
            dataType = DataType.getDataType(column.getType());
            string3 = column.getComment();
            string2 = column.getOriginalSQL();
            l = column.getPrecision();
            n = column.getDisplaySize();
            n2 = column.getScale();
        } else {
            dataType = DataType.getTypeByName(string2);
            if (dataType == null) {
                throw DbException.get(50004, this.currentToken);
            }
        }
        if (this.database.getIgnoreCase() && dataType.type == 13 && !this.equalsToken("VARCHAR_CASESENSITIVE", string2)) {
            string2 = "VARCHAR_IGNORECASE";
            dataType = DataType.getTypeByName(string2);
        }
        if (dataType.type == 0) {
            throw DbException.get(50004, string2);
        }
        if (bl) {
            this.read();
        }
        l = l == -1L ? dataType.defaultPrecision : l;
        n = n == -1 ? dataType.defaultDisplaySize : n;
        int n3 = n2 = n2 == -1 ? dataType.defaultScale : n2;
        if (dataType.supportsPrecision || dataType.supportsScale) {
            if (this.readIf("(")) {
                long l2 = this.readLong();
                if (this.readIf("K")) {
                    l2 *= 1024L;
                } else if (this.readIf("M")) {
                    l2 *= 0x100000L;
                } else if (this.readIf("G")) {
                    l2 *= 0x40000000L;
                }
                if (l2 > Long.MAX_VALUE) {
                    l2 = Long.MAX_VALUE;
                }
                string2 = string2 + "(" + l2;
                this.readIf("CHAR");
                if (dataType.supportsScale) {
                    if (this.readIf(",")) {
                        n2 = this.getInt();
                        string2 = string2 + ", " + n2;
                    } else if (dataType.type == 11) {
                        n2 = MathUtils.convertLongToInt(l2);
                        l2 = l;
                    } else {
                        n2 = 0;
                    }
                }
                l = l2;
                n = MathUtils.convertLongToInt(l);
                string2 = string2 + ")";
                this.read(")");
            }
        } else if (this.readIf("(")) {
            this.getPositiveInt();
            this.read(")");
        }
        if (this.readIf("FOR")) {
            this.read("BIT");
            this.read("DATA");
            if (dataType.type == 13) {
                dataType = DataType.getTypeByName("BINARY");
            }
        }
        this.readIf("UNSIGNED");
        int n4 = dataType.type;
        Column column2 = new Column(string, n4, l, n2, n);
        if (column != null) {
            Expression expression;
            column2.setNullable(column.isNullable());
            column2.setDefaultExpression(this.session, column.getDefaultExpression());
            int n5 = column.getSelectivity();
            if (n5 != 50) {
                column2.setSelectivity(n5);
            }
            if ((expression = column.getCheckConstraint(this.session, string)) != null) {
                column2.addCheckConstraint(this.session, expression);
            }
        }
        column2.setComment(string3);
        column2.setOriginalSQL(string2);
        return column2;
    }

    private Prepared parseCreate() {
        boolean bl = this.readIf("FORCE");
        if (this.readIf("LOCAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, false, bl);
            }
            this.read("TABLE");
            return this.parseCreateTable(true, false, false);
        }
        if (this.readIf("GLOBAL")) {
            this.read("TEMPORARY");
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, bl);
            }
            this.read("TABLE");
            return this.parseCreateTable(true, true, false);
        }
        if (this.readIf("TEMP") || this.readIf("TEMPORARY")) {
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, bl);
            }
            this.read("TABLE");
            return this.parseCreateTable(true, true, false);
        }
        if (this.readIf("MEMORY")) {
            this.read("TABLE");
            return this.parseCreateTable(false, false, false);
        }
        if (this.readIf("LINKED")) {
            return this.parseCreateLinkedTable(false, false, bl);
        }
        if (this.readIf("CACHED")) {
            this.read("TABLE");
            return this.parseCreateTable(false, false, true);
        }
        if (this.readIf("TABLE")) {
            Setting setting = this.database.findSetting(SetTypes.getTypeName(7));
            int n = setting == null ? 0 : setting.getIntValue();
            return this.parseCreateTable(false, false, n == 0);
        }
        if (this.readIf("VIEW")) {
            return this.parseCreateView(bl);
        }
        if (this.readIf("ALIAS")) {
            return this.parseCreateFunctionAlias(bl);
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseCreateSequence();
        }
        if (this.readIf("USER")) {
            return this.parseCreateUser();
        }
        if (this.readIf("TRIGGER")) {
            return this.parseCreateTrigger(bl);
        }
        if (this.readIf("ROLE")) {
            return this.parseCreateRole();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseCreateSchema();
        }
        if (this.readIf("CONSTANT")) {
            return this.parseCreateConstant();
        }
        if (this.readIf("DOMAIN")) {
            return this.parseCreateUserDataType();
        }
        if (this.readIf("TYPE")) {
            return this.parseCreateUserDataType();
        }
        if (this.readIf("DATATYPE")) {
            return this.parseCreateUserDataType();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseCreateAggregate(bl);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string = null;
        Schema schema = null;
        boolean bl5 = false;
        if (this.readIf("PRIMARY")) {
            this.read("KEY");
            if (this.readIf("HASH")) {
                bl2 = true;
            }
            bl3 = true;
            if (!this.isToken("ON")) {
                bl5 = this.readIfNoExists();
                string = this.readIdentifierWithSchema(null);
                schema = this.getSchema();
            }
        } else {
            if (this.readIf("UNIQUE")) {
                bl4 = true;
            }
            if (this.readIf("HASH")) {
                bl2 = true;
            }
            if (this.readIf("INDEX")) {
                if (!this.isToken("ON")) {
                    bl5 = this.readIfNoExists();
                    string = this.readIdentifierWithSchema(null);
                    schema = this.getSchema();
                }
            } else {
                throw this.getSyntaxError();
            }
        }
        this.read("ON");
        String string2 = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateIndex createIndex = new CreateIndex(this.session, this.getSchema());
        createIndex.setIfNotExists(bl5);
        createIndex.setHash(bl2);
        createIndex.setPrimaryKey(bl3);
        createIndex.setTableName(string2);
        createIndex.setUnique(bl4);
        createIndex.setIndexName(string);
        createIndex.setComment(this.readCommentIf());
        this.read("(");
        createIndex.setIndexColumns(this.parseIndexColumnList());
        return createIndex;
    }

    private boolean addRoleOrRight(GrantRevoke grantRevoke) {
        if (this.readIf("SELECT")) {
            grantRevoke.addRight(1);
            return false;
        }
        if (this.readIf("DELETE")) {
            grantRevoke.addRight(2);
            return false;
        }
        if (this.readIf("INSERT")) {
            grantRevoke.addRight(4);
            return false;
        }
        if (this.readIf("UPDATE")) {
            grantRevoke.addRight(8);
            return false;
        }
        if (this.readIf("ALL")) {
            grantRevoke.addRight(15);
            return false;
        }
        if (this.readIf("CONNECT")) {
            return false;
        }
        if (this.readIf("RESOURCE")) {
            return false;
        }
        grantRevoke.addRoleName(this.readUniqueIdentifier());
        return true;
    }

    private GrantRevoke parseGrantRevoke(int n) {
        GrantRevoke grantRevoke = new GrantRevoke(this.session);
        grantRevoke.setOperationType(n);
        boolean bl = this.addRoleOrRight(grantRevoke);
        while (this.readIf(",")) {
            boolean bl2 = this.addRoleOrRight(grantRevoke);
            if (bl2 == bl) continue;
            throw DbException.get(90072);
        }
        if (!bl && this.readIf("ON")) {
            do {
                Table table = this.readTableOrView();
                grantRevoke.addTable(table);
            } while (this.readIf(","));
        }
        if (n == 0) {
            this.read("TO");
        } else {
            this.read("FROM");
        }
        grantRevoke.setGranteeName(this.readUniqueIdentifier());
        return grantRevoke;
    }

    private Call parserCall() {
        Call call = new Call(this.session);
        this.currentPrepared = call;
        call.setExpression(this.readExpression());
        return call;
    }

    private CreateRole parseCreateRole() {
        CreateRole createRole = new CreateRole(this.session);
        createRole.setIfNotExists(this.readIfNoExists());
        createRole.setRoleName(this.readUniqueIdentifier());
        return createRole;
    }

    private CreateSchema parseCreateSchema() {
        CreateSchema createSchema = new CreateSchema(this.session);
        createSchema.setIfNotExists(this.readIfNoExists());
        createSchema.setSchemaName(this.readUniqueIdentifier());
        if (this.readIf("AUTHORIZATION")) {
            createSchema.setAuthorization(this.readUniqueIdentifier());
        } else {
            createSchema.setAuthorization(this.session.getUser().getName());
        }
        return createSchema;
    }

    private CreateSequence parseCreateSequence() {
        boolean bl = this.readIfNoExists();
        String string = this.readIdentifierWithSchema();
        CreateSequence createSequence = new CreateSequence(this.session, this.getSchema());
        createSequence.setIfNotExists(bl);
        createSequence.setSequenceName(string);
        while (true) {
            if (this.readIf("START")) {
                this.readIf("WITH");
                createSequence.setStartWith(this.readExpression());
                continue;
            }
            if (this.readIf("INCREMENT")) {
                this.readIf("BY");
                createSequence.setIncrement(this.readExpression());
                continue;
            }
            if (this.readIf("CACHE")) {
                createSequence.setCacheSize(this.readExpression());
                continue;
            }
            if (!this.readIf("BELONGS_TO_TABLE")) break;
            createSequence.setBelongsToTable(true);
        }
        return createSequence;
    }

    private boolean readIfNoExists() {
        if (this.readIf("IF")) {
            this.read("NOT");
            this.read("EXISTS");
            return true;
        }
        return false;
    }

    private CreateConstant parseCreateConstant() {
        boolean bl = this.readIfNoExists();
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.isKeyword(string)) {
            throw DbException.get(90114, string);
        }
        this.read("VALUE");
        Expression expression = this.readExpression();
        CreateConstant createConstant = new CreateConstant(this.session, schema);
        createConstant.setConstantName(string);
        createConstant.setExpression(expression);
        createConstant.setIfNotExists(bl);
        return createConstant;
    }

    private CreateAggregate parseCreateAggregate(boolean bl) {
        boolean bl2 = this.readIfNoExists();
        CreateAggregate createAggregate = new CreateAggregate(this.session);
        createAggregate.setForce(bl);
        String string = this.readUniqueIdentifier();
        if (this.isKeyword(string) || Function.getFunction(this.database, string) != null || Aggregate.getAggregateType(string) >= 0) {
            throw DbException.get(90076, string);
        }
        createAggregate.setName(string);
        createAggregate.setIfNotExists(bl2);
        this.read("FOR");
        createAggregate.setJavaClassMethod(this.readUniqueIdentifier());
        return createAggregate;
    }

    private CreateUserDataType parseCreateUserDataType() {
        boolean bl = this.readIfNoExists();
        CreateUserDataType createUserDataType = new CreateUserDataType(this.session);
        createUserDataType.setTypeName(this.readUniqueIdentifier());
        this.read("AS");
        Column column = this.parseColumnForTable("VALUE");
        if (this.readIf("CHECK")) {
            Expression expression = this.readExpression();
            column.addCheckConstraint(this.session, expression);
        }
        column.rename(null);
        createUserDataType.setColumn(column);
        createUserDataType.setIfNotExists(bl);
        return createUserDataType;
    }

    private CreateTrigger parseCreateTrigger(boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.readIfNoExists();
        String string = this.readIdentifierWithSchema(null);
        Schema schema = this.getSchema();
        if (this.readIf("INSTEAD")) {
            this.read("OF");
            bl3 = true;
            bl2 = true;
        } else if (this.readIf("BEFORE")) {
            bl2 = false;
            bl3 = true;
        } else {
            this.read("AFTER");
            bl2 = false;
            bl3 = false;
        }
        int n = 0;
        boolean bl5 = false;
        do {
            if (this.readIf("INSERT")) {
                n |= 1;
                continue;
            }
            if (this.readIf("UPDATE")) {
                n |= 2;
                continue;
            }
            if (this.readIf("DELETE")) {
                n |= 4;
                continue;
            }
            if (this.readIf("SELECT")) {
                n |= 8;
                continue;
            }
            if (this.readIf("ROLLBACK")) {
                bl5 = true;
                continue;
            }
            throw this.getSyntaxError();
        } while (this.readIf(","));
        this.read("ON");
        String string2 = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateTrigger createTrigger = new CreateTrigger(this.session, this.getSchema());
        createTrigger.setForce(bl);
        createTrigger.setTriggerName(string);
        createTrigger.setIfNotExists(bl4);
        createTrigger.setInsteadOf(bl2);
        createTrigger.setBefore(bl3);
        createTrigger.setOnRollback(bl5);
        createTrigger.setTypeMask(n);
        createTrigger.setTableName(string2);
        if (this.readIf("FOR")) {
            this.read("EACH");
            this.read("ROW");
            createTrigger.setRowBased(true);
        } else {
            createTrigger.setRowBased(false);
        }
        if (this.readIf("QUEUE")) {
            createTrigger.setQueueSize(this.getPositiveInt());
        }
        createTrigger.setNoWait(this.readIf("NOWAIT"));
        this.read("CALL");
        createTrigger.setTriggerClassName(this.readUniqueIdentifier());
        return createTrigger;
    }

    private CreateUser parseCreateUser() {
        CreateUser createUser = new CreateUser(this.session);
        createUser.setIfNotExists(this.readIfNoExists());
        createUser.setUserName(this.readUniqueIdentifier());
        createUser.setComment(this.readCommentIf());
        if (this.readIf("PASSWORD")) {
            createUser.setPassword(this.readExpression());
        } else if (this.readIf("SALT")) {
            createUser.setSalt(this.readExpression());
            this.read("HASH");
            createUser.setHash(this.readExpression());
        } else if (this.readIf("IDENTIFIED")) {
            this.read("BY");
            createUser.setPassword(ValueExpression.get(ValueString.get(this.readColumnIdentifier())));
        } else {
            throw this.getSyntaxError();
        }
        if (this.readIf("ADMIN")) {
            createUser.setAdmin(true);
        }
        return createUser;
    }

    private CreateFunctionAlias parseCreateFunctionAlias(boolean bl) {
        boolean bl2 = this.readIfNoExists();
        CreateFunctionAlias createFunctionAlias = new CreateFunctionAlias(this.session);
        createFunctionAlias.setForce(bl);
        String string = this.readUniqueIdentifier();
        if (this.isKeyword(string) || Function.getFunction(this.database, string) != null || Aggregate.getAggregateType(string) >= 0) {
            throw DbException.get(90076, string);
        }
        createFunctionAlias.setAliasName(string);
        createFunctionAlias.setIfNotExists(bl2);
        createFunctionAlias.setDeterministic(this.readIf("DETERMINISTIC"));
        if (this.readIf("AS")) {
            createFunctionAlias.setSource(this.readString());
        } else {
            this.read("FOR");
            createFunctionAlias.setJavaClassMethod(this.readUniqueIdentifier());
        }
        return createFunctionAlias;
    }

    private Query parserWith() {
        String[] stringArray;
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        this.read("(");
        ArrayList arrayList = New.arrayList();
        for (String n : stringArray = this.parseColumnList()) {
            arrayList.add(new Column(n, 13));
        }
        CreateTableData createTableData = new CreateTableData();
        createTableData.id = this.database.allocateObjectId();
        createTableData.tableName = string;
        createTableData.temporary = true;
        createTableData.persistData = true;
        createTableData.persistIndexes = false;
        createTableData.create = true;
        createTableData.session = this.session;
        Table table = schema.createTable(createTableData);
        this.session.addLocalTempTable(table);
        String string2 = StringUtils.fromCacheOrNew(this.sqlCommand.substring(this.parseIndex));
        this.read("AS");
        Query query = this.parseSelect();
        query.prepare();
        this.session.removeLocalTempTable(table);
        int n = this.database.allocateObjectId();
        TableView tableView = new TableView(schema, n, string, string2, null, stringArray, this.session, true);
        tableView.setTemporary(true);
        this.session.addLocalTempTable(tableView);
        Query query2 = this.parseSelect();
        query2.prepare();
        query2.setPrepareAlways(true);
        return query2;
    }

    private CreateView parseCreateView(boolean bl) {
        Object object;
        CreateView createView;
        boolean bl2 = this.readIfNoExists();
        String string = this.readIdentifierWithSchema();
        this.createView = createView = new CreateView(this.session, this.getSchema());
        createView.setViewName(string);
        createView.setIfNotExists(bl2);
        createView.setComment(this.readCommentIf());
        if (this.readIf("(")) {
            object = this.parseColumnList();
            createView.setColumnNames((String[])object);
        }
        object = StringUtils.fromCacheOrNew(this.sqlCommand.substring(this.parseIndex));
        this.read("AS");
        try {
            Query query = this.parseSelect();
            query.prepare();
            createView.setSelect(query);
        }
        catch (DbException dbException) {
            if (bl) {
                createView.setSelectSQL((String)object);
            }
            throw dbException;
        }
        return createView;
    }

    private TransactionCommand parseCheckpoint() {
        TransactionCommand transactionCommand = this.readIf("SYNC") ? new TransactionCommand(this.session, 8) : new TransactionCommand(this.session, 5);
        return transactionCommand;
    }

    private Prepared parseAlter() {
        if (this.readIf("TABLE")) {
            return this.parseAlterTable();
        }
        if (this.readIf("USER")) {
            return this.parseAlterUser();
        }
        if (this.readIf("INDEX")) {
            return this.parseAlterIndex();
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseAlterSequence();
        }
        if (this.readIf("VIEW")) {
            return this.parseAlterView();
        }
        throw this.getSyntaxError();
    }

    private void checkSchema(Schema schema) {
        if (schema != null && this.getSchema() != schema) {
            throw DbException.get(90080);
        }
    }

    private AlterIndexRename parseAlterIndex() {
        String string = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        AlterIndexRename alterIndexRename = new AlterIndexRename(this.session);
        alterIndexRename.setOldIndex(this.getSchema().getIndex(string));
        this.read("RENAME");
        this.read("TO");
        String string2 = this.readIdentifierWithSchema(schema.getName());
        this.checkSchema(schema);
        alterIndexRename.setNewName(string2);
        return alterIndexRename;
    }

    private AlterView parseAlterView() {
        AlterView alterView = new AlterView(this.session);
        String string = this.readIdentifierWithSchema();
        Table table = this.getSchema().findTableOrView(this.session, string);
        if (!(table instanceof TableView)) {
            throw DbException.get(90037, string);
        }
        TableView tableView = (TableView)table;
        alterView.setView(tableView);
        this.read("RECOMPILE");
        return alterView;
    }

    private AlterSequence parseAlterSequence() {
        String string = this.readIdentifierWithSchema();
        Sequence sequence = this.getSchema().getSequence(string);
        AlterSequence alterSequence = new AlterSequence(this.session, sequence.getSchema());
        alterSequence.setSequence(sequence);
        if (this.readIf("RESTART")) {
            this.read("WITH");
            alterSequence.setStartWith(this.readExpression());
        }
        if (this.readIf("INCREMENT")) {
            this.read("BY");
            alterSequence.setIncrement(this.readExpression());
        }
        return alterSequence;
    }

    private AlterUser parseAlterUser() {
        String string = this.readUniqueIdentifier();
        if (this.readIf("SET")) {
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(0);
            alterUser.setUser(this.database.getUser(string));
            if (this.readIf("PASSWORD")) {
                alterUser.setPassword(this.readExpression());
            } else if (this.readIf("SALT")) {
                alterUser.setSalt(this.readExpression());
                this.read("HASH");
                alterUser.setHash(this.readExpression());
            } else {
                throw this.getSyntaxError();
            }
            return alterUser;
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(1);
            alterUser.setUser(this.database.getUser(string));
            String string2 = this.readUniqueIdentifier();
            alterUser.setNewName(string2);
            return alterUser;
        }
        if (this.readIf("ADMIN")) {
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(2);
            User user = this.database.getUser(string);
            alterUser.setUser(user);
            if (this.readIf("TRUE")) {
                alterUser.setAdmin(true);
            } else if (this.readIf("FALSE")) {
                alterUser.setAdmin(false);
            } else {
                throw this.getSyntaxError();
            }
            return alterUser;
        }
        throw this.getSyntaxError();
    }

    private void readIfEqualOrTo() {
        if (!this.readIf("=")) {
            this.readIf("TO");
        }
    }

    private Prepared parseSet() {
        int n;
        if (this.readIf("@")) {
            Set set = new Set(this.session, 35);
            set.setString(this.readAliasIdentifier());
            this.readIfEqualOrTo();
            set.setExpression(this.readExpression());
            return set;
        }
        if (this.readIf("AUTOCOMMIT")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            int n2 = bl ? 1 : 2;
            return new TransactionCommand(this.session, n2);
        }
        if (this.readIf("MVCC")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            Set set = new Set(this.session, 31);
            set.setInt(bl ? 1 : 0);
            return set;
        }
        if (this.readIf("EXCLUSIVE")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            Set set = new Set(this.session, 33);
            set.setInt(bl ? 1 : 0);
            return set;
        }
        if (this.readIf("IGNORECASE")) {
            this.readIfEqualOrTo();
            boolean bl = this.readBooleanSetting();
            Set set = new Set(this.session, 1);
            set.setInt(bl ? 1 : 0);
            return set;
        }
        if (this.readIf("PASSWORD")) {
            this.readIfEqualOrTo();
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(0);
            alterUser.setUser(this.session.getUser());
            alterUser.setPassword(this.readExpression());
            return alterUser;
        }
        if (this.readIf("SALT")) {
            this.readIfEqualOrTo();
            AlterUser alterUser = new AlterUser(this.session);
            alterUser.setType(0);
            alterUser.setUser(this.session.getUser());
            alterUser.setSalt(this.readExpression());
            this.read("HASH");
            alterUser.setHash(this.readExpression());
            return alterUser;
        }
        if (this.readIf("MODE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 3);
            set.setString(this.readAliasIdentifier());
            return set;
        }
        if (this.readIf("COMPRESS_LOB")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 23);
            if (this.currentTokenType == 5) {
                set.setString(this.readString());
            } else {
                set.setString(this.readUniqueIdentifier());
            }
            return set;
        }
        if (this.readIf("DATABASE")) {
            this.readIfEqualOrTo();
            this.read("COLLATION");
            return this.parseSetCollation();
        }
        if (this.readIf("COLLATION")) {
            this.readIfEqualOrTo();
            return this.parseSetCollation();
        }
        if (this.readIf("CLUSTER")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 13);
            set.setString(this.readString());
            return set;
        }
        if (this.readIf("DATABASE_EVENT_LISTENER")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 15);
            set.setString(this.readString());
            return set;
        }
        if (this.readIf("ALLOW_LITERALS")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 24);
            if (this.readIf("NONE")) {
                set.setInt(0);
            } else if (this.readIf("ALL")) {
                set.setInt(2);
            } else if (this.readIf("NUMBERS")) {
                set.setInt(1);
            } else {
                set.setInt(this.getPositiveInt());
            }
            return set;
        }
        if (this.readIf("DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 7);
            if (this.readIf("MEMORY")) {
                set.setInt(1);
            } else if (this.readIf("CACHED")) {
                set.setInt(0);
            } else {
                set.setInt(this.getPositiveInt());
            }
            return set;
        }
        if (this.readIf("CREATE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("HSQLDB.DEFAULT_TABLE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("PAGE_STORE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("CACHE_TYPE")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("FILE_LOCK")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("DB_CLOSE_ON_EXIT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_SERVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("AUTO_RECONNECT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ASSERT")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("ACCESS_MODE_DATA")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("OPEN_NEW")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("RECOVER")) {
            this.readIfEqualOrTo();
            this.read();
            return new NoOperation(this.session);
        }
        if (this.readIf("SCHEMA")) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 26);
            set.setString(this.readAliasIdentifier());
            return set;
        }
        if (this.readIf("DATESTYLE")) {
            String string;
            this.readIfEqualOrTo();
            if (!this.readIf("ISO") && !this.equalsToken(string = this.readString(), "ISO")) {
                throw this.getSyntaxError();
            }
            return new NoOperation(this.session);
        }
        if (this.readIf("SEARCH_PATH") || this.readIf(SetTypes.getTypeName(28))) {
            this.readIfEqualOrTo();
            Set set = new Set(this.session, 28);
            ArrayList<String> arrayList = New.arrayList();
            arrayList.add(this.readAliasIdentifier());
            while (this.readIf(",")) {
                arrayList.add(this.readAliasIdentifier());
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            set.setStringArray(stringArray);
            return set;
        }
        if (this.isToken("LOGSIZE")) {
            this.currentToken = SetTypes.getTypeName(2);
        }
        if ((n = SetTypes.getType(this.currentToken)) < 0) {
            throw this.getSyntaxError();
        }
        this.read();
        this.readIfEqualOrTo();
        Set set = new Set(this.session, n);
        set.setExpression(this.readExpression());
        return set;
    }

    private Set parseSetCollation() {
        Set set = new Set(this.session, 12);
        String string = this.readAliasIdentifier();
        set.setString(string);
        if (this.equalsToken(string, "OFF")) {
            return set;
        }
        Collator collator = CompareMode.getCollator(string);
        if (collator == null) {
            throw this.getSyntaxError();
        }
        if (this.readIf("STRENGTH")) {
            if (this.readIf("PRIMARY")) {
                set.setInt(0);
            } else if (this.readIf("SECONDARY")) {
                set.setInt(1);
            } else if (this.readIf("TERTIARY")) {
                set.setInt(2);
            } else if (this.readIf("IDENTICAL")) {
                set.setInt(3);
            }
        } else {
            set.setInt(collator.getStrength());
        }
        return set;
    }

    private RunScriptCommand parseRunScript() {
        RunScriptCommand runScriptCommand = new RunScriptCommand(this.session);
        this.read("FROM");
        runScriptCommand.setFileNameExpr(this.readExpression());
        if (this.readIf("COMPRESSION")) {
            runScriptCommand.setCompressionAlgorithm(this.readUniqueIdentifier());
        }
        if (this.readIf("CIPHER")) {
            runScriptCommand.setCipher(this.readUniqueIdentifier());
            if (this.readIf("PASSWORD")) {
                runScriptCommand.setPassword(this.readString().toCharArray());
            }
        }
        if (this.readIf("CHARSET")) {
            runScriptCommand.setCharset(this.readString());
        }
        return runScriptCommand;
    }

    private ScriptCommand parseScript() {
        ScriptCommand scriptCommand = new ScriptCommand(this.session);
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        if (this.readIf("SIMPLE")) {
            bl5 = true;
        }
        if (this.readIf("NODATA")) {
            bl = false;
        }
        if (this.readIf("NOPASSWORDS")) {
            bl2 = false;
        }
        if (this.readIf("NOSETTINGS")) {
            bl3 = false;
        }
        if (this.readIf("DROP")) {
            bl4 = true;
        }
        if (this.readIf("BLOCKSIZE")) {
            long l = this.readLong();
            scriptCommand.setLobBlockSize(l);
        }
        scriptCommand.setData(bl);
        scriptCommand.setPasswords(bl2);
        scriptCommand.setSettings(bl3);
        scriptCommand.setDrop(bl4);
        scriptCommand.setSimple(bl5);
        if (this.readIf("TO")) {
            scriptCommand.setFileNameExpr(this.readExpression());
            if (this.readIf("COMPRESSION")) {
                scriptCommand.setCompressionAlgorithm(this.readUniqueIdentifier());
            }
            if (this.readIf("CIPHER")) {
                scriptCommand.setCipher(this.readUniqueIdentifier());
                if (this.readIf("PASSWORD")) {
                    scriptCommand.setPassword(this.readString().toCharArray());
                }
            }
        }
        return scriptCommand;
    }

    private Table readTableOrView() {
        return this.readTableOrView(this.readIdentifierWithSchema(null));
    }

    private Table readTableOrView(String string) {
        if (this.schemaName != null) {
            return this.getSchema().getTableOrView(this.session, string);
        }
        Table table = this.database.getSchema(this.session.getCurrentSchemaName()).findTableOrView(this.session, string);
        if (table != null) {
            return table;
        }
        String[] stringArray = this.session.getSchemaSearchPath();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            Schema schema = this.database.getSchema(stringArray[i]);
            table = schema.findTableOrView(this.session, string);
            if (table == null) continue;
            return table;
        }
        throw DbException.get(42102, string);
    }

    private Sequence findSequence(String string, String string2) {
        Sequence sequence = this.database.getSchema(string).findSequence(string2);
        if (sequence != null) {
            return sequence;
        }
        String[] stringArray = this.session.getSchemaSearchPath();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            Schema schema = this.database.getSchema(stringArray[i]);
            sequence = schema.findSequence(string2);
            if (sequence == null) continue;
            return sequence;
        }
        return null;
    }

    private Sequence readSequence() {
        String string = this.readIdentifierWithSchema(null);
        if (this.schemaName != null) {
            return this.getSchema().getSequence(string);
        }
        Sequence sequence = this.findSequence(this.session.getCurrentSchemaName(), string);
        if (sequence != null) {
            return sequence;
        }
        throw DbException.get(90036, string);
    }

    private Prepared parseAlterTable() {
        Table table = this.readTableOrView();
        if (this.readIf("ADD")) {
            Prepared prepared = this.parseAlterTableAddConstraintIf(table.getName(), table.getSchema());
            if (prepared != null) {
                return prepared;
            }
            return this.parseAlterTableAddColumn(table);
        }
        if (this.readIf("SET")) {
            int n;
            this.read("REFERENTIAL_INTEGRITY");
            if (this.readIf("TRUE")) {
                n = 0;
            } else {
                this.read("FALSE");
                n = 1;
            }
            AlterTableSet alterTableSet = new AlterTableSet(this.session, table.getSchema(), n);
            alterTableSet.setTableName(table.getName());
            if (this.readIf("CHECK")) {
                alterTableSet.setCheckExisting(true);
            } else if (this.readIf("NOCHECK")) {
                alterTableSet.setCheckExisting(false);
            }
            return alterTableSet;
        }
        if (this.readIf("RENAME")) {
            this.read("TO");
            String string = this.readIdentifierWithSchema(table.getSchema().getName());
            this.checkSchema(table.getSchema());
            AlterTableRename alterTableRename = new AlterTableRename(this.session, this.getSchema());
            alterTableRename.setOldTable(table);
            alterTableRename.setNewTableName(string);
            return alterTableRename;
        }
        if (this.readIf("DROP")) {
            if (this.readIf("CONSTRAINT")) {
                boolean bl = this.readIfExists(false);
                String string = this.readIdentifierWithSchema(table.getSchema().getName());
                bl = this.readIfExists(bl);
                this.checkSchema(table.getSchema());
                AlterTableDropConstraint alterTableDropConstraint = new AlterTableDropConstraint(this.session, this.getSchema(), bl);
                alterTableDropConstraint.setConstraintName(string);
                return alterTableDropConstraint;
            }
            if (this.readIf("PRIMARY")) {
                this.read("KEY");
                Index index = table.getPrimaryKey();
                DropIndex dropIndex = new DropIndex(this.session, table.getSchema());
                dropIndex.setIndexName(index.getName());
                return dropIndex;
            }
            this.readIf("COLUMN");
            AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, table.getSchema());
            alterTableAlterColumn.setType(5);
            String string = this.readColumnIdentifier();
            alterTableAlterColumn.setTable(table);
            alterTableAlterColumn.setOldColumn(table.getColumn(string));
            return alterTableAlterColumn;
        }
        if (this.readIf("ALTER")) {
            this.readIf("COLUMN");
            String string = this.readColumnIdentifier();
            Column column = table.getColumn(string);
            if (this.readIf("RENAME")) {
                this.read("TO");
                AlterTableRenameColumn alterTableRenameColumn = new AlterTableRenameColumn(this.session);
                alterTableRenameColumn.setTable(table);
                alterTableRenameColumn.setColumn(column);
                String string2 = this.readColumnIdentifier();
                alterTableRenameColumn.setNewColumnName(string2);
                return alterTableRenameColumn;
            }
            if (this.readIf("SET")) {
                if (this.readIf("DATA")) {
                    this.read("TYPE");
                    Column column2 = this.parseColumnForTable(string);
                    AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, table.getSchema());
                    alterTableAlterColumn.setTable(table);
                    alterTableAlterColumn.setType(3);
                    alterTableAlterColumn.setOldColumn(column);
                    alterTableAlterColumn.setNewColumn(column2);
                    return alterTableAlterColumn;
                }
                AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, table.getSchema());
                alterTableAlterColumn.setTable(table);
                alterTableAlterColumn.setOldColumn(column);
                if (this.readIf("NULL")) {
                    alterTableAlterColumn.setType(1);
                    return alterTableAlterColumn;
                }
                if (this.readIf("NOT")) {
                    this.read("NULL");
                    alterTableAlterColumn.setType(0);
                    return alterTableAlterColumn;
                }
                if (this.readIf("DEFAULT")) {
                    Expression expression = this.readExpression();
                    alterTableAlterColumn.setType(2);
                    alterTableAlterColumn.setDefaultExpression(expression);
                    return alterTableAlterColumn;
                }
            } else {
                if (this.readIf("RESTART")) {
                    this.readIf("WITH");
                    Expression expression = this.readExpression();
                    AlterSequence alterSequence = new AlterSequence(this.session, table.getSchema());
                    alterSequence.setColumn(column);
                    alterSequence.setStartWith(expression);
                    return alterSequence;
                }
                if (this.readIf("SELECTIVITY")) {
                    AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, table.getSchema());
                    alterTableAlterColumn.setTable(table);
                    alterTableAlterColumn.setType(6);
                    alterTableAlterColumn.setOldColumn(column);
                    alterTableAlterColumn.setSelectivity(this.readExpression());
                    return alterTableAlterColumn;
                }
                Column column3 = this.parseColumnForTable(string);
                AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, table.getSchema());
                alterTableAlterColumn.setTable(table);
                alterTableAlterColumn.setType(3);
                alterTableAlterColumn.setOldColumn(column);
                alterTableAlterColumn.setNewColumn(column3);
                return alterTableAlterColumn;
            }
        }
        throw this.getSyntaxError();
    }

    private AlterTableAlterColumn parseAlterTableAddColumn(Table table) {
        this.readIf("COLUMN");
        Schema schema = table.getSchema();
        AlterTableAlterColumn alterTableAlterColumn = new AlterTableAlterColumn(this.session, schema);
        alterTableAlterColumn.setType(4);
        alterTableAlterColumn.setTable(table);
        String string = this.readColumnIdentifier();
        Column column = this.parseColumnForTable(string);
        alterTableAlterColumn.setNewColumn(column);
        if (this.readIf("BEFORE")) {
            alterTableAlterColumn.setAddBefore(this.readColumnIdentifier());
        }
        return alterTableAlterColumn;
    }

    private int parseAction() {
        if (this.readIf("CASCADE")) {
            return 1;
        }
        if (this.readIf("RESTRICT")) {
            return 0;
        }
        if (this.readIf("NO")) {
            this.read("ACTION");
            return 0;
        }
        this.read("SET");
        if (this.readIf("NULL")) {
            return 3;
        }
        this.read("DEFAULT");
        return 2;
    }

    private Prepared parseAlterTableAddConstraintIf(String string, Schema schema) {
        AlterTableAddConstraint alterTableAddConstraint;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        if (this.readIf("CONSTRAINT")) {
            bl = this.readIfNoExists();
            string2 = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            string3 = this.readCommentIf();
        }
        if (this.readIf("PRIMARY")) {
            this.read("KEY");
            AlterTableAddConstraint alterTableAddConstraint2 = new AlterTableAddConstraint(this.session, schema, bl);
            alterTableAddConstraint2.setType(3);
            alterTableAddConstraint2.setComment(string3);
            alterTableAddConstraint2.setConstraintName(string2);
            alterTableAddConstraint2.setTableName(string);
            if (this.readIf("HASH")) {
                alterTableAddConstraint2.setPrimaryKeyHash(true);
            }
            this.read("(");
            alterTableAddConstraint2.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String string4 = this.readIdentifierWithSchema();
                alterTableAddConstraint2.setIndex(this.getSchema().findIndex(this.session, string4));
            }
            return alterTableAddConstraint2;
        }
        if (this.database.getMode().indexDefinitionInCreateTable && (this.readIf("INDEX") || this.readIf("KEY"))) {
            CreateIndex createIndex = new CreateIndex(this.session, schema);
            createIndex.setComment(string3);
            createIndex.setTableName(string);
            if (!this.readIf("(")) {
                createIndex.setIndexName(this.readUniqueIdentifier());
                this.read("(");
            }
            createIndex.setIndexColumns(this.parseIndexColumnList());
            return createIndex;
        }
        if (this.readIf("CHECK")) {
            alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, bl);
            alterTableAddConstraint.setType(0);
            alterTableAddConstraint.setCheckExpression(this.readExpression());
        } else if (this.readIf("UNIQUE")) {
            this.readIf("KEY");
            this.readIf("INDEX");
            alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, bl);
            alterTableAddConstraint.setType(1);
            if (!this.readIf("(")) {
                string2 = this.readUniqueIdentifier();
                this.read("(");
            }
            alterTableAddConstraint.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String string5 = this.readIdentifierWithSchema();
                alterTableAddConstraint.setIndex(this.getSchema().findIndex(this.session, string5));
            }
        } else if (this.readIf("FOREIGN")) {
            alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, bl);
            alterTableAddConstraint.setType(2);
            this.read("KEY");
            this.read("(");
            alterTableAddConstraint.setIndexColumns(this.parseIndexColumnList());
            if (this.readIf("INDEX")) {
                String string6 = this.readIdentifierWithSchema();
                alterTableAddConstraint.setIndex(schema.findIndex(this.session, string6));
            }
            this.read("REFERENCES");
            this.parseReferences(alterTableAddConstraint, schema, string);
        } else {
            if (string2 != null) {
                throw this.getSyntaxError();
            }
            return null;
        }
        if (this.readIf("NOCHECK")) {
            alterTableAddConstraint.setCheckExisting(false);
        } else {
            this.readIf("CHECK");
            alterTableAddConstraint.setCheckExisting(true);
        }
        alterTableAddConstraint.setTableName(string);
        alterTableAddConstraint.setConstraintName(string2);
        alterTableAddConstraint.setComment(string3);
        return alterTableAddConstraint;
    }

    private void parseReferences(AlterTableAddConstraint alterTableAddConstraint, Schema schema, String string) {
        String string2;
        if (this.readIf("(")) {
            alterTableAddConstraint.setRefTableName(schema, string);
            alterTableAddConstraint.setRefIndexColumns(this.parseIndexColumnList());
        } else {
            string2 = this.readIdentifierWithSchema(schema.getName());
            alterTableAddConstraint.setRefTableName(this.getSchema(), string2);
            if (this.readIf("(")) {
                alterTableAddConstraint.setRefIndexColumns(this.parseIndexColumnList());
            }
        }
        if (this.readIf("INDEX")) {
            string2 = this.readIdentifierWithSchema();
            alterTableAddConstraint.setRefIndex(this.getSchema().findIndex(this.session, string2));
        }
        while (this.readIf("ON")) {
            if (this.readIf("DELETE")) {
                alterTableAddConstraint.setDeleteAction(this.parseAction());
                continue;
            }
            this.read("UPDATE");
            alterTableAddConstraint.setUpdateAction(this.parseAction());
        }
        if (this.readIf("NOT")) {
            this.read("DEFERRABLE");
        } else {
            this.readIf("DEFERRABLE");
        }
    }

    private CreateLinkedTable parseCreateLinkedTable(boolean bl, boolean bl2, boolean bl3) {
        this.read("TABLE");
        boolean bl4 = this.readIfNoExists();
        String string = this.readIdentifierWithSchema();
        CreateLinkedTable createLinkedTable = new CreateLinkedTable(this.session, this.getSchema());
        createLinkedTable.setTemporary(bl);
        createLinkedTable.setGlobalTemporary(bl2);
        createLinkedTable.setForce(bl3);
        createLinkedTable.setIfNotExists(bl4);
        createLinkedTable.setTableName(string);
        createLinkedTable.setComment(this.readCommentIf());
        this.read("(");
        createLinkedTable.setDriver(this.readString());
        this.read(",");
        createLinkedTable.setUrl(this.readString());
        this.read(",");
        createLinkedTable.setUser(this.readString());
        this.read(",");
        createLinkedTable.setPassword(this.readString());
        this.read(",");
        String string2 = this.readString();
        if (this.readIf(",")) {
            createLinkedTable.setOriginalSchema(string2);
            string2 = this.readString();
        }
        createLinkedTable.setOriginalTable(string2);
        this.read(")");
        if (this.readIf("EMIT")) {
            this.read("UPDATES");
            createLinkedTable.setEmitUpdates(true);
        } else if (this.readIf("READONLY")) {
            createLinkedTable.setReadOnly(true);
        }
        return createLinkedTable;
    }

    private CreateTable parseCreateTable(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.readIfNoExists();
        String string = this.readIdentifierWithSchema();
        if (bl && bl2 && this.equalsToken("SESSION", this.schemaName)) {
            this.schemaName = this.session.getCurrentSchemaName();
            bl2 = false;
        }
        Schema schema = this.getSchema();
        CreateTable createTable = new CreateTable(this.session, schema);
        createTable.setPersistIndexes(bl3);
        createTable.setTemporary(bl);
        createTable.setGlobalTemporary(bl2);
        createTable.setIfNotExists(bl4);
        createTable.setTableName(string);
        createTable.setComment(this.readCommentIf());
        if (this.readIf("AS")) {
            if (this.readIf("SORTED")) {
                createTable.setSortedInsertMode(true);
            }
            createTable.setQuery(this.parseSelect());
        } else {
            this.read("(");
            if (!this.readIf(")")) {
                do {
                    IndexColumn[] indexColumnArray;
                    AlterTableAddConstraint alterTableAddConstraint;
                    IndexColumn[] indexColumnArray2;
                    Prepared prepared;
                    if ((prepared = this.parseAlterTableAddConstraintIf(string, schema)) != null) {
                        createTable.addConstraintCommand(prepared);
                        continue;
                    }
                    String string2 = this.readColumnIdentifier();
                    Column column = this.parseColumnForTable(string2);
                    if (column.isAutoIncrement() && column.isPrimaryKey()) {
                        column.setPrimaryKey(false);
                        indexColumnArray2 = new IndexColumn[]{new IndexColumn()};
                        indexColumnArray2[0].columnName = column.getName();
                        alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, false);
                        alterTableAddConstraint.setType(3);
                        alterTableAddConstraint.setTableName(string);
                        alterTableAddConstraint.setIndexColumns(indexColumnArray2);
                        createTable.addConstraintCommand(alterTableAddConstraint);
                    }
                    createTable.addColumn(column);
                    indexColumnArray2 = null;
                    if (this.readIf("CONSTRAINT")) {
                        indexColumnArray2 = this.readColumnIdentifier();
                    }
                    if (this.readIf("PRIMARY")) {
                        this.read("KEY");
                        boolean bl5 = this.readIf("HASH");
                        indexColumnArray = new IndexColumn[]{new IndexColumn()};
                        indexColumnArray[0].columnName = column.getName();
                        AlterTableAddConstraint alterTableAddConstraint2 = new AlterTableAddConstraint(this.session, schema, false);
                        alterTableAddConstraint2.setPrimaryKeyHash(bl5);
                        alterTableAddConstraint2.setType(3);
                        alterTableAddConstraint2.setTableName(string);
                        alterTableAddConstraint2.setIndexColumns(indexColumnArray);
                        createTable.addConstraintCommand(alterTableAddConstraint2);
                        if (this.readIf("AUTO_INCREMENT")) {
                            this.parseAutoIncrement(column);
                        }
                    } else if (this.readIf("UNIQUE")) {
                        alterTableAddConstraint = new AlterTableAddConstraint(this.session, schema, false);
                        alterTableAddConstraint.setConstraintName((String)indexColumnArray2);
                        alterTableAddConstraint.setType(1);
                        indexColumnArray = new IndexColumn[]{new IndexColumn()};
                        indexColumnArray[0].columnName = string2;
                        alterTableAddConstraint.setIndexColumns(indexColumnArray);
                        alterTableAddConstraint.setTableName(string);
                        createTable.addConstraintCommand(alterTableAddConstraint);
                    }
                    if (this.readIf("NOT")) {
                        this.read("NULL");
                        column.setNullable(false);
                    } else {
                        this.readIf("NULL");
                    }
                    if (this.readIf("CHECK")) {
                        Expression expression = this.readExpression();
                        column.addCheckConstraint(this.session, expression);
                    }
                    if (!this.readIf("REFERENCES")) continue;
                    AlterTableAddConstraint alterTableAddConstraint3 = new AlterTableAddConstraint(this.session, schema, false);
                    alterTableAddConstraint3.setConstraintName((String)indexColumnArray2);
                    alterTableAddConstraint3.setType(2);
                    indexColumnArray = new IndexColumn[]{new IndexColumn()};
                    indexColumnArray[0].columnName = string2;
                    alterTableAddConstraint3.setIndexColumns(indexColumnArray);
                    alterTableAddConstraint3.setTableName(string);
                    this.parseReferences(alterTableAddConstraint3, schema, string);
                    createTable.addConstraintCommand(alterTableAddConstraint3);
                } while (this.readIfMore());
            }
            if (this.readIf("AS")) {
                if (this.readIf("SORTED")) {
                    createTable.setSortedInsertMode(true);
                }
                createTable.setQuery(this.parseSelect());
            }
        }
        if (this.readIf("ENGINE")) {
            createTable.setTableEngine(this.readUniqueIdentifier());
        }
        if (bl) {
            if (this.readIf("ON")) {
                this.read("COMMIT");
                if (this.readIf("DROP")) {
                    createTable.setOnCommitDrop();
                } else if (this.readIf("DELETE")) {
                    this.read("ROWS");
                    createTable.setOnCommitTruncate();
                }
            } else if (this.readIf("NOT")) {
                if (this.readIf("PERSISTENT")) {
                    createTable.setPersistData(false);
                } else {
                    this.read("LOGGED");
                }
            }
        } else if (!bl3 && this.readIf("NOT")) {
            this.read("PERSISTENT");
            createTable.setPersistData(false);
        }
        if (this.readIf("HIDDEN")) {
            createTable.setHidden(true);
        }
        return createTable;
    }

    private int getCompareType(int n) {
        switch (n) {
            case 6: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 4;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 5;
            }
        }
        return -1;
    }

    public static String quoteIdentifier(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = string.charAt(0);
        if (!Character.isLetter(c) && c != '_' || Character.isLowerCase(c)) {
            return StringUtils.quoteIdentifier(string);
        }
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if ((Character.isLetterOrDigit(c) || c == '_') && !Character.isLowerCase(c)) continue;
            return StringUtils.quoteIdentifier(string);
        }
        if (Parser.isKeyword(string, true)) {
            return StringUtils.quoteIdentifier(string);
        }
        return string;
    }

    public void setRightsChecked(boolean bl) {
        this.rightsChecked = bl;
    }

    public Expression parseExpression(String string) {
        this.parameters = New.arrayList();
        this.initialize(string);
        this.read();
        return this.readExpression();
    }
}

