/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable;

import com.gs.collections.api.bag.Bag;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.factory.bag.ImmutableBagFactory;
import com.gs.collections.impl.bag.immutable.ImmutableArrayBag;
import com.gs.collections.impl.bag.immutable.ImmutableEmptyBag;
import com.gs.collections.impl.bag.immutable.ImmutableHashBag;
import com.gs.collections.impl.bag.immutable.ImmutableSingletonBag;
import com.gs.collections.impl.utility.Iterate;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class ImmutableBagFactoryImpl
implements ImmutableBagFactory {
    public <T> ImmutableBag<T> of() {
        return this.with();
    }

    public <T> ImmutableBag<T> with() {
        return ImmutableEmptyBag.INSTANCE;
    }

    public <T> ImmutableBag<T> of(T element) {
        return this.with(element);
    }

    public <T> ImmutableBag<T> with(T element) {
        return new ImmutableSingletonBag<T>(element);
    }

    public <T> ImmutableBag<T> of(T ... elements) {
        return this.with(elements);
    }

    public <T> ImmutableBag<T> with(T ... elements) {
        if (elements == null || elements.length == 0) {
            return this.of();
        }
        if (elements.length == 1) {
            return this.of(elements[0]);
        }
        if (elements.length < 20) {
            return ImmutableArrayBag.newBagWith(elements);
        }
        return ImmutableHashBag.newBagWith(elements);
    }

    public <T> ImmutableBag<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    public <T> ImmutableBag<T> withAll(Iterable<? extends T> items) {
        if (items instanceof ImmutableBag) {
            return (ImmutableBag)items;
        }
        if (items instanceof Bag) {
            Bag bag = (Bag)items;
            if (bag.isEmpty()) {
                return this.with();
            }
            if (bag.size() == 1) {
                return this.with((T)bag.getFirst());
            }
            if (bag.sizeDistinct() < 20) {
                return ImmutableArrayBag.copyFrom(bag);
            }
            return new ImmutableHashBag(bag);
        }
        return this.of(Iterate.toArray(items));
    }
}

