/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.extras.export.itext;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.datatables.core.export.DatatablesExport;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlRow;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.OutputStream;

public class PdfExport
implements DatatablesExport {
    private HtmlTable table;
    private ExportConf exportConf;

    public void initExport(HtmlTable table) {
        this.table = table;
        this.exportConf = (ExportConf)table.getTableConfiguration().getExportConfigurations().get("pdf");
    }

    public void processExport(OutputStream output) {
        Document document = null;
        document = this.exportConf.getOrientation() != null && this.exportConf.getOrientation().equals((Object)ExportConf.Orientation.LANDSCAPE) ? new Document(PageSize.LETTER.rotate()) : new Document();
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)output);
            pdfWriter.setViewerPreferences(1);
            document.open();
            this.addTitle(document);
            this.addTable(document);
        }
        catch (DocumentException e) {
            StringBuilder sb = new StringBuilder("Something went wrong during the PDF generation of the table '");
            sb.append(this.table.getOriginalId());
            sb.append("' and with the following export configuration: ");
            sb.append(this.exportConf.toString());
            throw new DandelionException(sb.toString(), (Throwable)e);
        }
        finally {
            document.close();
        }
    }

    private void addTitle(Document document) throws DocumentException {
        Paragraph title = new Paragraph(this.exportConf.getFileName());
        title.add((Element)new Paragraph(" "));
        title.setAlignment(1);
        document.add((Element)title);
    }

    private void addTable(Document document) throws DocumentException {
        PdfPCell cell = null;
        int columnCount = this.table.getLastHeaderRow().getColumns(new String[]{"all", "pdf"}).size();
        if (columnCount != 0) {
            PdfPTable pdfTable = new PdfPTable(columnCount);
            pdfTable.setWidthPercentage(100.0f);
            if (this.exportConf != null && this.exportConf.getIncludeHeader().booleanValue()) {
                for (HtmlRow htmlRow : this.table.getHeadRows()) {
                    for (HtmlColumn column : htmlRow.getColumns(new String[]{"all", "pdf"})) {
                        cell = new PdfPCell();
                        cell.setPhrase(new Phrase(column.getContent().toString()));
                        pdfTable.addCell(cell);
                    }
                }
            }
            for (HtmlRow htmlRow : this.table.getBodyRows()) {
                for (HtmlColumn column : htmlRow.getColumns(new String[]{"all", "pdf"})) {
                    cell = new PdfPCell();
                    cell.setPhrase(new Phrase(column.getContent().toString()));
                    pdfTable.addCell(cell);
                }
            }
            document.add((Element)pdfTable);
        }
    }
}

