/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.web.handler.debug;

import com.github.dandelion.core.option.Option;
import com.github.dandelion.core.util.ResourceUtils;
import com.github.dandelion.core.web.handler.HandlerContext;
import com.github.dandelion.core.web.handler.debug.AbstractDebugPage;
import com.github.dandelion.datatables.core.config.DatatableConfigurator;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.TableConfigurationFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DatatableOptionsDebugPage
extends AbstractDebugPage {
    private static final String PAGE_ID = "datatable-options";
    private static final String PAGE_NAME = "Current options";
    private static final String PAGE_LOCATION = "META-INF/resources/ddl-dt-debugger/html/datatable-options.html";

    public String getId() {
        return PAGE_ID;
    }

    public String getName() {
        return PAGE_NAME;
    }

    public String getTemplate(HandlerContext context) throws IOException {
        return ResourceUtils.getContentFromInputStream((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(PAGE_LOCATION));
    }

    protected Map<String, Object> getPageContext() {
        List htmlTables = (List)this.context.getRequest().getAttribute("ddl-dt-tables");
        ArrayList tablesJson = new ArrayList();
        if (!htmlTables.isEmpty()) {
            int index = 0;
            for (HtmlTable htmlTable : htmlTables) {
                HashMap<String, Object> tableJson = new HashMap<String, Object>();
                tableJson.put("tableId", "#" + htmlTable.getOriginalId());
                tableJson.put("groupName", htmlTable.getTableConfiguration().getOptionGroupName());
                tableJson.put("options", this.getTableOptions(htmlTable, this.context.getRequest()));
                ArrayList<Map> extensions = new ArrayList<Map>();
                if (htmlTable.getTableConfiguration().getInternalExtensions() != null) {
                    for (Extension ext : htmlTable.getTableConfiguration().getInternalExtensions()) {
                        extensions.add(new AbstractDebugPage.MapBuilder((AbstractDebugPage)this).entry((Object)"name", (Object)ext.getExtensionName().toLowerCase()).entry((Object)"class", (Object)ext.getClass().getName()).create());
                    }
                    tableJson.put("extensions", extensions);
                }
                tableJson.put("active", index == 0 ? "active" : "");
                tablesJson.add(tableJson);
                ++index;
            }
        }
        HashMap<String, Object> pageContext = new HashMap<String, Object>();
        pageContext.put("tables", tablesJson);
        return pageContext;
    }

    private List<Map<String, Object>> getTableOptions(HtmlTable htmlTable, HttpServletRequest request) {
        Map<Locale, Map<String, Map<Option<?>, Object>>> store = TableConfigurationFactory.getConfigurationStore();
        Locale locale = null;
        locale = request != null ? DatatableConfigurator.getLocaleResolver().resolveLocale(request) : Locale.getDefault();
        ArrayList<Map<String, Object>> tableOptions = new ArrayList<Map<String, Object>>();
        for (Map.Entry<Option<?>, Object> entry : store.get(locale).get(htmlTable.getTableConfiguration().getOptionGroupName()).entrySet()) {
            tableOptions.add(new AbstractDebugPage.MapBuilder((AbstractDebugPage)this).entry((Object)"name", (Object)entry.getKey().getName()).entry((Object)"value", entry.getValue() instanceof Extension ? entry.getValue().getClass().getCanonicalName() : entry.getValue()).entry((Object)"precedence", (Object)entry.getKey().getPrecedence()).create());
        }
        return tableOptions;
    }
}

