/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.web.handler.debug;

import com.github.dandelion.core.option.Option;
import com.github.dandelion.core.util.ResourceUtils;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.core.web.handler.HandlerContext;
import com.github.dandelion.core.web.handler.debug.AbstractDebugPage;
import com.github.dandelion.datatables.core.config.DatatableConfigurator;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import com.github.dandelion.datatables.core.option.TableConfigurationFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DatatableOptionGroupsDebugPage
extends AbstractDebugPage {
    private static final String PAGE_ID = "datatable-option-groups";
    private static final String PAGE_NAME = "Option groups";
    private static final String PAGE_LOCATION = "META-INF/resources/ddl-dt-debugger/html/datatable-option-groups.html";

    public String getId() {
        return PAGE_ID;
    }

    public String getName() {
        return PAGE_NAME;
    }

    public String getTemplate(HandlerContext context) throws IOException {
        return ResourceUtils.getContentFromInputStream((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(PAGE_LOCATION));
    }

    protected Map<String, Object> getPageContext() {
        Map<Locale, Map<String, Map<Option<?>, Object>>> store = TableConfigurationFactory.getConfigurationStore();
        Locale currentLocale = DatatableConfigurator.getLocaleResolver().resolveLocale(this.context.getRequest());
        ArrayList groupsJson = new ArrayList();
        int index = 0;
        for (Map.Entry<String, Map<Option<?>, Object>> entry : store.get(currentLocale).entrySet()) {
            HashMap<String, Object> groupJson = new HashMap<String, Object>();
            groupJson.put("groupName", StringUtils.capitalize((String)entry.getKey()));
            groupJson.put("options", this.getGroupOptions(entry.getValue()));
            groupJson.put("active", index == 0 ? "active" : "");
            groupsJson.add(groupJson);
            ++index;
        }
        HashMap<String, Object> pageContext = new HashMap<String, Object>();
        pageContext.put("groups", groupsJson);
        pageContext.put("page-header", PAGE_NAME);
        return pageContext;
    }

    private List<Map<String, Object>> getGroupOptions(Map<Option<?>, Object> optionsMap) {
        ArrayList<Map<String, Object>> options = new ArrayList<Map<String, Object>>();
        options.add(this.option(DatatableOptions.CSS_STYLE, optionsMap));
        options.add(this.option(DatatableOptions.CSS_CLASS, optionsMap));
        options.add(this.option(DatatableOptions.CSS_STRIPECLASSES, optionsMap));
        options.add(this.option(DatatableOptions.CSS_THEME, optionsMap));
        options.add(this.option(DatatableOptions.CSS_THEMEOPTION, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_AUTOWIDTH, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_DISPLAYLENGTH, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_DOM, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_FILTERABLE, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_FILTER_CLEAR_SELECTOR, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_FILTER_DELAY, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_FILTER_PLACEHOLDER, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_FILTER_SELECTOR, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_INFO, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_JQUERYUI, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_LENGTHCHANGE, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_LENGTHMENU, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_PAGEABLE, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_PAGINGTYPE, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_PROCESSING, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_SCROLLCOLLAPSE, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_SCROLLX, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_SCROLLXINNER, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_SCROLLY, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_SORTABLE, optionsMap));
        options.add(this.option(DatatableOptions.FEATURE_STATESAVE, optionsMap));
        options.add(this.option(DatatableOptions.AJAX_SOURCE, optionsMap));
        options.add(this.option(DatatableOptions.AJAX_SERVERSIDE, optionsMap));
        options.add(this.option(DatatableOptions.AJAX_DEFERRENDER, optionsMap));
        options.add(this.option(DatatableOptions.AJAX_PIPELINING, optionsMap));
        options.add(this.option(DatatableOptions.AJAX_PIPESIZE, optionsMap));
        options.add(this.option(DatatableOptions.AJAX_RELOAD_FUNCTION, optionsMap));
        options.add(this.option(DatatableOptions.AJAX_RELOAD_SELECTOR, optionsMap));
        options.add(this.option(DatatableOptions.AJAX_PARAMS, optionsMap));
        options.add(this.option(DatatableOptions.PLUGIN_FIXEDPOSITION, optionsMap));
        options.add(this.option(DatatableOptions.PLUGIN_FIXEDOFFSETTOP, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_ENABLED_FORMATS, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_CONTAINER_CLASS, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_CONTAINER_STYLE, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_CSV_CLASS, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_CSV_LABEL, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_CSV_FILENAME, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_CSV_MIMETYPE, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XML_CLASS, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XML_LABEL, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XML_FILENAME, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XML_MIMETYPE, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_PDF_CLASS, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_PDF_LABEL, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_PDF_FILENAME, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_PDF_MIMETYPE, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XLS_CLASS, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XLS_LABEL, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XLS_FILENAME, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XLS_MIMETYPE, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XLSX_CLASS, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XLSX_LABEL, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XLSX_FILENAME, optionsMap));
        options.add(this.option(DatatableOptions.EXPORT_XLSX_MIMETYPE, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_ARIA_SORTASC, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_ARIA_SORTDESC, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_EMPTYTABLE, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_INFO, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_INFOEMPTY, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_INFOFILTERED, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_INFOPOSTFIX, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_LENGTHMENU, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_LOADINGRECORDS, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_PAGINATE_FIRST, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_PAGINATE_LAST, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_PAGINATE_NEXT, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_PAGINATE_PREVIOUS, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_PROCESSING, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_SEARCH, optionsMap));
        options.add(this.option(DatatableOptions.I18N_MSG_ZERORECORDS, optionsMap));
        return options;
    }

    private Map<String, Object> option(Option<?> option, Map<Option<?>, Object> optionsMap) {
        HashMap<String, Object> optionMap = new HashMap<String, Object>();
        optionMap.put("name", option.getName());
        if (optionsMap.containsKey(option)) {
            if (optionsMap.get(option) instanceof Extension) {
                optionMap.put("value", optionsMap.get(option).getClass().getCanonicalName());
            } else {
                optionMap.put("value", optionsMap.get(option));
            }
        } else {
            optionMap.put("value", "");
        }
        return optionMap;
    }
}

