/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.option.processor.feature;

import com.github.dandelion.core.option.AbstractOptionProcessor;
import com.github.dandelion.core.option.OptionProcessingContext;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.extension.feature.PagingType;
import com.github.dandelion.datatables.core.option.TableConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturePagingTypeProcessor
extends AbstractOptionProcessor {
    private static Logger logger = LoggerFactory.getLogger(FeaturePagingTypeProcessor.class);

    protected Object getProcessedValue(OptionProcessingContext context) {
        TableConfiguration tc = (TableConfiguration)context.getRequest().getAttribute(TableConfiguration.class.getCanonicalName());
        String valueAsString = context.getValueAsString();
        PagingType retval = null;
        if (StringUtils.isNotBlank((String)valueAsString)) {
            try {
                retval = PagingType.valueOf(valueAsString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.info("The pagination type '{}' doesn't match any of the predefined pagination types. Make sure an extension is registered for this pagination type.", (Object)valueAsString);
            }
            if (retval != null) {
                switch (retval) {
                    case INPUT: {
                        tc.registerExtension("pagingTypeInput");
                        break;
                    }
                    case LISTBOX: {
                        tc.registerExtension("pagingTypeListbox");
                        break;
                    }
                    case SCROLLING: {
                        tc.registerExtension("pagingTypeScrolling");
                        break;
                    }
                    case EXTSTYLE: {
                        tc.registerExtension("paginationTypeExtJS");
                        break;
                    }
                    case BOOTSTRAP_SIMPLE: {
                        tc.registerExtension("pagingTypeBootstrap");
                        break;
                    }
                    case BOOTSTRAP_FULL: {
                        tc.registerExtension("pagingTypeBootstrapFull");
                        break;
                    }
                    case BOOTSTRAP_FULL_NUMBERS: {
                        tc.registerExtension("pagingTypeBootstrapFullNumbers");
                        break;
                    }
                }
            }
        }
        return retval;
    }
}

