/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.option.processor.export;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.option.OptionProcessingContext;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.option.processor.export.AbstractExportOptionProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportFileNameProcessor
extends AbstractExportOptionProcessor {
    private static Logger logger = LoggerFactory.getLogger(ExportFileNameProcessor.class);

    protected Object getProcessedValue(OptionProcessingContext context) {
        String valueAsString = context.getValueAsString();
        if (StringUtils.isNotBlank((String)valueAsString)) {
            String exportFormat = this.getExportFormat(context);
            if (StringUtils.isNotBlank((String)exportFormat)) {
                logger.debug("Export format found: \"{}\"", (Object)exportFormat);
                ExportConf exportConf = this.getExportConf(exportFormat, context);
                exportConf.setFileName(valueAsString);
            } else {
                throw new DandelionException("Format " + exportFormat + " unknown");
            }
        }
        return valueAsString;
    }
}

