/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.option.processor.export;

import com.github.dandelion.core.option.AbstractOptionProcessor;
import com.github.dandelion.core.option.OptionProcessingContext;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.core.util.UrlUtils;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.option.TableConfiguration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportEnabledFormatProcessor
extends AbstractOptionProcessor {
    protected Object getProcessedValue(OptionProcessingContext context) {
        TableConfiguration tableConfiguration = (TableConfiguration)context.getRequest().getAttribute(TableConfiguration.class.getCanonicalName());
        String valueAsString = context.getValueAsString();
        if (StringUtils.isNotBlank((String)valueAsString)) {
            String[] enabledFormats;
            for (String enabledFormat : enabledFormats = valueAsString.split(",")) {
                enabledFormat = enabledFormat.toLowerCase().trim();
                ExportConf exportConf = null;
                if (tableConfiguration.getExportConfigurations().containsKey(enabledFormat)) continue;
                StringBuilder exportUrl = UrlUtils.getCurrentUri((HttpServletRequest)tableConfiguration.getRequest());
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtt", (Object)"f");
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtf", (Object)enabledFormat);
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dti", (Object)tableConfiguration.getTableId());
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtp", (Object)"y");
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dandelionAssetFilterState", (Object)false);
                exportConf = new ExportConf(enabledFormat, UrlUtils.getProcessedUrl((StringBuilder)exportUrl, (HttpServletRequest)tableConfiguration.getRequest(), (HttpServletResponse)tableConfiguration.getResponse()));
                tableConfiguration.getExportConfigurations().put(enabledFormat, exportConf);
            }
            tableConfiguration.registerExtension("export");
        }
        return valueAsString;
    }
}

