/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.option.processor.export;

import com.github.dandelion.core.option.AbstractOptionProcessor;
import com.github.dandelion.core.option.Option;
import com.github.dandelion.core.option.OptionProcessingContext;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.option.TableConfiguration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractExportOptionProcessor
extends AbstractOptionProcessor {
    public static final String REGEX_EXPORT_FORMAT = "export\\.(.*?)\\.";
    protected static final Pattern PATTERN_EXPORT_FORMAT = Pattern.compile("export\\.(.*?)\\.", 2);

    protected String getExportFormat(OptionProcessingContext context) {
        String exportFormat = null;
        Matcher m = PATTERN_EXPORT_FORMAT.matcher(((Option)context.getOptionEntry().getKey()).getName());
        if (m.find()) {
            exportFormat = m.group(1);
        }
        return exportFormat;
    }

    protected ExportConf getExportConf(String exportFormat, OptionProcessingContext context) {
        TableConfiguration tc = (TableConfiguration)context.getRequest().getAttribute(TableConfiguration.class.getCanonicalName());
        ExportConf exportConf = null;
        if (tc.getExportConfigurations().containsKey(exportFormat)) {
            exportConf = tc.getExportConfigurations().get(exportFormat);
        } else {
            exportConf = new ExportConf(exportFormat);
            tc.getExportConfigurations().put(exportFormat, exportConf);
        }
        return exportConf;
    }
}

