/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.option.processor.css;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.option.AbstractOptionProcessor;
import com.github.dandelion.core.option.OptionProcessingContext;
import com.github.dandelion.core.util.EnumUtils;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.extension.theme.Theme;

public class CssThemeProcessor
extends AbstractOptionProcessor {
    protected Object getProcessedValue(OptionProcessingContext context) {
        AbstractExtension retval = null;
        String valueAsString = context.getValueAsString();
        if (StringUtils.isNotBlank((String)valueAsString)) {
            try {
                retval = Theme.valueOf(valueAsString.toUpperCase()).getInstance();
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                sb.append(valueAsString);
                sb.append("' is not a valid theme name. Possible values are: ");
                sb.append(EnumUtils.printPossibleValuesOf(Theme.class));
                throw new DandelionException(sb.toString(), (Throwable)e);
            }
        }
        return retval;
    }
}

