/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.option.processor.column;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.option.AbstractOptionProcessor;
import com.github.dandelion.core.option.OptionProcessingContext;
import com.github.dandelion.core.util.EnumUtils;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.option.Direction;
import java.util.ArrayList;

public class SortDirectionProcessor
extends AbstractOptionProcessor {
    protected Object getProcessedValue(OptionProcessingContext context) {
        String valueAsString = context.getValueAsString();
        if (StringUtils.isNotBlank((String)valueAsString)) {
            String[] sortDirectionArray;
            ArrayList<Direction> sortDirections = new ArrayList<Direction>();
            for (String direction : sortDirectionArray = valueAsString.split(",")) {
                try {
                    sortDirections.add(Direction.valueOf(direction.toUpperCase().trim()));
                }
                catch (IllegalArgumentException e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("'");
                    sb.append(valueAsString);
                    sb.append("' is not a valid sort direction. Possible values are: ");
                    sb.append(EnumUtils.printPossibleValuesOf(Direction.class));
                    throw new DandelionException(sb.toString(), (Throwable)e);
                }
            }
            return sortDirections;
        }
        return null;
    }
}

