/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.option.processor.column;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.option.AbstractOptionProcessor;
import com.github.dandelion.core.option.OptionProcessingContext;
import com.github.dandelion.core.util.EnumUtils;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.generator.YadcfConfigGenerator;

public class FilterTypeProcessor
extends AbstractOptionProcessor {
    protected Object getProcessedValue(OptionProcessingContext context) {
        String valueAsString = context.getValueAsString();
        if (StringUtils.isNotBlank((String)valueAsString)) {
            YadcfConfigGenerator.FilterType filterType = null;
            try {
                filterType = YadcfConfigGenerator.FilterType.valueOf(valueAsString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder("\"");
                sb.append(valueAsString);
                sb.append("\" is not a valid filter type. Possible values are: ");
                sb.append(EnumUtils.printPossibleValuesOf(YadcfConfigGenerator.FilterType.class));
                throw new DandelionException(sb.toString(), (Throwable)e);
            }
            return filterType;
        }
        return null;
    }
}

