/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.option;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.i18n.MessageResolver;
import com.github.dandelion.core.option.Option;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.config.ConfigLoader;
import com.github.dandelion.datatables.core.config.DatatableConfigurator;
import com.github.dandelion.datatables.core.option.TableConfiguration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableConfigurationFactory {
    private static Logger LOGGER = LoggerFactory.getLogger(TableConfigurationFactory.class);
    private static final Map<Locale, Map<String, Map<Option<?>, Object>>> OPTIONS_BY_GROUP_BY_LOCALE = new ConcurrentHashMap();

    public static TableConfiguration newInstance(String tableId, HttpServletRequest request) {
        return TableConfigurationFactory.newInstance(tableId, request, "global");
    }

    public static synchronized TableConfiguration newInstance(String tableId, HttpServletRequest request, String groupName) {
        String group = StringUtils.isBlank((String)groupName) ? "global" : groupName;
        Locale locale = null;
        locale = request != null ? DatatableConfigurator.getLocaleResolver().resolveLocale(request) : Locale.getDefault();
        Context context = (Context)request.getAttribute("dandelionContext");
        if (context == null) {
            LOGGER.warn("The Dandelion context doesn't seem to be available. Did you forget to declare the DandelionFilter in your web.xml file?");
        }
        if (!OPTIONS_BY_GROUP_BY_LOCALE.containsKey(locale)) {
            TableConfigurationFactory.resolveGroupsForLocale(locale, request);
        }
        if (!OPTIONS_BY_GROUP_BY_LOCALE.get(locale).containsKey(group)) {
            StringBuilder msg = new StringBuilder("The group '");
            msg.append(group);
            msg.append("' doesn't exist in your configuration files. Either create it or choose an existing one among ");
            msg.append(OPTIONS_BY_GROUP_BY_LOCALE.get(locale).keySet());
            throw new DandelionException(msg.toString());
        }
        MessageResolver messageResolver = DatatableConfigurator.getMessageResolver(request);
        return new TableConfiguration(tableId, new HashMap(OPTIONS_BY_GROUP_BY_LOCALE.get(locale).get(group)), messageResolver, request, group);
    }

    public static void resolveGroupsForLocale(Locale locale, HttpServletRequest request) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        ConfigLoader confLoader = DatatableConfigurator.getConfigLoader();
        confLoader.loadDefaultConfiguration();
        confLoader.loadUserConfiguration(locale);
        confLoader.resolveGroups(locale);
        confLoader.resolveConfigurations(map, locale, request);
        OPTIONS_BY_GROUP_BY_LOCALE.put(locale, map);
    }

    public static Map<Locale, Map<String, Map<Option<?>, Object>>> getConfigurationStore() {
        return OPTIONS_BY_GROUP_BY_LOCALE;
    }

    public static void clear() {
        OPTIONS_BY_GROUP_BY_LOCALE.clear();
    }

    private TableConfigurationFactory() {
        throw new AssertionError();
    }
}

