/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.option;

import com.github.dandelion.core.i18n.MessageResolver;
import com.github.dandelion.core.option.Option;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.extension.ExtensionLoader;
import com.github.dandelion.datatables.core.extension.feature.ExtraHtml;
import com.github.dandelion.datatables.core.extension.feature.ExtraJs;
import com.github.dandelion.datatables.core.option.Callback;
import com.github.dandelion.datatables.core.option.CallbackType;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TableConfiguration {
    private final String tableId;
    private final Map<Option<?>, Object> options;
    private final MessageResolver messageResolver;
    private final HttpServletRequest request;
    private final String optionGroupName;
    private Set<ExtraJs> extraJs;
    private List<Callback> extraCallbacks;
    private List<ExtraHtml> extraHtmls;
    private Map<String, ExportConf> exportConfigurations;
    private Boolean exporting;
    private String currentExportFormat;
    private Properties messages = new Properties();
    private Set<Extension> internalExtensions;
    private HttpServletResponse response;

    TableConfiguration(String tableId, Map<Option<?>, Object> userConf, MessageResolver messageResolver, HttpServletRequest request, String optionGroupName) {
        this.tableId = tableId;
        this.options = userConf;
        this.messageResolver = messageResolver;
        this.request = request;
        this.exportConfigurations = new LinkedHashMap<String, ExportConf>();
        this.optionGroupName = optionGroupName;
    }

    public void set(String exportFormat, ExportConf exportConf) {
        this.exportConfigurations.put(exportFormat, exportConf);
    }

    public Map<String, ExportConf> getExportConfigurations() {
        return this.exportConfigurations;
    }

    public Map<Option<?>, Object> getOptions() {
        return this.options;
    }

    public TableConfiguration registerExtension(Extension extension) {
        if (this.internalExtensions == null) {
            this.internalExtensions = new HashSet<Extension>();
        }
        this.internalExtensions.add(extension);
        return this;
    }

    public void registerExtension(String extensionName) {
        if (this.internalExtensions == null) {
            this.internalExtensions = new HashSet<Extension>();
        }
        this.internalExtensions.add(ExtensionLoader.get(extensionName));
    }

    public Set<ExtraJs> getExtraJs() {
        return this.extraJs;
    }

    public TableConfiguration addExtraJs(ExtraJs extraJs) {
        if (this.extraJs == null) {
            this.extraJs = new HashSet<ExtraJs>();
        }
        this.extraJs.add(extraJs);
        return this;
    }

    public void setExtraJs(Set<ExtraJs> extraJs) {
        this.extraJs = extraJs;
    }

    public Set<Extension> getInternalExtensions() {
        return this.internalExtensions;
    }

    public TableConfiguration setInternalExtensions(Set<Extension> extensions) {
        this.internalExtensions = extensions;
        return this;
    }

    public List<Callback> getCallbacks() {
        return this.extraCallbacks;
    }

    public void setCallbacks(List<Callback> callbacks) {
        this.extraCallbacks = callbacks;
    }

    public TableConfiguration registerCallback(Callback callback) {
        if (this.extraCallbacks == null) {
            this.extraCallbacks = new ArrayList<Callback>();
        }
        this.extraCallbacks.add(callback);
        return this;
    }

    public Boolean hasCallback(CallbackType callbackType) {
        if (this.extraCallbacks != null) {
            for (Callback callback : this.extraCallbacks) {
                if (!callback.getType().equals((Object)callbackType)) continue;
                return true;
            }
        }
        return false;
    }

    public Callback getCallback(CallbackType callbackType) {
        for (Callback callback : this.extraCallbacks) {
            if (!callback.getType().equals((Object)callbackType)) continue;
            return callback;
        }
        return null;
    }

    public Boolean getExporting() {
        return this.exporting;
    }

    public void setExporting(Boolean exporting) {
        this.exporting = exporting;
    }

    public TableConfiguration setExportTypes(String exportTypes) {
        return this;
    }

    public String getTableId() {
        return this.tableId;
    }

    public TableConfiguration addCssStyle(String cssStyle) {
        if (DatatableOptions.CSS_STYLE.valueFrom(this.getOptions()) == null) {
            DatatableOptions.CSS_STYLE.setIn(this.getOptions(), (Object)new StringBuilder());
        } else {
            DatatableOptions.CSS_STYLE.appendIn(this.getOptions(), ';');
        }
        DatatableOptions.CSS_STYLE.appendIn(this.getOptions(), cssStyle);
        return this;
    }

    public TableConfiguration addCssClass(String cssClass) {
        if (DatatableOptions.CSS_CLASS.valueFrom(this.getOptions()) == null) {
            DatatableOptions.CSS_CLASS.setIn(this.getOptions(), (Object)new StringBuilder());
        } else {
            DatatableOptions.CSS_CLASS.appendIn(this.getOptions(), ' ');
        }
        DatatableOptions.CSS_CLASS.appendIn(this.getOptions(), cssClass);
        return this;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ExportConf getExportConf(String format) {
        return this.exportConfigurations.get(format);
    }

    public Properties getMessages() {
        return this.messages;
    }

    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    public void setMessages(Properties messages) {
        this.messages = messages;
    }

    public String getMessage(String key) {
        return this.messages.getProperty(key);
    }

    public List<ExtraHtml> getExtraHtmlSnippets() {
        return this.extraHtmls;
    }

    public void setExtraHtmlSnippets(List<ExtraHtml> linkGroups) {
        this.extraHtmls = linkGroups;
    }

    public void addExtraHtmlSnippet(ExtraHtml extraHtml) {
        if (this.extraHtmls == null) {
            this.extraHtmls = new ArrayList<ExtraHtml>();
        }
        this.extraHtmls.add(extraHtml);
    }

    public String getCurrentExportFormat() {
        return this.currentExportFormat;
    }

    public void setCurrentExportFormat(String currentExport) {
        this.currentExportFormat = currentExport;
    }

    public void addOption(Option<?> option, Object value) {
        this.options.put(option, value);
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }
}

