/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.option;

import com.github.dandelion.core.asset.generator.js.JsFunction;
import com.github.dandelion.datatables.core.option.CallbackType;
import java.util.List;

public class Callback {
    private CallbackType type;
    private JsFunction function;

    public Callback(CallbackType type, String functionContent) {
        this.type = type;
        this.function = new JsFunction(functionContent, this.type.getArgs());
    }

    public Callback(CallbackType type, JsFunction function) {
        this.type = type;
        this.function = function;
    }

    public CallbackType getType() {
        return this.type;
    }

    public void setType(CallbackType type) {
        this.type = type;
    }

    public JsFunction getFunction() {
        return this.function;
    }

    public void setFunction(JsFunction function) {
        this.function = function;
    }

    public void appendCode(String code) {
        this.function.appendCode(code);
    }

    public static boolean hasCallback(CallbackType callbackType, List<Callback> callbacks) {
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                if (!callback.getType().equals((Object)callbackType)) continue;
                return true;
            }
        }
        return false;
    }

    public static Callback findByType(CallbackType type, List<Callback> callbacks) {
        for (Callback callback : callbacks) {
            if (!callback.getType().equals((Object)type)) continue;
            return callback;
        }
        return null;
    }

    public String toString() {
        return "Callback [type=" + (Object)((Object)this.type) + ", function=" + this.function + "]";
    }
}

