/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.html;

import com.github.dandelion.core.html.AbstractHtmlTag;
import com.github.dandelion.datatables.core.html.HtmlCaption;
import com.github.dandelion.datatables.core.html.HtmlRow;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import com.github.dandelion.datatables.core.option.TableConfiguration;
import com.github.dandelion.datatables.core.option.TableConfigurationFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HtmlTable
extends AbstractHtmlTag {
    private String originalId;
    private HtmlCaption caption;
    private List<HtmlRow> head = new LinkedList<HtmlRow>();
    private List<HtmlRow> body = new LinkedList<HtmlRow>();
    private List<HtmlRow> foot = new LinkedList<HtmlRow>();
    private TableConfiguration tableConfiguration;

    public HtmlTable(String id, HttpServletRequest request, HttpServletResponse response) {
        this(id, request, response, null, null);
    }

    public HtmlTable(String id, HttpServletRequest request, HttpServletResponse response, String groupName) {
        this(id, request, response, groupName, null);
    }

    public HtmlTable(String id, HttpServletRequest request, HttpServletResponse response, String groupName, Map<String, String> dynamicAttributes) {
        this.tag = "table";
        this.originalId = id;
        this.id = this.processId(id);
        this.dynamicAttributes = dynamicAttributes;
        this.tableConfiguration = TableConfigurationFactory.newInstance(id, request, groupName);
    }

    public StringBuilder toHtml() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)this.getHtmlOpeningTag());
        html.append((CharSequence)this.getHtmlHeader());
        html.append((CharSequence)this.getHtmlBody());
        html.append((CharSequence)this.getHtmlFooter());
        html.append((CharSequence)this.getHtmlClosingTag());
        return html;
    }

    private StringBuilder getHtmlHeader() {
        StringBuilder html = new StringBuilder();
        if (this.caption != null) {
            html.append((CharSequence)this.caption.toHtml());
        }
        html.append("<thead>");
        for (HtmlRow row : this.head) {
            html.append((CharSequence)row.toHtml());
        }
        html.append("</thead>");
        return html;
    }

    private StringBuilder getHtmlBody() {
        StringBuilder html = new StringBuilder();
        if (!this.body.isEmpty()) {
            html.append("<tbody>");
            for (HtmlRow row : this.body) {
                html.append((CharSequence)row.toHtml());
            }
            html.append("</tbody>");
        }
        return html;
    }

    private StringBuilder getHtmlFooter() {
        StringBuilder html = new StringBuilder();
        if (!this.foot.isEmpty()) {
            html.append("<tfoot>");
            for (HtmlRow row : this.foot) {
                html.append((CharSequence)row.toHtml());
            }
            html.append("</tfoot>");
        }
        return html;
    }

    protected StringBuilder getHtmlAttributes() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)HtmlTable.writeAttribute((String)"id", (Object)this.id));
        html.append((CharSequence)HtmlTable.writeAttribute((String)"class", (Object)DatatableOptions.CSS_CLASS.valueFrom(this.tableConfiguration.getOptions())));
        html.append((CharSequence)HtmlTable.writeAttribute((String)"style", (Object)DatatableOptions.CSS_STYLE.valueFrom(this.tableConfiguration.getOptions())));
        return html;
    }

    public HtmlCaption getCaption() {
        return this.caption;
    }

    public void setCaption(HtmlCaption caption) {
        this.caption = caption;
    }

    public List<HtmlRow> getHeadRows() {
        return this.head;
    }

    public List<HtmlRow> getBodyRows() {
        return this.body;
    }

    public HtmlRow addHeaderRow() {
        HtmlRow row = new HtmlRow();
        this.head.add(row);
        return row;
    }

    public HtmlRow addRow() {
        HtmlRow row = new HtmlRow();
        this.body.add(row);
        return row;
    }

    public HtmlRow addFooterRow() {
        HtmlRow row = new HtmlRow();
        this.foot.add(row);
        return row;
    }

    public HtmlRow addRow(String rowId) {
        HtmlRow row = new HtmlRow(rowId);
        this.body.add(row);
        return row;
    }

    public HtmlTable addRows(HtmlRow ... rows) {
        for (HtmlRow row : rows) {
            this.body.add(row);
        }
        return this;
    }

    public HtmlRow getLastFooterRow() {
        return (HtmlRow)((Object)((LinkedList)this.foot).getLast());
    }

    public HtmlRow getFirstHeaderRow() {
        return (HtmlRow)((Object)((LinkedList)this.head).getFirst());
    }

    public HtmlRow getLastHeaderRow() {
        return (HtmlRow)((Object)((LinkedList)this.head).getLast());
    }

    public HtmlRow getLastBodyRow() {
        return (HtmlRow)((Object)((LinkedList)this.body).getLast());
    }

    public void addCssStyle(String cssStyle) {
        if (DatatableOptions.CSS_STYLE.valueFrom(this.tableConfiguration.getOptions()) == null) {
            DatatableOptions.CSS_STYLE.setIn(this.tableConfiguration.getOptions(), (Object)new StringBuilder());
        } else {
            DatatableOptions.CSS_STYLE.appendIn(this.tableConfiguration.getOptions(), ';');
        }
        DatatableOptions.CSS_STYLE.appendIn(this.tableConfiguration.getOptions(), cssStyle);
    }

    public void addCssClass(String cssClass) {
        if (DatatableOptions.CSS_CLASS.valueFrom(this.tableConfiguration.getOptions()) == null) {
            DatatableOptions.CSS_CLASS.setIn(this.tableConfiguration.getOptions(), (Object)new StringBuilder());
        } else {
            DatatableOptions.CSS_CLASS.appendIn(this.tableConfiguration.getOptions(), ' ');
        }
        DatatableOptions.CSS_CLASS.appendIn(this.tableConfiguration.getOptions(), cssClass);
    }

    public TableConfiguration getTableConfiguration() {
        return this.tableConfiguration;
    }

    public void setTableConfiguration(TableConfiguration tableConfiguration) {
        this.tableConfiguration = tableConfiguration;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    private String processId(String id) {
        return id.replaceAll("[^A-Za-z0-9 ]", "");
    }
}

