/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.html;

import com.github.dandelion.core.html.AbstractHtmlTag;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class HtmlRow
extends AbstractHtmlTag {
    private List<HtmlColumn> columns = new LinkedList<HtmlColumn>();

    public HtmlRow() {
        this.tag = "tr";
    }

    public HtmlRow(String id) {
        this.tag = "tr";
        this.id = id;
    }

    public StringBuilder toHtml() {
        StringBuilder html = new StringBuilder();
        html.append((CharSequence)this.getHtmlOpeningTag());
        html.append((CharSequence)this.getHtmlColumns());
        html.append((CharSequence)this.getHtmlClosingTag());
        return html;
    }

    private StringBuilder getHtmlColumns() {
        StringBuilder html = new StringBuilder();
        for (HtmlColumn column : this.columns) {
            if (!CollectionUtils.containsAny(column.getEnabledDisplayTypes(), "all", "html")) continue;
            html.append((CharSequence)column.toHtml());
        }
        return html;
    }

    public List<HtmlColumn> getColumns(String ... enabledFormats) {
        ArrayList<HtmlColumn> result = new ArrayList<HtmlColumn>();
        for (HtmlColumn column : this.columns) {
            for (String enabledFormat : enabledFormats) {
                if (!column.getEnabledDisplayTypes().contains(enabledFormat)) continue;
                result.add(column);
            }
        }
        return result;
    }

    public List<HtmlColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<HtmlColumn> columns) {
        this.columns = columns;
    }

    public HtmlColumn addHeaderColumn(HtmlColumn headerColumn) {
        this.columns.add(headerColumn);
        return headerColumn;
    }

    public HtmlColumn addHeaderColumn(String columnContent) {
        HtmlColumn newColumn = new HtmlColumn(true, columnContent);
        this.columns.add(newColumn);
        return newColumn;
    }

    public HtmlColumn addColumn(HtmlColumn column) {
        this.columns.add(column);
        return column;
    }

    public HtmlColumn addColumn(String columnContent) {
        HtmlColumn newColumn = new HtmlColumn(false, columnContent);
        this.columns.add(newColumn);
        return newColumn;
    }

    public HtmlColumn addColumn(String columnContent, String displayFormat) {
        HtmlColumn newColumn = new HtmlColumn(false, columnContent);
        HashSet<String> enabledDisplayTypes = new HashSet<String>();
        enabledDisplayTypes.add(displayFormat.trim().toLowerCase());
        newColumn.setEnabledDisplayTypes(enabledDisplayTypes);
        this.columns.add(newColumn);
        return newColumn;
    }

    public HtmlRow addHeaderColumns(String ... columns) {
        for (String columnContent : columns) {
            this.addHeaderColumn(columnContent);
        }
        return this;
    }

    public List<HtmlColumn> getHeaderColumns() {
        ArrayList<HtmlColumn> retval = new ArrayList<HtmlColumn>();
        for (HtmlColumn column : this.columns) {
            if (!column.isHeaderColumn().booleanValue()) continue;
            retval.add(column);
        }
        return retval;
    }

    public HtmlRow addColumns(String ... columns) {
        for (String columnContent : columns) {
            this.addColumn(columnContent);
        }
        return this;
    }

    public HtmlColumn getLastColumn() {
        return (HtmlColumn)((Object)((LinkedList)this.columns).getLast());
    }

    public String toString() {
        return "HtmlRow [columns=" + this.columns + "]";
    }
}

