/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.generator;

import com.github.dandelion.core.asset.generator.js.JsSnippet;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.ColumnConfiguration;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import com.github.dandelion.datatables.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YadcfConfigGenerator {
    private static Logger logger = LoggerFactory.getLogger(YadcfConfigGenerator.class);

    public List<Map<String, Object>> generateConfig(HtmlTable table) {
        logger.debug("Generating YADCF Filtering configuration...");
        ArrayList<Map<String, Object>> retval = new ArrayList<Map<String, Object>>();
        int columnIndex = 0;
        for (HtmlColumn column : table.getLastHeaderRow().getColumns()) {
            Set<String> enabledDisplayTypes = column.getEnabledDisplayTypes();
            if (CollectionUtils.containsAny(enabledDisplayTypes, "all", "html")) {
                Integer filterColumnDelay;
                String filterSelector;
                String filterValues;
                String selector;
                HashMap<String, Object> columnConf = new HashMap<String, Object>();
                ColumnConfiguration columnConfiguration = column.getColumnConfiguration();
                Boolean filterable = (Boolean)DatatableOptions.FILTERABLE.valueFrom(columnConfiguration.getOptions());
                if (filterable != null && filterable.booleanValue()) {
                    columnConf.put("column_number", columnIndex);
                    FilterType filterType = (FilterType)((Object)DatatableOptions.FILTERTYPE.valueFrom(columnConfiguration.getOptions()));
                    if (filterType != null) {
                        switch (filterType) {
                            case INPUT: {
                                columnConf.put("filter_type", "text");
                                break;
                            }
                            case SELECT: {
                                columnConf.put("filter_type", "select");
                            }
                        }
                    } else {
                        columnConf.put("filter_type", "text");
                    }
                    retval.add(columnConf);
                }
                if (StringUtils.isNotBlank((String)(selector = (String)DatatableOptions.SELECTOR.valueFrom(columnConfiguration.getOptions())))) {
                    columnConf.put("filter_container_id", selector);
                }
                if (StringUtils.isNotBlank((String)(filterValues = (String)DatatableOptions.FILTERVALUES.valueFrom(columnConfiguration.getOptions())))) {
                    columnConf.put("data", new JsSnippet(filterValues));
                }
                if (StringUtils.isNotBlank((String)(filterSelector = (String)DatatableOptions.FEATURE_FILTER_SELECTOR.valueFrom(table.getTableConfiguration().getOptions())))) {
                    columnConf.put("externally_triggered", true);
                }
                if ((filterColumnDelay = (Integer)DatatableOptions.FEATURE_FILTER_DELAY.valueFrom(table.getTableConfiguration().getOptions())) != null) {
                    columnConf.put("filter_delay", filterColumnDelay);
                }
            }
            ++columnIndex;
        }
        logger.debug("Column filtering configuration generated");
        return retval;
    }

    public static enum FilterType {
        SELECT,
        INPUT;

    }
}

