/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.generator;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.asset.generator.js.jquery.JQueryContent;
import com.github.dandelion.datatables.core.extension.ExtensionLoader;
import com.github.dandelion.datatables.core.generator.DatatableConfigGenerator;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatableJQueryContent
extends JQueryContent {
    protected static Logger logger = LoggerFactory.getLogger(DatatableJQueryContent.class);
    private final String processedId;
    private final String originalId;
    private final ExtensionLoader extensionLoader;
    private final DatatableConfigGenerator configGenerator;

    public DatatableJQueryContent(HtmlTable htmlTable) {
        this.processedId = htmlTable.getId();
        this.originalId = htmlTable.getOriginalId();
        logger.debug("Generating the main configuration for the table with id: {}", (Object)this.originalId);
        this.configGenerator = new DatatableConfigGenerator();
        Map<String, Object> mainConf = this.configGenerator.generateConfig(htmlTable);
        logger.debug("Loading extensions for the table with id: {}", (Object)this.originalId);
        this.extensionLoader = new ExtensionLoader();
        this.extensionLoader.loadExtensions(htmlTable, this, mainConf);
        logger.debug("Transforming configuration to JSON...");
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            JSONValue.writeJSONString(mainConf, (Writer)writer);
        }
        catch (IOException e) {
            throw new DandelionException("Unable to generate the JSON configuration", (Throwable)e);
        }
        this.appendToBeforeAll(this.getJavaScriptVariables(this, ((Object)writer).toString()).toString());
        this.appendToComponentConfiguration(this.getComponentConf(this).toString());
    }

    private StringBuilder getComponentConf(DatatableJQueryContent datatableContent) {
        StringBuilder datatablesConfiguration = new StringBuilder();
        datatablesConfiguration.append("oTable_").append(this.processedId).append("=$('#").append(this.originalId).append("').DataTable(oTable_").append(this.processedId).append("_params)");
        datatablesConfiguration.append(";");
        return datatablesConfiguration;
    }

    private StringBuilder getJavaScriptVariables(DatatableJQueryContent datatableAssetBuffer, String datatableConfig) {
        StringBuilder variables = new StringBuilder();
        variables.append("var oTable_").append(this.processedId).append(";");
        variables.append("var oTable_").append(this.processedId).append("_params=").append(datatableConfig).append(";");
        return variables;
    }
}

