/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.generator;

import com.github.dandelion.core.asset.generator.js.JsSnippet;
import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.extension.feature.PagingType;
import com.github.dandelion.datatables.core.generator.AbstractConfigGenerator;
import com.github.dandelion.datatables.core.generator.DTMessages;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.Callback;
import com.github.dandelion.datatables.core.option.ColumnConfiguration;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import com.github.dandelion.datatables.core.option.Direction;
import com.github.dandelion.datatables.core.option.TableConfiguration;
import com.github.dandelion.datatables.core.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatatableConfigGenerator
extends AbstractConfigGenerator {
    private static Logger logger = LoggerFactory.getLogger(DatatableConfigGenerator.class);

    @Override
    public Map<String, Object> generateConfig(HtmlTable table) {
        TableConfiguration tableConfiguration = table.getTableConfiguration();
        logger.debug("Generating DataTables configuration ..");
        HashMap<String, Object> mainConf = new HashMap<String, Object>();
        this.generateColumnConfiguration(mainConf, table, tableConfiguration);
        this.generateI18nConfiguration(mainConf, tableConfiguration);
        this.generateFeatureEnablementConfiguration(mainConf, tableConfiguration);
        this.generateScrollingConfiguration(mainConf, tableConfiguration);
        this.generateMiscConfiguration(mainConf, tableConfiguration);
        this.generateAjaxConfiguration(mainConf, tableConfiguration);
        this.generateCallbackConfiguration(mainConf, tableConfiguration);
        logger.debug("DataTables configuration generated");
        return mainConf;
    }

    private void generateScrollingConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        String featureScrollY = (String)DatatableOptions.FEATURE_SCROLLY.valueFrom(tableConfiguration.getOptions());
        Boolean featureScrollCollapse = (Boolean)DatatableOptions.FEATURE_SCROLLCOLLAPSE.valueFrom(tableConfiguration.getOptions());
        String featureScrollX = (String)DatatableOptions.FEATURE_SCROLLX.valueFrom(tableConfiguration.getOptions());
        String featureScrollXInner = (String)DatatableOptions.FEATURE_SCROLLXINNER.valueFrom(tableConfiguration.getOptions());
        if (StringUtils.isNotBlank((String)featureScrollY)) {
            mainConf.put("scrollY", featureScrollY);
        }
        if (featureScrollCollapse != null) {
            mainConf.put("scrollCollapse", featureScrollCollapse);
        }
        if (StringUtils.isNotBlank((String)featureScrollX)) {
            mainConf.put("scrollX", featureScrollX);
        }
        if (StringUtils.isNotBlank((String)featureScrollXInner)) {
            mainConf.put("scrollXInner", featureScrollXInner);
        }
    }

    private void generateFeatureEnablementConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        Boolean featureFilterable = (Boolean)DatatableOptions.FEATURE_FILTERABLE.valueFrom(tableConfiguration.getOptions());
        Boolean featureInfo = (Boolean)DatatableOptions.FEATURE_INFO.valueFrom(tableConfiguration.getOptions());
        Boolean featurePaginate = (Boolean)DatatableOptions.FEATURE_PAGEABLE.valueFrom(tableConfiguration.getOptions());
        Boolean featureSort = (Boolean)DatatableOptions.FEATURE_SORTABLE.valueFrom(tableConfiguration.getOptions());
        Boolean featureProcessing = (Boolean)DatatableOptions.FEATURE_PROCESSING.valueFrom(tableConfiguration.getOptions());
        if (featureFilterable != null) {
            mainConf.put("searching", featureFilterable);
        }
        if (featureInfo != null) {
            mainConf.put("info", featureInfo);
        }
        if (featurePaginate != null) {
            mainConf.put("paging", featurePaginate);
        }
        if (featureSort != null) {
            mainConf.put("ordering", featureSort);
        }
        if (featureProcessing != null) {
            mainConf.put("processing", featureProcessing);
        }
    }

    private void generateMiscConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        String featureDom = (String)DatatableOptions.FEATURE_DOM.valueFrom(tableConfiguration.getOptions());
        Boolean featureAutoWidth = (Boolean)DatatableOptions.FEATURE_AUTOWIDTH.valueFrom(tableConfiguration.getOptions());
        String featureLengthMenu = (String)DatatableOptions.FEATURE_LENGTHMENU.valueFrom(tableConfiguration.getOptions());
        String cssStripeClasses = (String)DatatableOptions.CSS_STRIPECLASSES.valueFrom(tableConfiguration.getOptions());
        Integer featureDisplayLength = (Integer)DatatableOptions.FEATURE_DISPLAYLENGTH.valueFrom(tableConfiguration.getOptions());
        Boolean featureLengthChange = (Boolean)DatatableOptions.FEATURE_LENGTHCHANGE.valueFrom(tableConfiguration.getOptions());
        PagingType featurePaginationType = (PagingType)((Object)DatatableOptions.FEATURE_PAGINGTYPE.valueFrom(tableConfiguration.getOptions()));
        Boolean featureStateSave = (Boolean)DatatableOptions.FEATURE_STATESAVE.valueFrom(tableConfiguration.getOptions());
        Boolean featureJqueryUi = (Boolean)DatatableOptions.FEATURE_JQUERYUI.valueFrom(tableConfiguration.getOptions());
        if (StringUtils.isNotBlank((String)featureDom)) {
            mainConf.put("dom", featureDom);
        }
        if (featureAutoWidth != null) {
            mainConf.put("autoWidth", featureAutoWidth);
        }
        if (featureDisplayLength != null) {
            mainConf.put("pageLength", featureDisplayLength);
        }
        if (featureLengthChange != null) {
            mainConf.put("lengthChange", featureLengthChange);
        }
        if (featurePaginationType != null) {
            mainConf.put("pagingType", featurePaginationType.toString());
        }
        if (featureStateSave != null) {
            mainConf.put("stateSave", featureStateSave);
        }
        if (featureJqueryUi != null) {
            mainConf.put("jQueryUI", featureJqueryUi);
        }
        if (StringUtils.isNotBlank((String)featureLengthMenu)) {
            mainConf.put("lengthMenu", new JsSnippet(featureLengthMenu));
        }
        if (StringUtils.isNotBlank((String)cssStripeClasses)) {
            mainConf.put("stripeClasses", new JsSnippet(cssStripeClasses));
        }
    }

    private void generateColumnConfiguration(Map<String, Object> mainConf, HtmlTable table, TableConfiguration tableConfiguration) {
        HashMap<String, Object> tmp = null;
        ArrayList aoColumnsContent = new ArrayList();
        for (HtmlColumn column : table.getLastHeaderRow().getColumns()) {
            String sortType;
            List sortDirections;
            String defaultValue;
            String renderFunction;
            String property;
            Boolean visible;
            Boolean searchable;
            Boolean bl;
            ColumnConfiguration columnConfiguration = column.getColumnConfiguration();
            Set<String> enabledDisplayTypes = column.getEnabledDisplayTypes();
            if (!CollectionUtils.containsAny(enabledDisplayTypes, "all", "html")) continue;
            tmp = new HashMap<String, Object>();
            String name = (String)DatatableOptions.NAME.valueFrom(columnConfiguration.getOptions());
            if (StringUtils.isNotBlank((String)name)) {
                tmp.put("name", name);
            }
            if ((bl = (Boolean)DatatableOptions.SORTABLE.valueFrom(columnConfiguration.getOptions())) != null) {
                tmp.put("orderable", bl);
            }
            if ((searchable = (Boolean)DatatableOptions.SEARCHABLE.valueFrom(columnConfiguration.getOptions())) != null) {
                tmp.put("searchable", searchable);
            }
            if ((visible = (Boolean)DatatableOptions.VISIBLE.valueFrom(columnConfiguration.getOptions())) != null) {
                tmp.put("visible", visible);
            }
            if (StringUtils.isNotBlank((String)(property = (String)DatatableOptions.PROPERTY.valueFrom(columnConfiguration.getOptions())))) {
                tmp.put("data", property);
            }
            if (StringUtils.isNotBlank((String)(renderFunction = (String)DatatableOptions.RENDERFUNCTION.valueFrom(columnConfiguration.getOptions())))) {
                tmp.put("render", new JsSnippet(renderFunction));
            }
            if ((defaultValue = (String)DatatableOptions.DEFAULTVALUE.valueFrom(columnConfiguration.getOptions())) != null) {
                tmp.put("defaultContent", defaultValue);
            } else {
                tmp.put("defaultContent", "");
            }
            StringBuilder cssCellClass = (StringBuilder)DatatableOptions.CSSCELLCLASS.valueFrom(columnConfiguration.getOptions());
            String ajaxSource = (String)DatatableOptions.AJAX_SOURCE.valueFrom(table.getTableConfiguration().getOptions());
            if (StringUtils.isNotBlank((String)ajaxSource) && cssCellClass != null && StringUtils.isNotBlank((String)cssCellClass.toString())) {
                tmp.put("className", cssCellClass.toString());
            }
            if ((sortDirections = (List)DatatableOptions.SORTDIRECTION.valueFrom(columnConfiguration.getOptions())) != null) {
                ArrayList<String> directions = new ArrayList<String>();
                for (Direction direction : sortDirections) {
                    directions.add(direction.value);
                }
                tmp.put("asSorting", directions);
            }
            if (StringUtils.isNotBlank((String)(sortType = (String)DatatableOptions.SORTTYPE.valueFrom(columnConfiguration.getOptions())))) {
                tmp.put("type", sortType);
            }
            aoColumnsContent.add(tmp);
        }
        mainConf.put("columns", aoColumnsContent);
        ArrayList<Integer> aaSortingtmp = null;
        ArrayList aaSortingContent = new ArrayList();
        TreeMap sortedColumnMap = new TreeMap();
        int columnIndex = 0;
        for (HtmlColumn htmlColumn : table.getLastHeaderRow().getColumns("all", "html")) {
            HashMap<Integer, String> value;
            String sortInitDirection = (String)DatatableOptions.SORTINITDIRECTION.valueFrom(htmlColumn.getColumnConfiguration().getOptions());
            Integer sortInitOrder = (Integer)DatatableOptions.SORTINITORDER.valueFrom(htmlColumn.getColumnConfiguration().getOptions());
            if (sortInitOrder != null && StringUtils.isNotBlank((String)sortInitDirection)) {
                value = new HashMap<Integer, String>();
                value.put(columnIndex, sortInitDirection);
                sortedColumnMap.put(sortInitOrder, value);
            } else if (StringUtils.isNotBlank((String)sortInitDirection)) {
                value = new HashMap();
                value.put(columnIndex, sortInitDirection);
                sortedColumnMap.put(sortedColumnMap.keySet().size(), value);
            }
            ++columnIndex;
        }
        for (Map.Entry entry : sortedColumnMap.entrySet()) {
            aaSortingtmp = new ArrayList<Integer>();
            Integer key = (Integer)((Map)entry.getValue()).entrySet().iterator().next().getKey();
            aaSortingtmp.add(key);
            aaSortingtmp.add((Integer)((Map)entry.getValue()).get(key));
            aaSortingContent.add(aaSortingtmp);
        }
        if (!aaSortingContent.isEmpty()) {
            mainConf.put("order", aaSortingContent);
        }
    }

    private void generateI18nConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        HashMap<String, Object> languageMap = new HashMap<String, Object>();
        HashMap<String, Object> languagePaginateMap = new HashMap<String, Object>();
        HashMap<String, Object> languageAriaMap = new HashMap<String, Object>();
        if (tableConfiguration.getMessages() != null && tableConfiguration.getMessages().size() > 0) {
            block0: for (Map.Entry<Object, Object> entry : tableConfiguration.getMessages().entrySet()) {
                for (DTMessages conf : DTMessages.values()) {
                    if (!entry.getKey().equals(conf.getPropertyName())) continue;
                    if (entry.getKey().toString().contains("paginate")) {
                        languagePaginateMap.put(conf.getRealName(), entry.getValue());
                        continue block0;
                    }
                    if (entry.getKey().toString().contains("aria")) {
                        languageAriaMap.put(conf.getRealName(), entry.getValue());
                        continue block0;
                    }
                    languageMap.put(conf.getRealName(), entry.getValue());
                    continue block0;
                }
            }
        }
        if (languagePaginateMap.size() > 0) {
            languageMap.put(DTMessages.PAGINATE.getRealName(), languagePaginateMap);
        }
        if (languageAriaMap.size() > 0) {
            languageMap.put(DTMessages.ARIA.getRealName(), languageAriaMap);
        }
        if (languageMap.size() > 0) {
            mainConf.put("language", languageMap);
        }
    }

    private void generateAjaxConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        Boolean ajaxServerSide = (Boolean)DatatableOptions.AJAX_SERVERSIDE.valueFrom(tableConfiguration.getOptions());
        Boolean ajaxDeferRender = (Boolean)DatatableOptions.AJAX_DEFERRENDER.valueFrom(tableConfiguration.getOptions());
        Object ajaxDeferLoading = DatatableOptions.AJAX_DEFERLOADING.valueFrom(tableConfiguration.getOptions());
        if (ajaxServerSide != null) {
            mainConf.put("serverSide", ajaxServerSide);
        }
        if (ajaxDeferRender != null) {
            mainConf.put("deferRender", ajaxDeferRender);
        }
        if (ajaxDeferLoading != null) {
            mainConf.put("deferLoading", ajaxDeferLoading);
        }
    }

    private void generateCallbackConfiguration(Map<String, Object> mainConf, TableConfiguration tableConfiguration) {
        if (tableConfiguration.getCallbacks() != null) {
            for (Callback callback : tableConfiguration.getCallbacks()) {
                mainConf.put(callback.getType().getName(), callback.getFunction());
            }
        }
    }
}

