/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.plugin;

import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.DatatableBundles;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONValue;

public class FixedHeaderPlugin
extends AbstractExtension {
    public static final String FIXEDHEADER_PLUGIN_NAME = "fixedHeader";

    @Override
    public String getExtensionName() {
        return FIXEDHEADER_PLUGIN_NAME;
    }

    @Override
    public void setup(HtmlTable table) {
        this.addBundle(DatatableBundles.DATATABLES_FIXEDHEADER);
        Map<String, Object> specificConfObj = this.getSpecificCongiguration(table);
        String specificConfStr = JSONValue.toJSONString(specificConfObj);
        this.appendToBeforeEndDocumentReady("new FixedHeader(oTable_" + table.getId() + "," + specificConfStr + ");");
    }

    private Map<String, Object> getSpecificCongiguration(HtmlTable table) {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String fixedPosition = (String)DatatableOptions.PLUGIN_FIXEDPOSITION.valueFrom(table.getTableConfiguration().getOptions());
        Integer fixedOffset = (Integer)DatatableOptions.PLUGIN_FIXEDOFFSETTOP.valueFrom(table.getTableConfiguration().getOptions());
        if (StringUtils.isNotBlank((String)fixedPosition)) {
            if (fixedPosition.toLowerCase().equals("bottom")) {
                conf.put("bottom", true);
            } else if (fixedPosition.toLowerCase().equals("right")) {
                conf.put("right", true);
            } else if (fixedPosition.toLowerCase().equals("left")) {
                conf.put("left", true);
            } else {
                conf.put("top", true);
            }
        } else {
            conf.put("top", true);
        }
        if (fixedOffset != null) {
            conf.put("offsetTop", fixedOffset);
        }
        return conf;
    }
}

