/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.extension.feature.SortType;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.DatatableOptions;

public class SortingFeature
extends AbstractExtension {
    public static final String SORTING_FEATURE_NAME = "sorting";

    @Override
    public String getExtensionName() {
        return SORTING_FEATURE_NAME;
    }

    @Override
    public void setup(HtmlTable table) {
        for (HtmlColumn column : table.getLastHeaderRow().getColumns()) {
            SortType sortType;
            String sortTypeString = (String)DatatableOptions.SORTTYPE.valueFrom(column.getColumnConfiguration().getOptions());
            if (!StringUtils.isNotBlank((String)sortTypeString) || (sortType = SortType.findByName(sortTypeString)) == null) continue;
            this.addBundle(sortType.getBundle());
        }
    }
}

