/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.DatatableBundles;

public enum SortType {
    ALT_STRING("alt-string", DatatableBundles.DDL_DT_SORTING_ALT_STRING),
    ANTI_THE("anti-the", DatatableBundles.DDL_DT_SORTING_ANTI_THE),
    CHINESE_STRING("chinese_string", DatatableBundles.DDL_DT_SORTING_CHINESE_STRING),
    DATE_DE("date-de", DatatableBundles.DDL_DT_SORTING_DATE_DE),
    DATE_EU("date-eu", DatatableBundles.DDL_DT_SORTING_DATE_EU),
    DATE_EURO("date-euro", DatatableBundles.DDL_DT_SORTING_DATE_EURO),
    DATE_UK("date-uk", DatatableBundles.DDL_DT_SORTING_DATE_UK),
    FILESIZE("file-size", DatatableBundles.DDL_DT_SORTING_FILESIZE),
    IP_ADDRESS("ip-address", DatatableBundles.DDL_DT_SORTING_IP),
    NATURAL("natural", DatatableBundles.DDL_DT_SORTING_NATURAL),
    PERSIAN("persian", DatatableBundles.DDL_DT_SORTING_PERSIAN),
    SCIENTIFIC("scientific", DatatableBundles.DDL_DT_SORTING_SCIENTIFIC),
    SIGNED_NUM("signed-num", DatatableBundles.DDL_DT_SORTING_SIGNED_NUM),
    TURKISH_STRING("turkish-string", DatatableBundles.DDL_DT_SORTING_TURKISH_STRING);

    private String name;
    private DatatableBundles bundle;

    private SortType(String name, DatatableBundles bundle) {
        this.name = name;
        this.bundle = bundle;
    }

    public String getName() {
        return this.name;
    }

    public DatatableBundles getBundle() {
        return this.bundle;
    }

    public static SortType findByName(String name) {
        if (StringUtils.isBlank((String)name)) {
            return null;
        }
        for (SortType sortType : SortType.values()) {
            if (!name.trim().equalsIgnoreCase(sortType.getName())) continue;
            return sortType;
        }
        return null;
    }
}

