/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.util.StringUtils;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.CallbackType;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import java.util.HashMap;
import java.util.Map;

public class ServerSideFeature
extends AbstractExtension {
    public static final String SERVER_SIDE_FEATURE_NAME = "serverSide";

    @Override
    public String getExtensionName() {
        return SERVER_SIDE_FEATURE_NAME;
    }

    @Override
    public void setup(HtmlTable table) {
        HashMap<String, Object> ajaxParams = new HashMap<String, Object>();
        ajaxParams.put("url", DatatableOptions.AJAX_SOURCE.valueFrom(table.getTableConfiguration().getOptions()));
        ajaxParams.put("dataSrc", "data");
        String extraParams = (String)DatatableOptions.AJAX_PARAMS.valueFrom(table.getTableConfiguration().getOptions());
        if (StringUtils.isNotBlank((String)extraParams)) {
            StringBuilder paramObject = new StringBuilder("oTable_").append(table.getId()).append("_params");
            StringBuilder js = new StringBuilder();
            js.append((CharSequence)paramObject).append(".ajax = ");
            js.append(extraParams);
            js.append("();\n");
            for (Map.Entry ajaxParam : ajaxParams.entrySet()) {
                js.append((CharSequence)paramObject).append(".ajax.").append((String)ajaxParam.getKey()).append(" = '").append((String)ajaxParam.getValue());
                js.append("';\n");
            }
            this.appendToAfterStartDocumentReady(js.toString());
        } else {
            this.addParameter("ajax", ajaxParams);
        }
        this.addCallback(CallbackType.INIT, "oTable_" + table.getId() + ".columns.adjust().draw();");
    }
}

