/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.asset.generator.js.JsSnippet;
import com.github.dandelion.datatables.core.DatatableBundles;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.core.option.DatatableOptions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.json.simple.JSONValue;

public class PipeliningFeature
extends AbstractExtension {
    public static final String PIPELINING_FEATURE_NAME = "pipelining";

    @Override
    public String getExtensionName() {
        return PIPELINING_FEATURE_NAME;
    }

    @Override
    public void setup(HtmlTable table) {
        this.addBundle(DatatableBundles.DDL_DT_AJAX_PIPELINING);
        Integer pipeSize = (Integer)DatatableOptions.AJAX_PIPESIZE.valueFrom(table.getTableConfiguration().getOptions());
        HashMap<String, Object> ajaxParams = new HashMap<String, Object>();
        ajaxParams.put("url", DatatableOptions.AJAX_SOURCE.valueFrom(table.getTableConfiguration().getOptions()));
        if (pipeSize != null) {
            ajaxParams.put("pages", pipeSize);
        } else {
            ajaxParams.put("pages", 5);
        }
        StringWriter writer = new StringWriter();
        try {
            JSONValue.writeJSONString(ajaxParams, (Writer)writer);
        }
        catch (IOException e) {
            throw new DandelionException("Unable to convert the configuration to JSON", (Throwable)e);
        }
        this.addParameter("ajax", new JsSnippet("$.fn.dataTable.pipeline( " + ((Object)writer).toString() + ")"));
    }
}

