/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.core.extension.feature;

import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.AssetMapper;
import com.github.dandelion.core.asset.AssetType;
import com.github.dandelion.core.asset.locator.AssetLocator;
import com.github.dandelion.core.storage.AssetStorageUnit;
import com.github.dandelion.datatables.core.extension.AbstractExtension;
import com.github.dandelion.datatables.core.extension.feature.ExtraJs;
import com.github.dandelion.datatables.core.html.HtmlTable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ExtraJsFeature
extends AbstractExtension {
    public static final String EXTRA_JS_FEATURE_NAME = "extraJs";

    @Override
    public String getExtensionName() {
        return EXTRA_JS_FEATURE_NAME;
    }

    @Override
    public void setup(HtmlTable table) {
        AssetMapper assetMapper = new AssetMapper(this.getContext(), table.getTableConfiguration().getRequest());
        HttpServletRequest request = table.getTableConfiguration().getRequest();
        LinkedHashSet assetsToInject = null;
        for (ExtraJs extraJs : table.getTableConfiguration().getExtraJs()) {
            assetsToInject = new LinkedHashSet();
            for (String bundleName : extraJs.getBundles()) {
                if (!this.getContext().getBundleStorage().getBundleDag().getVertexMap().containsKey(bundleName)) {
                    throw new DandelionException("The requested bundle \"" + bundleName + "\" does not exist in the graph.");
                }
                assetsToInject.addAll(this.getContext().getBundleStorage().getBundleDag().getVertex(bundleName).getAssetStorageUnits());
            }
            LinkedHashSet<AssetStorageUnit> filteredAsus = new LinkedHashSet<AssetStorageUnit>();
            for (AssetStorageUnit asu : assetsToInject) {
                if (!asu.getType().equals((Object)AssetType.js)) continue;
                filteredAsus.add(asu);
            }
            Set processedAssets = assetMapper.mapToAssets(filteredAsus);
            Map locators = this.getContext().getAssetLocatorsMap();
            for (Asset asset : processedAssets) {
                AssetLocator locator = (AssetLocator)locators.get(asset.getConfigLocationKey());
                String content = locator.getContent(asset, request);
                switch (extraJs.getPlaceholder()) {
                    case BEFORE_ALL: {
                        this.appendToBeforeAll(content);
                        break;
                    }
                    case BEFORE_START_DOCUMENT_READY: {
                        this.appendToBeforeStartDocumentReady(content);
                        break;
                    }
                    case AFTER_START_DOCUMENT_READY: {
                        this.appendToAfterStartDocumentReady(content);
                        break;
                    }
                    case COMPONENT_CONFIGURATION: {
                        this.appendToComponentConfiguration(content);
                        break;
                    }
                    case BEFORE_END_DOCUMENT_READY: {
                        this.appendToBeforeEndDocumentReady(content);
                        break;
                    }
                    case AFTER_END_DOCUMENT_READY: {
                        this.appendToAfterEndDocumentReady(content);
                        break;
                    }
                    case AFTER_ALL: {
                        this.appendToAfterAll(content);
                    }
                }
            }
        }
    }
}

